/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ec2client;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.wso2.carbon.ec2.client.stub.AllocateAddress;
import org.wso2.carbon.ec2.client.stub.AllocateAddressResponse;
import org.wso2.carbon.ec2.client.stub.AllocateAddressType;
import org.wso2.carbon.ec2.client.stub.AmazonEC2Stub;
import org.wso2.carbon.ec2.client.stub.AssociateAddress;
import org.wso2.carbon.ec2.client.stub.AssociateAddressResponse;
import org.wso2.carbon.ec2.client.stub.AssociateAddressResponseType;
import org.wso2.carbon.ec2.client.stub.AssociateAddressType;
import org.wso2.carbon.ec2.client.stub.AvailabilityZoneItemType;
import org.wso2.carbon.ec2.client.stub.DeregisterImage;
import org.wso2.carbon.ec2.client.stub.DeregisterImageResponse;
import org.wso2.carbon.ec2.client.stub.DeregisterImageType;
import org.wso2.carbon.ec2.client.stub.DescribeAddresses;
import org.wso2.carbon.ec2.client.stub.DescribeAddressesInfoType;
import org.wso2.carbon.ec2.client.stub.DescribeAddressesItemType;
import org.wso2.carbon.ec2.client.stub.DescribeAddressesResponse;
import org.wso2.carbon.ec2.client.stub.DescribeAddressesResponseItemType;
import org.wso2.carbon.ec2.client.stub.DescribeAddressesType;
import org.wso2.carbon.ec2.client.stub.DescribeAvailabilityZones;
import org.wso2.carbon.ec2.client.stub.DescribeAvailabilityZonesResponse;
import org.wso2.carbon.ec2.client.stub.DescribeAvailabilityZonesSetItemType;
import org.wso2.carbon.ec2.client.stub.DescribeAvailabilityZonesSetType;
import org.wso2.carbon.ec2.client.stub.DescribeAvailabilityZonesType;
import org.wso2.carbon.ec2.client.stub.DescribeImages;
import org.wso2.carbon.ec2.client.stub.DescribeImagesExecutableBySetType;
import org.wso2.carbon.ec2.client.stub.DescribeImagesInfoType;
import org.wso2.carbon.ec2.client.stub.DescribeImagesOwnersType;
import org.wso2.carbon.ec2.client.stub.DescribeImagesResponse;
import org.wso2.carbon.ec2.client.stub.DescribeImagesResponseItemType;
import org.wso2.carbon.ec2.client.stub.DescribeImagesType;
import org.wso2.carbon.ec2.client.stub.DescribeInstances;
import org.wso2.carbon.ec2.client.stub.DescribeInstancesInfoType;
import org.wso2.carbon.ec2.client.stub.DescribeInstancesItemType;
import org.wso2.carbon.ec2.client.stub.DescribeInstancesResponse;
import org.wso2.carbon.ec2.client.stub.DescribeInstancesType;
import org.wso2.carbon.ec2.client.stub.DescribeKeyPairs;
import org.wso2.carbon.ec2.client.stub.DescribeKeyPairsInfoType;
import org.wso2.carbon.ec2.client.stub.DescribeKeyPairsItemType;
import org.wso2.carbon.ec2.client.stub.DescribeKeyPairsResponse;
import org.wso2.carbon.ec2.client.stub.DescribeKeyPairsResponseItemType;
import org.wso2.carbon.ec2.client.stub.DescribeKeyPairsType;
import org.wso2.carbon.ec2.client.stub.DescribeSecurityGroups;
import org.wso2.carbon.ec2.client.stub.DescribeSecurityGroupsResponse;
import org.wso2.carbon.ec2.client.stub.DescribeSecurityGroupsSetItemType;
import org.wso2.carbon.ec2.client.stub.DescribeSecurityGroupsSetType;
import org.wso2.carbon.ec2.client.stub.DescribeSecurityGroupsType;
import org.wso2.carbon.ec2.client.stub.DisassociateAddress;
import org.wso2.carbon.ec2.client.stub.DisassociateAddressResponse;
import org.wso2.carbon.ec2.client.stub.DisassociateAddressType;
import org.wso2.carbon.ec2.client.stub.GroupItemType;
import org.wso2.carbon.ec2.client.stub.GroupSetType;
import org.wso2.carbon.ec2.client.stub.PlacementRequestType;
import org.wso2.carbon.ec2.client.stub.RebootInstances;
import org.wso2.carbon.ec2.client.stub.RebootInstancesInfoType;
import org.wso2.carbon.ec2.client.stub.RebootInstancesItemType;
import org.wso2.carbon.ec2.client.stub.RebootInstancesResponse;
import org.wso2.carbon.ec2.client.stub.RebootInstancesType;
import org.wso2.carbon.ec2.client.stub.RegisterImage;
import org.wso2.carbon.ec2.client.stub.RegisterImageResponse;
import org.wso2.carbon.ec2.client.stub.RegisterImageType;
import org.wso2.carbon.ec2.client.stub.ReleaseAddress;
import org.wso2.carbon.ec2.client.stub.ReleaseAddressResponse;
import org.wso2.carbon.ec2.client.stub.ReleaseAddressType;
import org.wso2.carbon.ec2.client.stub.ReservationInfoType;
import org.wso2.carbon.ec2.client.stub.ReservationSetType;
import org.wso2.carbon.ec2.client.stub.RunInstances;
import org.wso2.carbon.ec2.client.stub.RunInstancesResponse;
import org.wso2.carbon.ec2.client.stub.RunInstancesType;
import org.wso2.carbon.ec2.client.stub.RunningInstancesItemType;
import org.wso2.carbon.ec2.client.stub.SecurityGroupItemType;
import org.wso2.carbon.ec2.client.stub.TerminateInstances;
import org.wso2.carbon.ec2.client.stub.TerminateInstancesInfoType;
import org.wso2.carbon.ec2.client.stub.TerminateInstancesItemType;
import org.wso2.carbon.ec2.client.stub.TerminateInstancesResponse;
import org.wso2.carbon.ec2.client.stub.TerminateInstancesResponseItemType;
import org.wso2.carbon.ec2.client.stub.TerminateInstancesType;
import org.wso2.carbon.ec2.client.stub.UserDataType;
import org.wso2.carbon.ec2client.EC2Exception;
import org.wso2.carbon.ec2client.data.Address;
import org.wso2.carbon.ec2client.data.AvailabilityZone;
import org.wso2.carbon.ec2client.data.Image;
import org.wso2.carbon.ec2client.data.Instance;
import org.wso2.carbon.ec2client.data.InstanceStateFactory;
import org.wso2.carbon.ec2client.data.InstanceType;
import org.wso2.carbon.ec2client.data.KeyPair;
import org.wso2.carbon.ec2client.data.SecurityGroup;
import org.wso2.carbon.ec2client.data.UserData;
import org.wso2.carbon.ec2client.utils.KeyImporter;
import org.wso2.carbon.ec2client.utils.PKCS1;
import org.wso2.carbon.ec2client.utils.PWCBHandler;

public class EC2Client {
    private static final String EC2_PRIVATE_KEY = "EC2_PRIVATE_KEY";
    private static final String EC2_CERT = "EC2_CERT";
    private static final String EC2_JKS = System.getProperty("java.io.tmpdir") + File.separator + "ec2.jks";
    private static final String EC2_KS_PASSWORD = Math.random() + "ec2kspwd" + System.currentTimeMillis();
    private static final String EC2_USER = "ec2user";
    private static final Log log = LogFactory.getLog(EC2Client.class);
    private AmazonEC2Stub stub;
    private String ec2PrivateKey;
    private String ec2Cert;
    private static final String POLICY = "<wsp:Policy wsu:Id=\"SigOnly\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\" xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"> <wsp:ExactlyOne>  <wsp:All>   <sp:AsymmetricBinding xmlns:sp=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy\">    <wsp:Policy>     <sp:InitiatorToken>      <wsp:Policy>       <sp:X509Token sp:IncludeToken=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient\">        <wsp:Policy>         <sp:WssX509V3Token10/>        </wsp:Policy>       </sp:X509Token>      </wsp:Policy>     </sp:InitiatorToken>     <sp:RecipientToken>      <wsp:Policy>       <sp:X509Token sp:IncludeToken=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Never\">        <wsp:Policy>         <sp:WssX509V3Token10/>        </wsp:Policy>       </sp:X509Token>      </wsp:Policy>     </sp:RecipientToken>     <sp:AlgorithmSuite>      <wsp:Policy>       <sp:TripleDesRsa15/>      </wsp:Policy>     </sp:AlgorithmSuite>     <sp:Layout>      <wsp:Policy>       <sp:Strict/>      </wsp:Policy>     </sp:Layout>     <sp:IncludeTimestamp/>     <sp:OnlySignEntireHeadersAndBody/>    </wsp:Policy>   </sp:AsymmetricBinding>   <sp:Wss10 xmlns:sp=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy\">    <wsp:Policy>     <sp:MustSupportRefKeyIdentifier/>     <sp:MustSupportRefIssuerSerial/>    </wsp:Policy>   </sp:Wss10>   <sp:SignedParts xmlns:sp=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy\">    <sp:Body/>   </sp:SignedParts>   <ramp:RampartConfig xmlns:ramp=\"http://ws.apache.org/rampart/policy\">     <ramp:user>ec2user</ramp:user>    <ramp:encryptionUser>service</ramp:encryptionUser>    <ramp:passwordCallbackClass>org.wso2.carbon.ec2client.utils.PWCBHandler</ramp:passwordCallbackClass>    <ramp:signatureCrypto>     <ramp:crypto provider=\"org.apache.ws.security.components.crypto.Merlin\">      <ramp:property name=\"org.apache.ws.security.crypto.merlin.keystore.type\">JKS</ramp:property>      <ramp:property name=\"org.apache.ws.security.crypto.merlin.file\">" + EC2_JKS + "</ramp:property>" + "      <ramp:property name=\"org.apache.ws.security.crypto.merlin.keystore.password\">" + EC2_KS_PASSWORD + "</ramp:property>" + "     </ramp:crypto>" + "    </ramp:signatureCrypto>" + "   </ramp:RampartConfig>" + "  </wsp:All>" + " </wsp:ExactlyOne>" + "</wsp:Policy>";

    public EC2Client(String ec2PrivateKey, String ec2Cert) throws EC2Exception {
        this.ec2PrivateKey = ec2PrivateKey;
        this.ec2Cert = ec2Cert;
        try {
            this.stub = new AmazonEC2Stub();
            this.stub._getServiceClient().getOptions().setProperty("includeOptionalHeaders", (Object)"true");
            this.stub._getServiceClient().getOptions().setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
        }
        catch (AxisFault e) {
            String msg = "Cannot create stub";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        this.init();
    }

    public EC2Client(ConfigurationContext configurationContext, String targetEndpoint, String ec2PrivateKey, String ec2Cert) throws EC2Exception {
        this.ec2PrivateKey = ec2PrivateKey;
        this.ec2Cert = ec2Cert;
        try {
            this.stub = new AmazonEC2Stub(configurationContext, targetEndpoint);
            this.stub._getServiceClient().getOptions().setProperty("includeOptionalHeaders", (Object)"true");
            this.stub._getServiceClient().getOptions().setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
        }
        catch (AxisFault e) {
            String msg = "Cannot create stub";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        this.init();
    }

    public EC2Client(ConfigurationContext configurationContext, String ec2PrivateKey, String ec2Cert) throws EC2Exception {
        this.ec2PrivateKey = ec2PrivateKey;
        this.ec2Cert = ec2Cert;
        try {
            this.stub = new AmazonEC2Stub(configurationContext);
            this.stub._getServiceClient().getOptions().setProperty("includeOptionalHeaders", (Object)"true");
            this.stub._getServiceClient().getOptions().setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
        }
        catch (AxisFault e) {
            String msg = "Cannot create stub";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        this.init();
    }

    public EC2Client() throws EC2Exception {
        try {
            this.stub = new AmazonEC2Stub();
        }
        catch (AxisFault e) {
            String msg = "Cannot create stub";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        this.init();
    }

    private void init() throws EC2Exception {
        if (this.ec2Cert == null) {
            this.ec2Cert = System.getenv(EC2_CERT);
            if (this.ec2Cert == null) {
                this.ec2Cert = System.getProperty("ec2Cert");
            }
        }
        if (this.ec2PrivateKey == null) {
            this.ec2PrivateKey = System.getenv(EC2_PRIVATE_KEY);
            if (this.ec2PrivateKey == null) {
                this.ec2PrivateKey = System.getProperty("ec2PrivateKey");
            }
        }
        if (this.ec2Cert == null || this.ec2PrivateKey == null) {
            throw new IllegalArgumentException("TheEC2_CERT and/or EC2_PRIVATE_KEY variables have not been set.");
        }
        this.ec2PrivateKey = this.pem2der(this.ec2PrivateKey);
        this.ec2Cert = this.pem2der(this.ec2Cert);
        File jks = new File(EC2_JKS);
        if (jks.exists()) {
            jks.delete();
        }
        PWCBHandler.password = EC2_KS_PASSWORD;
        KeyImporter.doImport(EC2_JKS, this.ec2PrivateKey, this.ec2Cert, EC2_USER, EC2_KS_PASSWORD);
    }

    private String pem2der(String fileName) throws EC2Exception {
        byte[] bytes;
        try {
            bytes = new PKCS1().readDecodedBytes(fileName);
        }
        catch (IOException e) {
            String msg = "Cannot read decoded bytes";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        int indexOfExt = fileName.indexOf(".pem");
        int indexOfSeparator = fileName.lastIndexOf(File.separator);
        String derFile = indexOfSeparator != -1 ? (indexOfExt != -1 ? System.getProperty("java.io.tmpdir") + File.separator + fileName.substring(indexOfSeparator + 1, indexOfExt) + ".der" : System.getProperty("java.io.tmpdir") + File.separator + fileName.substring(indexOfSeparator + 1) + ".der") : (indexOfExt != -1 ? System.getProperty("java.io.tmpdir") + File.separator + fileName.substring(0, indexOfExt) + ".der" : System.getProperty("java.io.tmpdir") + File.separator + fileName + ".der");
        File f = new File(derFile);
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream fop = new FileOutputStream(f);
            fop.write(bytes);
            fop.flush();
            fop.close();
        }
        catch (IOException e) {
            String msg = "Cannot write to file " + derFile;
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        return derFile;
    }

    public List<Image> describeImages() throws EC2Exception {
        DescribeImagesResponse response;
        DescribeImages describeImages = new DescribeImages();
        DescribeImagesType describeImagesType = new DescribeImagesType();
        describeImagesType.setImagesSet(new DescribeImagesInfoType());
        describeImagesType.setOwnersSet(new DescribeImagesOwnersType());
        describeImagesType.setExecutableBySet(new DescribeImagesExecutableBySetType());
        describeImages.setDescribeImages(describeImagesType);
        this.enableSecurity("describeImages");
        try {
            response = this.stub.describeImages(describeImages);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        DescribeImagesResponseItemType[] items = response.getDescribeImagesResponse().getImagesSet().getItem();
        ArrayList<Image> images = new ArrayList<Image>();
        for (DescribeImagesResponseItemType item : items) {
            Image image = new Image(item.getImageId());
            image.setImageId(item.getImageLocation());
            image.setState(item.getImageState());
            image.setType(item.getImageType());
            image.setOwnerId(item.getImageOwnerId());
            image.setPublic(item.getIsPublic());
            image.setKernelId(item.getKernelId());
            image.setArchitecture(item.getArchitecture());
            image.setRamDiskId(item.getRamdiskId());
            images.add(image);
        }
        return images;
    }

    public List<Instance> runInstances(String amiID, int numberOfInstances, InstanceType instanceType, String keyName, String[] groupIds, String additionalInfo, UserData userData, AvailabilityZone zone) throws EC2Exception {
        RunInstancesResponse response;
        log.debug((Object)"Running instances...");
        if (instanceType == null) {
            instanceType = InstanceType.SMALL;
        }
        RunInstances instances = new RunInstances();
        RunInstancesType instancesType = new RunInstancesType();
        instancesType.setImageId(amiID);
        if (userData != null) {
            UserDataType userDataType = new UserDataType();
            userDataType.setVersion(userData.getVersion());
            userDataType.setEncoding(userData.getEncoding());
            userDataType.setData(userData.getData());
            instancesType.setUserData(userDataType);
        }
        if (additionalInfo != null) {
            instancesType.setAdditionalInfo(additionalInfo);
        }
        if (zone != null) {
            PlacementRequestType placement = new PlacementRequestType();
            placement.setAvailabilityZone(zone.getZoneName());
            instancesType.setPlacement(placement);
        }
        instancesType.setKeyName(keyName);
        instancesType.setMinCount(numberOfInstances);
        instancesType.setMaxCount(numberOfInstances);
        instancesType.setInstanceType(instanceType.getType());
        GroupItemType[] groupItemTypes = new GroupItemType[groupIds.length];
        for (int i = 0; i < groupIds.length; ++i) {
            GroupItemType groupItemType = new GroupItemType();
            groupItemType.setGroupId(groupIds[i]);
            groupItemTypes[i] = groupItemType;
        }
        GroupSetType groupSetType = new GroupSetType();
        groupSetType.setItem(groupItemTypes);
        instancesType.setGroupSet(groupSetType);
        instances.setRunInstances(instancesType);
        if (keyName != null) {
            instancesType.setKeyName(keyName);
        }
        this.enableSecurity("runInstances");
        try {
            response = this.stub.runInstances(instances);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        RunningInstancesItemType[] runningInstancesItemTypes = response.getRunInstancesResponse().getInstancesSet().getItem();
        ArrayList<Instance> list = new ArrayList<Instance>();
        for (RunningInstancesItemType itemType : runningInstancesItemTypes) {
            Instance instance = new Instance();
            instance.setInstanceId(itemType.getInstanceId());
            instance.setInternalName(itemType.getPrivateDnsName());
            instance.setExternalName(itemType.getDnsName());
            instance.setLaunchTime(itemType.getLaunchTime());
            instance.setInstanceType(itemType.getInstanceType());
            String availabilityZone = itemType.getPlacement().getAvailabilityZone();
            if (availabilityZone != null) {
                AvailabilityZone z = this.describeAvailabilityZones(new String[]{availabilityZone}).get(0);
                instance.setAvailabilityZone(z);
            }
            instance.setCurrentState(InstanceStateFactory.get(itemType.getInstanceState().getCode()));
            Image image = new Image(itemType.getImageId());
            instance.setImage(image);
            list.add(instance);
        }
        return list;
    }

    public List<Instance> describeInstances() throws EC2Exception {
        DescribeInstancesResponse response;
        DescribeInstances describeInstances = new DescribeInstances();
        DescribeInstancesType instancesType = new DescribeInstancesType();
        DescribeInstancesInfoType type = new DescribeInstancesInfoType();
        instancesType.setInstancesSet(type);
        describeInstances.setDescribeInstances(instancesType);
        this.enableSecurity("describeInstances");
        try {
            response = this.stub.describeInstances(describeInstances);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        ReservationSetType reservationSet = response.getDescribeInstancesResponse().getReservationSet();
        ArrayList<Instance> list = new ArrayList<Instance>();
        int i = 0;
        for (ReservationInfoType infoType : reservationSet.getItem()) {
            for (RunningInstancesItemType instanceType : infoType.getInstancesSet().getItem()) {
                ++i;
                Instance instance = new Instance();
                instance.setOwnerId(infoType.getOwnerId());
                instance.setReservationId(infoType.getReservationId());
                instance.setInstanceId(instanceType.getInstanceId());
                instance.setInternalName(instanceType.getPrivateDnsName());
                instance.setExternalName(instanceType.getDnsName());
                instance.setLaunchTime(instanceType.getLaunchTime());
                instance.setInstanceType(instanceType.getInstanceType());
                instance.setCurrentState(InstanceStateFactory.get(instanceType.getInstanceState().getCode()));
                String availabilityZone = instanceType.getPlacement().getAvailabilityZone();
                if (availabilityZone != null && availabilityZone.length() > 0) {
                    AvailabilityZone z = this.describeAvailabilityZones(new String[]{availabilityZone}).get(0);
                    instance.setAvailabilityZone(z);
                }
                this.setGroupIDs(instance, infoType.getGroupSet().getItem());
                Image image = new Image(instanceType.getImageId());
                instance.setImage(image);
                list.add(instance);
            }
        }
        return list;
    }

    public Instance describeInstance(String instanceId) throws EC2Exception {
        DescribeInstancesResponse response;
        DescribeInstances describeInstances = new DescribeInstances();
        DescribeInstancesType instancesType = new DescribeInstancesType();
        DescribeInstancesInfoType type = new DescribeInstancesInfoType();
        DescribeInstancesItemType instancesItemType = new DescribeInstancesItemType();
        instancesItemType.setInstanceId(instanceId);
        type.setItem(new DescribeInstancesItemType[]{instancesItemType});
        instancesType.setInstancesSet(type);
        describeInstances.setDescribeInstances(instancesType);
        this.enableSecurity("describeInstances");
        try {
            response = this.stub.describeInstances(describeInstances);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        ReservationSetType reservationSet = response.getDescribeInstancesResponse().getReservationSet();
        if (reservationSet == null || reservationSet.getItem() == null || reservationSet.getItem().length == 0) {
            return null;
        }
        ReservationInfoType infoType = reservationSet.getItem()[0];
        if (infoType != null) {
            Instance instance = new Instance();
            instance.setOwnerId(infoType.getOwnerId());
            instance.setReservationId(infoType.getReservationId());
            instance.setInstanceId(infoType.getInstancesSet().getItem()[0].getInstanceId());
            instance.setInternalName(infoType.getInstancesSet().getItem()[0].getPrivateDnsName());
            instance.setExternalName(infoType.getInstancesSet().getItem()[0].getDnsName());
            instance.setLaunchTime(infoType.getInstancesSet().getItem()[0].getLaunchTime());
            instance.setInstanceType(infoType.getInstancesSet().getItem()[0].getInstanceType());
            instance.setCurrentState(InstanceStateFactory.get(infoType.getInstancesSet().getItem()[0].getInstanceState().getCode()));
            this.setGroupIDs(instance, infoType.getGroupSet().getItem());
            Image image = new Image(infoType.getInstancesSet().getItem()[0].getImageId());
            instance.setImage(image);
            return instance;
        }
        return null;
    }

    public List<Instance> terminateInstances(String[] instanceIDs) throws EC2Exception {
        TerminateInstancesResponse response;
        log.debug((Object)"Terminating instances...");
        TerminateInstances instances = new TerminateInstances();
        TerminateInstancesType instancesType = new TerminateInstancesType();
        TerminateInstancesInfoType terminateInstancesInfoType = new TerminateInstancesInfoType();
        ArrayList<TerminateInstancesItemType> types = new ArrayList<TerminateInstancesItemType>();
        for (String instanceID : instanceIDs) {
            TerminateInstancesItemType type = new TerminateInstancesItemType();
            type.setInstanceId(instanceID);
            types.add(type);
        }
        terminateInstancesInfoType.setItem(types.toArray(new TerminateInstancesItemType[types.size()]));
        instancesType.setInstancesSet(terminateInstancesInfoType);
        instances.setTerminateInstances(instancesType);
        this.enableSecurity("terminateInstances");
        try {
            response = this.stub.terminateInstances(instances);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        TerminateInstancesResponseItemType[] itemTypes = response.getTerminateInstancesResponse().getInstancesSet().getItem();
        ArrayList<Instance> list = new ArrayList<Instance>();
        for (TerminateInstancesResponseItemType itemType : itemTypes) {
            Instance instance = new Instance();
            instance.setInstanceId(itemType.getInstanceId());
            instance.setCurrentState(InstanceStateFactory.get(itemType.getShutdownState().getCode()));
            instance.setPreviousState(InstanceStateFactory.get(itemType.getPreviousState().getCode()));
            list.add(instance);
        }
        return list;
    }

    public boolean associateAddress(String instanceId, String publicIp) throws EC2Exception {
        AssociateAddressResponse response;
        AssociateAddress address = new AssociateAddress();
        AssociateAddressType associateAddressType = new AssociateAddressType();
        associateAddressType.setInstanceId(instanceId);
        associateAddressType.setPublicIp(publicIp);
        address.setAssociateAddress(associateAddressType);
        this.enableSecurity("associateAddress");
        try {
            response = this.stub.associateAddress(address);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        AssociateAddressResponseType responseType = response.getAssociateAddressResponse();
        return responseType.get_return();
    }

    public boolean disassociateAddress(String publicIp) throws EC2Exception {
        DisassociateAddressResponse response;
        DisassociateAddress disassociateAddress = new DisassociateAddress();
        DisassociateAddressType disassociateAddressType = new DisassociateAddressType();
        disassociateAddressType.setPublicIp(publicIp);
        disassociateAddress.setDisassociateAddress(disassociateAddressType);
        this.enableSecurity("disassociateAddress");
        try {
            response = this.stub.disassociateAddress(disassociateAddress);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        return response.getDisassociateAddressResponse().get_return();
    }

    public Address allocateAddress() throws EC2Exception {
        AllocateAddressResponse response;
        AllocateAddress address = new AllocateAddress();
        AllocateAddressType allocateAddressType = new AllocateAddressType();
        address.setAllocateAddress(allocateAddressType);
        this.enableSecurity("allocateAddress");
        try {
            response = this.stub.allocateAddress(address);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        Address addrs = new Address(response.getAllocateAddressResponse().getPublicIp());
        log.info((Object)("Allocated public IP address " + addrs.getPublicIp()));
        return addrs;
    }

    public boolean releaseAddress(String publicIp) throws EC2Exception {
        ReleaseAddressResponse response;
        log.debug((Object)("Releasing address " + publicIp + "..."));
        ReleaseAddress address = new ReleaseAddress();
        ReleaseAddressType releaseAddressType = new ReleaseAddressType();
        releaseAddressType.setPublicIp(publicIp);
        address.setReleaseAddress(releaseAddressType);
        this.enableSecurity("releaseAddress");
        try {
            response = this.stub.releaseAddress(address);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        boolean result = response.getReleaseAddressResponse().get_return();
        if (result) {
            log.info((Object)("Released public IP address " + publicIp));
        }
        return result;
    }

    public Image registerImage(String imageLocation) throws EC2Exception {
        RegisterImageResponse response;
        RegisterImage image = new RegisterImage();
        RegisterImageType type = new RegisterImageType();
        type.setImageLocation(imageLocation);
        image.setRegisterImage(type);
        this.enableSecurity("registerImage");
        try {
            response = this.stub.registerImage(image);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        return new Image(response.getRegisterImageResponse().getImageId());
    }

    public boolean deregisterImage(String imageId) throws EC2Exception {
        DeregisterImageResponse response;
        DeregisterImage deregisterImage = new DeregisterImage();
        DeregisterImageType deregisterImageType = new DeregisterImageType();
        deregisterImageType.setImageId(imageId);
        deregisterImage.setDeregisterImage(deregisterImageType);
        this.enableSecurity("deregisterImage");
        try {
            response = this.stub.deregisterImage(deregisterImage);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        return response.getDeregisterImageResponse().get_return();
    }

    public List<Address> describeAddresses(String[] publicIPs) throws EC2Exception {
        DescribeAddressesResponse response;
        log.debug((Object)"Describing addresses...");
        DescribeAddresses addresses = new DescribeAddresses();
        DescribeAddressesType addressesType = new DescribeAddressesType();
        DescribeAddressesInfoType describeAddressesInfoType = new DescribeAddressesInfoType();
        if (publicIPs != null && publicIPs.length > 0) {
            ArrayList<DescribeAddressesItemType> list = new ArrayList<DescribeAddressesItemType>();
            for (String publicIP : publicIPs) {
                DescribeAddressesItemType item = new DescribeAddressesItemType();
                item.setPublicIp(publicIP);
                list.add(item);
            }
            describeAddressesInfoType.setItem(list.toArray(new DescribeAddressesItemType[list.size()]));
        }
        addressesType.setPublicIpsSet(describeAddressesInfoType);
        addresses.setDescribeAddresses(addressesType);
        this.enableSecurity("describeAddresses");
        try {
            response = this.stub.describeAddresses(addresses);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        DescribeAddressesResponseItemType[] items = response.getDescribeAddressesResponse().getAddressesSet().getItem();
        ArrayList<Address> addressList = new ArrayList<Address>();
        for (DescribeAddressesResponseItemType item : items) {
            String id = item.getInstanceId();
            Instance instance = null;
            if (id != null && id.length() > 0) {
                instance = this.describeInstance(id);
            }
            addressList.add(new Address(instance, item.getPublicIp()));
        }
        return addressList;
    }

    public List<KeyPair> describeKeyPairs(String[] keyNames) throws EC2Exception {
        DescribeKeyPairsResponseItemType[] items;
        DescribeKeyPairsResponse response;
        log.debug((Object)"Describing key pairs...");
        DescribeKeyPairs pairs = new DescribeKeyPairs();
        DescribeKeyPairsType describeKeyPairsType = new DescribeKeyPairsType();
        DescribeKeyPairsInfoType pairsInfoType = new DescribeKeyPairsInfoType();
        if (keyNames != null && keyNames.length > 0) {
            ArrayList<DescribeKeyPairsItemType> types = new ArrayList<DescribeKeyPairsItemType>();
            for (String keyName : keyNames) {
                DescribeKeyPairsItemType type = new DescribeKeyPairsItemType();
                type.setKeyName(keyName);
                types.add(type);
            }
            pairsInfoType.setItem(types.toArray(new DescribeKeyPairsItemType[types.size()]));
        }
        describeKeyPairsType.setKeySet(pairsInfoType);
        pairs.setDescribeKeyPairs(describeKeyPairsType);
        this.enableSecurity("describeKeyPairs");
        try {
            response = this.stub.describeKeyPairs(pairs);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        ArrayList<KeyPair> keyPairs = new ArrayList<KeyPair>();
        for (DescribeKeyPairsResponseItemType item : items = response.getDescribeKeyPairsResponse().getKeySet().getItem()) {
            KeyPair keyPair = new KeyPair(item.getKeyName(), item.getKeyFingerprint());
            keyPairs.add(keyPair);
        }
        return keyPairs;
    }

    public List<AvailabilityZone> describeAvailabilityZones(String[] availabilityZones) throws EC2Exception {
        AvailabilityZoneItemType[] zoneItemTypes;
        DescribeAvailabilityZonesResponse response;
        log.debug((Object)"Describing availability zones...");
        DescribeAvailabilityZones zones = new DescribeAvailabilityZones();
        DescribeAvailabilityZonesType describeAvailabilityZonesType = new DescribeAvailabilityZonesType();
        DescribeAvailabilityZonesSetType type = new DescribeAvailabilityZonesSetType();
        if (availabilityZones != null && availabilityZones.length > 0) {
            ArrayList<DescribeAvailabilityZonesSetItemType> items = new ArrayList<DescribeAvailabilityZonesSetItemType>();
            for (String availabilityZone : availabilityZones) {
                DescribeAvailabilityZonesSetItemType item = new DescribeAvailabilityZonesSetItemType();
                item.setZoneName(availabilityZone);
                items.add(item);
            }
            type.setItem(items.toArray(new DescribeAvailabilityZonesSetItemType[items.size()]));
        }
        describeAvailabilityZonesType.setAvailabilityZoneSet(type);
        zones.setDescribeAvailabilityZones(describeAvailabilityZonesType);
        this.enableSecurity("describeAvailabilityZones");
        try {
            response = this.stub.describeAvailabilityZones(zones);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        ArrayList<AvailabilityZone> zoneList = new ArrayList<AvailabilityZone>();
        for (AvailabilityZoneItemType zoneItemType : zoneItemTypes = response.getDescribeAvailabilityZonesResponse().getAvailabilityZoneInfo().getItem()) {
            AvailabilityZone zone = new AvailabilityZone(zoneItemType.getZoneName(), zoneItemType.getZoneState());
            zoneList.add(zone);
        }
        return zoneList;
    }

    public List<SecurityGroup> describeSecurityGroups(String[] securityGroupNames) throws EC2Exception {
        SecurityGroupItemType[] securityGroupItemTypes;
        DescribeSecurityGroupsResponse response;
        log.debug((Object)"Describing security groups...");
        DescribeSecurityGroups groups = new DescribeSecurityGroups();
        DescribeSecurityGroupsType describeSecurityGroupsType = new DescribeSecurityGroupsType();
        DescribeSecurityGroupsSetType securityGroupsSetType = new DescribeSecurityGroupsSetType();
        describeSecurityGroupsType.setSecurityGroupSet(securityGroupsSetType);
        DescribeSecurityGroupsSetType describeSecurityGroupsSetType = new DescribeSecurityGroupsSetType();
        if (securityGroupNames != null && securityGroupNames.length > 0) {
            ArrayList<DescribeSecurityGroupsSetItemType> items = new ArrayList<DescribeSecurityGroupsSetItemType>();
            for (String sg : securityGroupNames) {
                DescribeSecurityGroupsSetItemType item = new DescribeSecurityGroupsSetItemType();
                item.setGroupName(sg);
                items.add(item);
            }
            describeSecurityGroupsSetType.setItem(items.toArray(new DescribeSecurityGroupsSetItemType[items.size()]));
        }
        describeSecurityGroupsType.setSecurityGroupSet(describeSecurityGroupsSetType);
        groups.setDescribeSecurityGroups(describeSecurityGroupsType);
        this.enableSecurity("describeSecurityGroups");
        try {
            response = this.stub.describeSecurityGroups(groups);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        ArrayList<SecurityGroup> sgList = new ArrayList<SecurityGroup>();
        for (SecurityGroupItemType sgItemType : securityGroupItemTypes = response.getDescribeSecurityGroupsResponse().getSecurityGroupInfo().getItem()) {
            SecurityGroup sg = new SecurityGroup(sgItemType.getGroupName());
            sg.setDescription(sgItemType.getGroupDescription());
            sg.setOwnerId(sgItemType.getOwnerId());
            sgList.add(sg);
        }
        return sgList;
    }

    public boolean rebootInstances(String[] instanceIDs) throws EC2Exception {
        RebootInstancesResponse response;
        log.debug((Object)"Rebooting instances...");
        RebootInstances instances = new RebootInstances();
        RebootInstancesType instancesType = new RebootInstancesType();
        RebootInstancesInfoType rebootInstancesInfoType = new RebootInstancesInfoType();
        ArrayList<RebootInstancesItemType> list = new ArrayList<RebootInstancesItemType>();
        for (String instanceID : instanceIDs) {
            RebootInstancesItemType type = new RebootInstancesItemType();
            type.setInstanceId(instanceID);
            list.add(type);
        }
        rebootInstancesInfoType.setItem(list.toArray(new RebootInstancesItemType[list.size()]));
        instancesType.setInstancesSet(rebootInstancesInfoType);
        instances.setRebootInstances(instancesType);
        this.enableSecurity("rebootInstances");
        try {
            response = this.stub.rebootInstances(instances);
        }
        catch (RemoteException e) {
            String msg = "Cannot invoke AWS";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        return response.getRebootInstancesResponse().get_return();
    }

    private void enableSecurity(String operation) throws EC2Exception {
        ServiceClient serviceClient = this.stub._getServiceClient();
        AxisService axisService = serviceClient.getAxisService();
        AxisOperation axisOperation = axisService.getOperation(new QName(operation));
        axisOperation.getMessage("Out").getPolicySubject().attachPolicy(this.loadPolicy());
        try {
            serviceClient.engageModule("rampart");
        }
        catch (AxisFault e) {
            String msg = "Cannot engage Rampart module";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
    }

    private Policy loadPolicy() throws EC2Exception {
        StAXOMBuilder builder;
        try {
            builder = new StAXOMBuilder((InputStream)new ByteArrayInputStream(POLICY.getBytes()));
        }
        catch (XMLStreamException e) {
            String msg = "Cannot load security policy";
            log.error((Object)msg, (Throwable)e);
            throw new EC2Exception(msg, e);
        }
        return PolicyEngine.getPolicy((OMElement)builder.getDocumentElement());
    }

    private void setGroupIDs(Instance instance, GroupItemType[] groupItemTypes) {
        if (groupItemTypes != null) {
            int groupIdCount = groupItemTypes.length;
            String[] groupIds = new String[groupIdCount];
            for (int index = 0; index < groupIdCount; ++index) {
                groupIds[index] = groupItemTypes[index].getGroupId();
            }
            instance.setGroupIds(groupIds);
        } else {
            instance.setGroupIds(new String[0]);
        }
    }
}

