/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ec2client.utils;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;

public class KeyImporter {
    private static InputStream fullStream(String fname) throws IOException {
        FileInputStream fis = new FileInputStream(fname);
        DataInputStream dis = new DataInputStream(fis);
        byte[] bytes = new byte[dis.available()];
        dis.readFully(bytes);
        return new ByteArrayInputStream(bytes);
    }

    public static void doImport(String keystoreName, String privateKeyFile, String certFile, String defaultAlias, String keypass) {
        try {
            KeyStore ks = KeyStore.getInstance("JKS", "SUN");
            ks.load(null, keypass.toCharArray());
            ks.store(new FileOutputStream(keystoreName), keypass.toCharArray());
            ks.load(new FileInputStream(keystoreName), keypass.toCharArray());
            InputStream fl = KeyImporter.fullStream(privateKeyFile);
            byte[] key = new byte[fl.available()];
            KeyFactory kf = KeyFactory.getInstance("RSA");
            fl.read(key, 0, fl.available());
            fl.close();
            PKCS8EncodedKeySpec keysp = new PKCS8EncodedKeySpec(key);
            PrivateKey ff = kf.generatePrivate(keysp);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            InputStream certstream = KeyImporter.fullStream(certFile);
            Collection<? extends Certificate> c = cf.generateCertificates(certstream);
            Certificate[] certs = new Certificate[c.toArray().length];
            if (c.size() == 1) {
                Certificate cert;
                certstream = KeyImporter.fullStream(certFile);
                certs[0] = cert = cf.generateCertificate(certstream);
            } else {
                certs = (Certificate[])c.toArray();
            }
            ks.setKeyEntry(defaultAlias, ff, keypass.toCharArray(), certs);
            ks.store(new FileOutputStream(keystoreName), keypass.toCharArray());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

