/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.discovery.ui.client;

import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.discovery.stub.types.DiscoveryAdminStub;
import org.wso2.carbon.discovery.stub.types.mgt.DiscoveryProxyDetails;
import org.wso2.carbon.discovery.stub.types.mgt.ProbeDetails;
import org.wso2.carbon.discovery.stub.types.mgt.TargetServiceDetails;

public class DiscoveryAdminClient {
    private static final String BUNDLE = "org.wso2.carbon.discovery.ui.i18n.Resources";
    private ResourceBundle bundle;
    public DiscoveryAdminStub stub;

    public DiscoveryAdminClient(ConfigurationContext configCtx, String backendServerURL, String cookie, Locale locale) throws AxisFault {
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        String serviceURL = backendServerURL + "DiscoveryAdmin";
        this.stub = new DiscoveryAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public void addDiscoveryProxy(String name, String url, String policy) throws Exception {
        if (name == null || "".equals(name)) {
            throw new Exception("The name has not been specified for the discovery proxy");
        }
        if (url == null || "".equals(url)) {
            throw new Exception("The discovery proxy URL has not been specified");
        }
        DiscoveryProxyDetails pd = new DiscoveryProxyDetails();
        pd.setName(name);
        pd.setUrl(url);
        if (policy != null && !"".equals(policy)) {
            pd.setPolicy(this.getPolicy(policy));
        }
        this.stub.addDiscoveryProxy(pd);
    }

    private String getPolicy(String policy) {
        String prefix = "/_system/config/";
        if (policy.startsWith(prefix)) {
            return policy.substring(prefix.length());
        }
        return policy;
    }

    public Map<String, DiscoveryProxyDetails> getDiscoveryProxies() throws Exception {
        DiscoveryProxyDetails[] proxyData = this.stub.getDiscoveryProxies();
        if (proxyData == null || proxyData.length == 0 || proxyData[0] == null) {
            return null;
        }
        TreeMap<String, DiscoveryProxyDetails> proxyMap = new TreeMap<String, DiscoveryProxyDetails>();
        for (DiscoveryProxyDetails proxy : proxyData) {
            String key = proxy.getName();
            proxyMap.put(key, proxy);
        }
        return proxyMap;
    }

    public void removeDiscoveryProxy(String name) throws Exception {
        if (name == null || "".equals(name)) {
            return;
        }
        this.stub.removeDiscoveryProxy(name);
    }

    public DiscoveryProxyDetails getDiscoveryProxy(String name) throws Exception {
        return this.stub.getDiscoveryProxy(name);
    }

    public void updateDiscoveryProxy(String name, String url, String policy) throws Exception {
        if (name == null || "".equals(name)) {
            throw new Exception("The name has not been specified for the discovery proxy");
        }
        if (url == null || "".equals(url)) {
            throw new Exception("The discovery proxy URL has not been specified");
        }
        DiscoveryProxyDetails pd = new DiscoveryProxyDetails();
        pd.setName(name);
        pd.setUrl(url);
        if (policy != null && !"".equals(policy)) {
            pd.setPolicy(this.getPolicy(policy));
        }
        this.stub.updateDiscoveryProxy(pd);
    }

    public TargetServiceDetails[] probeDiscoveryProxy(String name, QName[] types, URI[] scopes) throws Exception {
        TargetServiceDetails[] details;
        int i;
        if (name == null || "".equals(name)) {
            throw new Exception("The name has not been specified for the discovery proxy");
        }
        ProbeDetails probe = new ProbeDetails();
        if (types != null) {
            String[] typeValues = new String[types.length];
            for (i = 0; i < types.length; ++i) {
                typeValues[i] = types[i].toString();
            }
            probe.setTypes(typeValues);
        }
        if (scopes != null) {
            String[] scopeValues = new String[scopes.length];
            for (i = 0; i < scopes.length; ++i) {
                scopeValues[i] = scopes[i].toString();
            }
            probe.setScopes(scopeValues);
        }
        if ((details = this.stub.probeDiscoveryProxy(name, probe)) == null || details.length == 0 || details[0] == null) {
            return null;
        }
        return details;
    }

    public TargetServiceDetails resolveTargetService(String name, String serviceId) throws Exception {
        if (name == null || "".equals(name)) {
            throw new Exception("The name has not been specified for the discovery proxy");
        }
        if (serviceId == null || "".equals(serviceId)) {
            throw new Exception("The service ID has not been specified");
        }
        return this.stub.resolveTargetService(name, serviceId);
    }
}

