/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.discovery.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.wso2.carbon.utils.CarbonUtils;

public class DiscoveryProxyObserver
implements AxisObserver {
    private static final Log log = LogFactory.getLog(DiscoveryProxyObserver.class);
    public static final String WSD_SEC_POLICY_FILE = "wsd-sec-policy.xml";

    public void init(AxisConfiguration axisConfiguration) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing WS-Discovery proxy observer");
        }
        try {
            AxisService service = axisConfiguration.getService("DiscoveryProxy");
            if (service != null) {
                this.engageSecurity(service);
            }
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public void serviceUpdate(AxisEvent axisEvent, AxisService axisService) {
        if ("DiscoveryProxy".equals(axisService.getName()) && axisEvent.getEventType() == 1) {
            this.engageSecurity(axisService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void engageSecurity(AxisService service) {
        String path = CarbonUtils.getCarbonConfigDirPath() + File.separator + WSD_SEC_POLICY_FILE;
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            AxisModule module = service.getAxisConfiguration().getModule("rampart");
            if (module == null) {
                log.error((Object)"Rampart module is not available in the system. Unable to engage security on the WS-Discovery proxy.");
                return;
            }
            log.info((Object)("Loading security policy for the WS-Discovery proxy from " + path));
            Policy policy = PolicyEngine.getPolicy((InputStream)in);
            service.getPolicySubject().attachPolicy(policy);
            service.engageModule(module);
        }
        catch (FileNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No security policies specified for the WS-Discovery proxy");
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Error while engaging security on the WS-Discovery proxy", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)("Error while closing the input stream to file: " + path), (Throwable)e);
                }
            }
        }
    }

    public void moduleUpdate(AxisEvent axisEvent, AxisModule axisModule) {
    }

    public void serviceGroupUpdate(AxisEvent axisEvent, AxisServiceGroup axisServiceGroup) {
    }

    public void addParameter(Parameter parameter) throws AxisFault {
    }

    public void deserializeParameters(OMElement omElement) throws AxisFault {
    }

    public Parameter getParameter(String s) {
        return null;
    }

    public ArrayList<Parameter> getParameters() {
        return null;
    }

    public boolean isParameterLocked(String s) {
        return false;
    }

    public void removeParameter(Parameter parameter) throws AxisFault {
    }
}

