/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.discovery.proxy;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.discovery.proxy.DiscoveryProxyObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class DiscoveryProxyComponent {
    private static final Log log = LogFactory.getLog(DiscoveryProxyComponent.class);
    private ConfigurationContext cfgCtx;

    protected void activate(ComponentContext context) {
        if (this.cfgCtx != null) {
            AxisConfiguration axisConfig = this.cfgCtx.getAxisConfiguration();
            DiscoveryProxyObserver observer = new DiscoveryProxyObserver();
            observer.init(axisConfig);
            axisConfig.addObservers((AxisObserver)observer);
        } else {
            log.warn((Object)"ConfigurationContext is not available. Unable to register the DiscoveryProxyObserver.");
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService cfgCtxService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService bound to the discovery proxy component");
        }
        this.cfgCtx = cfgCtxService.getServerConfigContext();
    }

    protected void unsetConfigurationContextService(ConfigurationContextService cfgCtxService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService unbound from the discovery proxy component");
        }
        this.cfgCtx = null;
    }
}

