/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.discovery.proxy;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.addressing.EndpointReference;
import org.wso2.carbon.discovery.DiscoveryException;
import org.wso2.carbon.discovery.DiscoveryOMUtils;
import org.wso2.carbon.discovery.messages.Notification;
import org.wso2.carbon.discovery.messages.Probe;
import org.wso2.carbon.discovery.messages.QueryMatch;
import org.wso2.carbon.discovery.messages.Resolve;
import org.wso2.carbon.discovery.messages.TargetService;
import org.wso2.carbon.discovery.util.DiscoveryServiceUtils;

public class DiscoveryProxy {
    public void Hello(OMElement helloElement) throws DiscoveryException {
        Notification hello = DiscoveryOMUtils.getHelloFromOM((OMElement)helloElement);
        try {
            DiscoveryServiceUtils.addService((TargetService)hello.getTargetService());
        }
        catch (Exception e) {
            throw new DiscoveryException("Error while persisting the service description", (Throwable)e);
        }
    }

    public void Bye(OMElement byeElement) throws DiscoveryException {
        Notification bye = DiscoveryOMUtils.getByeFromOM((OMElement)byeElement);
        try {
            DiscoveryServiceUtils.removeServiceEndpoints((TargetService)bye.getTargetService());
        }
        catch (Exception e) {
            throw new DiscoveryException("Error while persisting the service description", (Throwable)e);
        }
    }

    public OMElement Probe(OMElement probeElement) throws DiscoveryException {
        Probe probe = DiscoveryOMUtils.getProbeFromOM((OMElement)probeElement);
        try {
            TargetService[] services = DiscoveryServiceUtils.findServices((Probe)probe);
            QueryMatch match = new QueryMatch(0, services);
            return DiscoveryOMUtils.toOM((QueryMatch)match, (OMFactory)OMAbstractFactory.getSOAP11Factory());
        }
        catch (Exception e) {
            throw new DiscoveryException("Error while searching for services", (Throwable)e);
        }
    }

    public OMElement Resolve(OMElement resolveElement) throws DiscoveryException {
        Resolve resolve = DiscoveryOMUtils.getResolveFromOM((OMElement)resolveElement);
        try {
            TargetService service = DiscoveryServiceUtils.getService((EndpointReference)resolve.getEpr());
            QueryMatch match = new QueryMatch(1, new TargetService[]{service});
            return DiscoveryOMUtils.toOM((QueryMatch)match, (OMFactory)OMAbstractFactory.getSOAP11Factory());
        }
        catch (Exception e) {
            throw new DiscoveryException("Error while resolving the service with ID: " + resolve.getEpr().getAddress());
        }
    }
}

