/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.discovery.module.handlers;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.wso2.carbon.discovery.DiscoveryException;
import org.wso2.carbon.discovery.client.DiscoveryClient;
import org.wso2.carbon.discovery.messages.TargetService;

public class DiscoveryOutHandler
extends AbstractHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        String[] scopes;
        if (messageContext.getTo() == null || !messageContext.getTo().getAddress().equals("http://docs.oasis-open.org/DiscoveryTargetEPR")) return Handler.InvocationResponse.CONTINUE;
        String discoveryProxy = (String)messageContext.getOptions().getProperty("DiscoveryProxy");
        if (discoveryProxy == null) {
            Parameter param = messageContext.getAxisService().getParameter("DiscoveryProxy");
            if (param == null) throw new AxisFault("Discovery Proxy Address has not been set");
            discoveryProxy = (String)param.getValue();
        }
        if ((scopes = (String[])messageContext.getOptions().getProperty("DiscoveryScopes")) == null) {
            scopes = new String[]{"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/DefaultScope"};
        }
        URI[] uriScopes = new URI[scopes.length];
        QName[] types = (QName[])messageContext.getOptions().getProperty("DiscoveryTypes");
        try {
            for (int i = 0; i < scopes.length; ++i) {
                uriScopes[i] = new URI(scopes[i]);
            }
            DiscoveryClient discoveryClient = new DiscoveryClient(messageContext.getConfigurationContext(), discoveryProxy);
            TargetService[] targetServices = discoveryClient.probe(types, uriScopes);
            if (targetServices == null || targetServices.length <= 0) throw new AxisFault("Can not find an epr for given description");
            URI targetURI = null;
            if (targetServices[0].getXAddresses() != null && targetServices[0].getXAddresses().length > 0) {
                targetURI = this.getTargetURI(targetServices[0].getXAddresses(), (String)messageContext.getProperty("DiscoveryScheme"));
            } else {
                TargetService targetService = discoveryClient.resolve(targetServices[0].getEpr().getAddress());
                if (targetService.getXAddresses() == null || targetService.getXAddresses().length <= 0) throw new AxisFault("Resolve message did not return the service location");
                targetURI = this.getTargetURI(targetService.getXAddresses(), (String)messageContext.getProperty("DiscoveryScheme"));
            }
            messageContext.setTo(new EndpointReference(targetURI.toString()));
            return Handler.InvocationResponse.CONTINUE;
        }
        catch (DiscoveryException e) {
            throw new AxisFault("Can not create the discovery client ", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new AxisFault("Can not create the URI from the scope", (Throwable)e);
        }
    }

    private URI getTargetURI(URI[] xAddresses, String scheme) {
        URI targetAddress = null;
        if (scheme == null) {
            scheme = "http";
        }
        for (URI xAddress : xAddresses) {
            if (!xAddress.getScheme().equals(scheme)) continue;
            targetAddress = xAddress;
            break;
        }
        if (targetAddress == null) {
            targetAddress = xAddresses[0];
        }
        return targetAddress;
    }
}

