/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.services;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSynchronizationManager;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSynchronizer;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AutoCheckoutService {
    private static final Log log = LogFactory.getLog(AutoCheckoutService.class);
    private static final QName TIMESTAMP = new QName("http://wso2.org/ns/2011/01/eventing/registry/event", "Timestamp");
    private static final QName DETAILS = new QName("http://wso2.org/ns/2011/01/eventing/registry/event", "Details");
    private static final QName SESSION = new QName("http://wso2.org/ns/2011/01/eventing/registry/event", "Session");
    private static final QName TENANT = new QName("http://wso2.org/ns/2011/01/eventing/registry/event", "TenantId");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public void notifyUpdate(OMElement element) {
        String filePath;
        OMElement timestampElement;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received new event: " + element));
        }
        if ((timestampElement = element.getFirstChildWithName(TIMESTAMP)) == null) {
            log.warn((Object)"Timestamp element not available in the event");
            return;
        }
        OMElement detailElement = element.getFirstChildWithName(DETAILS);
        OMElement sessionElement = detailElement.getFirstChildWithName(SESSION);
        OMElement tenantElement = sessionElement.getFirstChildWithName(TENANT);
        if (tenantElement == null) {
            log.warn((Object)"Tenant ID not available in the event");
            return;
        }
        String timestamp = timestampElement.getText();
        int tenantId = Integer.parseInt(tenantElement.getText());
        DeploymentSynchronizationManager syncManager = DeploymentSynchronizationManager.getInstance();
        DeploymentSynchronizer synchronizer = syncManager.getSynchronizer(filePath = MultitenantUtils.getAxis2RepositoryPath((int)tenantId));
        if (synchronizer == null || !synchronizer.isAutoCheckout()) {
            log.warn((Object)("Unable to find the synchronizer for the file path: " + filePath));
            return;
        }
        try {
            Date date = DATE_FORMAT.parse(timestamp);
            synchronizer.requestCheckout(date.getTime());
        }
        catch (ParseException e) {
            log.error((Object)("Error while parsing the registry event time stamp: " + timestamp), (Throwable)e);
        }
    }
}

