/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.internal.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.deployment.synchronizer.ArtifactRepository;
import org.wso2.carbon.deployment.synchronizer.internal.util.RepositoryConfigParameter;

public final class RepositoryReferenceHolder {
    private static RepositoryReferenceHolder instance = new RepositoryReferenceHolder();
    private Map<ArtifactRepository, List<RepositoryConfigParameter>> repositories = new HashMap<ArtifactRepository, List<RepositoryConfigParameter>>();

    private RepositoryReferenceHolder() {
    }

    public static synchronized RepositoryReferenceHolder getInstance() {
        return instance;
    }

    public Map<ArtifactRepository, List<RepositoryConfigParameter>> getRepositories() {
        return this.repositories;
    }

    public void addRepository(ArtifactRepository repositoryType, List<RepositoryConfigParameter> parameters) {
        this.repositories.put(repositoryType, parameters);
    }

    public void removeRepository(ArtifactRepository repositoryType) {
        this.repositories.remove(repositoryType);
    }

    public ArtifactRepository getRepositoryByType(String repositoryType) {
        if (repositoryType == null) {
            return null;
        }
        for (ArtifactRepository repo : this.repositories.keySet()) {
            if (!repositoryType.equals(repo.getRepositoryType())) continue;
            return repo;
        }
        return null;
    }
}

