/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.internal.repository;

import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.util.JavaUtils;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.deployment.synchronizer.ArtifactRepository;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizerException;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSynchronizationManager;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSynchronizer;
import org.wso2.carbon.deployment.synchronizer.internal.util.DeploymentSynchronizerConfiguration;
import org.wso2.carbon.deployment.synchronizer.internal.util.RepositoryConfigParameter;
import org.wso2.carbon.deployment.synchronizer.internal.util.RepositoryReferenceHolder;
import org.wso2.carbon.deployment.synchronizer.internal.util.ServiceReferenceHolder;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CarbonRepositoryUtils {
    public static DeploymentSynchronizer newCarbonRepositorySynchronizer(int tenantId) throws DeploymentSynchronizerException {
        DeploymentSynchronizerConfiguration config = CarbonRepositoryUtils.getActiveSynchronizerConfiguration(tenantId);
        if (config.isEnabled()) {
            String filePath = MultitenantUtils.getAxis2RepositoryPath((int)tenantId);
            ArtifactRepository artifactRepository = CarbonRepositoryUtils.createArtifactRepository(config.getRepositoryType());
            artifactRepository.init(tenantId);
            DeploymentSynchronizer synchronizer = DeploymentSynchronizationManager.getInstance().createSynchronizer(artifactRepository, filePath);
            synchronizer.setAutoCommit(config.isAutoCommit());
            synchronizer.setAutoCheckout(config.isAutoCheckout());
            synchronizer.setPeriod(config.getPeriod());
            synchronizer.setUseEventing(config.isUseEventing());
            return synchronizer;
        }
        return null;
    }

    public static DeploymentSynchronizerConfiguration getActiveSynchronizerConfiguration(int tenantId) throws DeploymentSynchronizerException {
        try {
            DeploymentSynchronizerConfiguration config = CarbonRepositoryUtils.getDeploymentSyncConfiguration();
            if (config == null) {
                config = CarbonRepositoryUtils.getDeploymentSyncConfigurationFromRegistry(tenantId);
                if (config == null) {
                    config = CarbonRepositoryUtils.getDefaultDeploymentSyncConfiguration();
                }
            } else {
                config.setServerBasedConfiguration(true);
            }
            return config;
        }
        catch (RegistryException e) {
            throw new DeploymentSynchronizerException("Error while loading synchronizer configuration from the registry", e);
        }
    }

    public static DeploymentSynchronizerConfiguration getDeploymentSyncConfiguration() throws DeploymentSynchronizerException {
        DeploymentSynchronizerConfiguration config = new DeploymentSynchronizerConfiguration();
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String value = serverConfig.getFirstProperty("DeploymentSynchronizer.Enabled");
        if (value == null) {
            return null;
        }
        config.setEnabled(JavaUtils.isTrueExplicitly((String)value));
        value = serverConfig.getFirstProperty("DeploymentSynchronizer.AutoCheckout");
        config.setAutoCheckout(value != null && JavaUtils.isTrueExplicitly((String)value));
        value = serverConfig.getFirstProperty("DeploymentSynchronizer.AutoCommit");
        config.setAutoCommit(value != null && JavaUtils.isTrueExplicitly((String)value));
        value = serverConfig.getFirstProperty("DeploymentSynchronizer.UseEventing");
        config.setUseEventing(value != null && JavaUtils.isTrueExplicitly((String)value));
        value = serverConfig.getFirstProperty("DeploymentSynchronizer.AutoSyncPeriod");
        if (value != null) {
            config.setPeriod(Long.parseLong(value));
        } else {
            config.setPeriod(60L);
        }
        value = serverConfig.getFirstProperty("DeploymentSynchronizer.RepositoryType");
        if (value != null) {
            config.setRepositoryType(value);
        } else {
            config.setRepositoryType("registry");
        }
        ArtifactRepository repository = RepositoryReferenceHolder.getInstance().getRepositoryByType(config.getRepositoryType());
        if (repository == null) {
            throw new DeploymentSynchronizerException("No Repository found for type " + config.getRepositoryType());
        }
        List<RepositoryConfigParameter> parameters = repository.getParameters();
        if (parameters != null) {
            for (RepositoryConfigParameter parameter : parameters) {
                parameter.setValue(serverConfig.getFirstProperty(parameter.getName()));
            }
            config.setRepositoryConfigParameters(parameters.toArray(new RepositoryConfigParameter[parameters.size()]));
        }
        return config;
    }

    public static DeploymentSynchronizerConfiguration getDefaultDeploymentSyncConfiguration() throws DeploymentSynchronizerException {
        DeploymentSynchronizerConfiguration config = new DeploymentSynchronizerConfiguration();
        config.setEnabled(false);
        config.setAutoCheckout(false);
        config.setAutoCommit(false);
        config.setUseEventing(false);
        config.setPeriod(60L);
        config.setRepositoryType("registry");
        ArtifactRepository repository = RepositoryReferenceHolder.getInstance().getRepositoryByType(config.getRepositoryType());
        if (repository == null) {
            throw new DeploymentSynchronizerException("No Repository found for type " + config.getRepositoryType());
        }
        List<RepositoryConfigParameter> parameters = repository.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            config.setRepositoryConfigParameters(parameters.toArray(new RepositoryConfigParameter[parameters.size()]));
        }
        return config;
    }

    public static String getCarbonRepositoryFilePath(ConfigurationContext cfgCtx) {
        int tenantId = MultitenantUtils.getTenantId((ConfigurationContext)cfgCtx);
        return MultitenantUtils.getAxis2RepositoryPath((int)tenantId);
    }

    public static boolean isSynchronizerEnabled(int tenantId) throws DeploymentSynchronizerException {
        DeploymentSynchronizerConfiguration config = CarbonRepositoryUtils.getActiveSynchronizerConfiguration(tenantId);
        return config.isEnabled();
    }

    public static DeploymentSynchronizerConfiguration getDeploymentSyncConfigurationFromRegistry(int tenantId) throws RegistryException {
        UserRegistry localRepository = CarbonRepositoryUtils.getLocalRepository(tenantId);
        if (!localRepository.resourceExists("repository/components/org.wso2.carbon.deployment.synchronizer/CarbonRepository")) {
            return null;
        }
        Resource resource = localRepository.get("repository/components/org.wso2.carbon.deployment.synchronizer/CarbonRepository");
        DeploymentSynchronizerConfiguration config = new DeploymentSynchronizerConfiguration();
        String status = new String((byte[])resource.getContent());
        if ("enabled".equals(status)) {
            config.setEnabled(true);
        }
        config.setAutoCheckout(Boolean.valueOf(resource.getProperty("DeploymentSynchronizer.AutoCheckout")));
        config.setAutoCommit(Boolean.valueOf(resource.getProperty("DeploymentSynchronizer.AutoCommit")));
        config.setPeriod(Long.valueOf(resource.getProperty("DeploymentSynchronizer.AutoSyncPeriod")));
        config.setUseEventing(Boolean.valueOf(resource.getProperty("DeploymentSynchronizer.UseEventing")));
        config.setRepositoryType(resource.getProperty("DeploymentSynchronizer.RepositoryType"));
        ArtifactRepository repository = RepositoryReferenceHolder.getInstance().getRepositoryByType(config.getRepositoryType());
        if (repository == null) {
            throw new RegistryException("No Repository found for type " + config.getRepositoryType());
        }
        List<RepositoryConfigParameter> parameters = repository.getParameters();
        if (parameters != null) {
            for (RepositoryConfigParameter parameter : parameters) {
                parameter.setValue(resource.getProperty(parameter.getName()));
            }
            config.setRepositoryConfigParameters(parameters.toArray(new RepositoryConfigParameter[parameters.size()]));
        }
        resource.discard();
        return config;
    }

    public static void persistConfiguration(DeploymentSynchronizerConfiguration config, int tenantId) throws RegistryException {
        UserRegistry localRepository = CarbonRepositoryUtils.getLocalRepository(tenantId);
        Resource resource = !localRepository.resourceExists("repository/components/org.wso2.carbon.deployment.synchronizer/CarbonRepository") ? localRepository.newResource() : localRepository.get("repository/components/org.wso2.carbon.deployment.synchronizer/CarbonRepository");
        resource.setProperty("DeploymentSynchronizer.AutoCommit", String.valueOf(config.isAutoCommit()));
        resource.setProperty("DeploymentSynchronizer.AutoCheckout", String.valueOf(config.isAutoCheckout()));
        resource.setProperty("DeploymentSynchronizer.AutoSyncPeriod", String.valueOf(config.getPeriod()));
        resource.setProperty("DeploymentSynchronizer.UseEventing", String.valueOf(config.isUseEventing()));
        resource.setProperty("DeploymentSynchronizer.RepositoryType", config.getRepositoryType());
        resource.setContent((Object)(config.isEnabled() ? "enabled" : "disabled"));
        RepositoryConfigParameter[] parameters = config.getRepositoryConfigParameters();
        if (parameters != null && parameters.length != 0) {
            for (int i = 0; i < parameters.length; ++i) {
                resource.setProperty(parameters[i].getName(), parameters[i].getValue());
            }
        }
        localRepository.put("repository/components/org.wso2.carbon.deployment.synchronizer/CarbonRepository", resource);
        resource.discard();
    }

    private static UserRegistry getLocalRepository(int tenantId) throws RegistryException {
        return ServiceReferenceHolder.getRegistryService().getLocalRepository(tenantId);
    }

    private static ArtifactRepository createArtifactRepository(String repositoryType) throws DeploymentSynchronizerException {
        ArtifactRepository artifactRepository = RepositoryReferenceHolder.getInstance().getRepositoryByType(repositoryType);
        if (artifactRepository == null) {
            throw new DeploymentSynchronizerException("No Repository found for type " + repositoryType);
        }
        return artifactRepository;
    }
}

