/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.internal;

import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizerException;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSynchronizationManager;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSynchronizer;
import org.wso2.carbon.deployment.synchronizer.internal.repository.CarbonRepositoryUtils;
import org.wso2.carbon.deployment.synchronizer.internal.util.DeploymentSynchronizerConfiguration;
import org.wso2.carbon.deployment.synchronizer.services.DeploymentSynchronizerService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DeploymentSynchronizerServiceImpl
implements DeploymentSynchronizerService,
org.wso2.carbon.core.deployment.DeploymentSynchronizer {
    private DeploymentSynchronizationManager syncManager = DeploymentSynchronizationManager.getInstance();

    @Override
    public boolean synchronizerExists(String filePath) {
        return this.syncManager.getSynchronizer(filePath) != null;
    }

    @Override
    public boolean isAutoCommitOn(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.isAutoCommit();
    }

    @Override
    public boolean isAutoCheckoutOn(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.isAutoCheckout();
    }

    @Override
    public long getLastCommitTime(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.getLastCommitTime();
    }

    @Override
    public long getLastCheckoutTime(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.getLastCheckoutTime();
    }

    public boolean update(int tenantId) {
        try {
            DeploymentSynchronizerConfiguration configuration = CarbonRepositoryUtils.getActiveSynchronizerConfiguration(tenantId);
            if (!configuration.isEnabled() || !configuration.isAutoCheckout()) {
                return false;
            }
            DeploymentSynchronizer synchronizer = this.getSynchronizer(MultitenantUtils.getAxis2RepositoryPath((int)tenantId));
            if (synchronizer == null) {
                synchronizer = CarbonRepositoryUtils.newCarbonRepositorySynchronizer(tenantId);
                if (synchronizer == null) {
                    return false;
                }
                synchronizer.doInitialSyncUp();
            }
            return synchronizer.checkout();
        }
        catch (DeploymentSynchronizerException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean commit(int tenantId) {
        try {
            DeploymentSynchronizerConfiguration configuration = CarbonRepositoryUtils.getActiveSynchronizerConfiguration(tenantId);
            if (!configuration.isEnabled() || !configuration.isAutoCommit()) {
                return false;
            }
            DeploymentSynchronizer synchronizer = this.getSynchronizer(MultitenantUtils.getAxis2RepositoryPath((int)tenantId));
            if (synchronizer == null) {
                synchronizer = CarbonRepositoryUtils.newCarbonRepositorySynchronizer(tenantId);
                if (synchronizer == null) {
                    return false;
                }
                synchronizer.doInitialSyncUp();
            }
            return synchronizer.commit();
        }
        catch (DeploymentSynchronizerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean checkout(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.checkout();
    }

    @Override
    public boolean commit(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.commit();
    }

    private DeploymentSynchronizer getSynchronizer(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.syncManager.getSynchronizer(filePath);
        if (synchronizer == null) {
            throw new DeploymentSynchronizerException("A repository synchronizer has not been engaged for the file path: " + filePath);
        }
        return synchronizer;
    }
}

