/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.deployment.DeploymentSynchronizer;
import org.wso2.carbon.deployment.synchronizer.ArtifactRepository;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizerException;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSyncAxis2ConfigurationContextObserver;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSynchronizationManager;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSynchronizerServiceImpl;
import org.wso2.carbon.deployment.synchronizer.internal.repository.CarbonRepositoryUtils;
import org.wso2.carbon.deployment.synchronizer.internal.util.RepositoryReferenceHolder;
import org.wso2.carbon.deployment.synchronizer.internal.util.ServiceReferenceHolder;
import org.wso2.carbon.deployment.synchronizer.registry.RegistryBasedArtifactRepository;
import org.wso2.carbon.deployment.synchronizer.services.DeploymentSynchronizerService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class DeploymentSynchronizerComponent {
    private static final Log log = LogFactory.getLog(DeploymentSynchronizerComponent.class);
    private ServiceRegistration observerRegistration;
    private ServiceRegistration registryDepSynServiceRegistration;

    protected void activate(ComponentContext context) {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        DeploymentSynchronizationManager.getInstance().init(serverConfig);
        RegistryBasedArtifactRepository registryBasedArtifactRepository = new RegistryBasedArtifactRepository();
        this.registryDepSynServiceRegistration = context.getBundleContext().registerService(ArtifactRepository.class.getName(), (Object)registryBasedArtifactRepository, null);
        try {
            this.initDeploymentSynchronizerForSuperTenant();
        }
        catch (DeploymentSynchronizerException e) {
            log.error((Object)"Error while initializing a deployment synchronizer for the super tenant Carbon repository", (Throwable)e);
        }
        BundleContext bundleContext = context.getBundleContext();
        this.observerRegistration = bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new DeploymentSyncAxis2ConfigurationContextObserver(), null);
        bundleContext.registerService(new String[]{DeploymentSynchronizerService.class.getName(), DeploymentSynchronizer.class.getName()}, (Object)new DeploymentSynchronizerServiceImpl(), null);
        log.debug((Object)"Deployment synchronizer component activated");
    }

    private void initDeploymentSynchronizerForSuperTenant() throws DeploymentSynchronizerException {
        if (!CarbonRepositoryUtils.isSynchronizerEnabled(-1234)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing the deployment synchronizer for super tenant");
        }
        CarbonRepositoryUtils.newCarbonRepositorySynchronizer(-1234);
    }

    protected void deactivate(ComponentContext context) {
        DeploymentSynchronizationManager.getInstance().shutdown();
        if (this.observerRegistration != null) {
            this.observerRegistration.unregister();
            this.observerRegistration = null;
        }
        if (this.registryDepSynServiceRegistration != null) {
            this.registryDepSynServiceRegistration.unregister();
            this.registryDepSynServiceRegistration = null;
        }
        log.debug((Object)"Deployment synchronizer component deactivated");
    }

    protected void setConfigurationContextService(ConfigurationContextService service) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deployment synchronizer component bound to the configuration context service");
        }
        ServiceReferenceHolder.setConfigurationContextService(service);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService service) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deployment synchronizer component unbound from the configuration context service");
        }
        ServiceReferenceHolder.setConfigurationContextService(null);
    }

    protected void setRegistryService(RegistryService service) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deployment synchronizer component bound to the registry service");
        }
        ServiceReferenceHolder.setRegistryService(service);
    }

    protected void unsetRegistryService(RegistryService service) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deployment synchronizer component unbound from the registry service");
        }
        ServiceReferenceHolder.setRegistryService(null);
    }

    protected void addArtifactRepository(ArtifactRepository artifactRepository) {
        RepositoryReferenceHolder repositoryReferenceHolder = RepositoryReferenceHolder.getInstance();
        repositoryReferenceHolder.addRepository(artifactRepository, artifactRepository.getParameters());
    }

    protected void removeArtifactRepository(ArtifactRepository artifactRepository) {
        RepositoryReferenceHolder repositoryReferenceHolder = RepositoryReferenceHolder.getInstance();
        repositoryReferenceHolder.removeRepository(artifactRepository);
    }
}

