/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizerException;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSynchronizationManager;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSynchronizer;
import org.wso2.carbon.deployment.synchronizer.internal.repository.CarbonRepositoryUtils;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DeploymentSyncAxis2ConfigurationContextObserver
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(DeploymentSyncAxis2ConfigurationContextObserver.class);

    public void creatingConfigurationContext(int tenantId) {
        try {
            if (!CarbonRepositoryUtils.isSynchronizerEnabled(tenantId)) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing the deployment synchronizer for tenant: " + tenantId));
            }
            DeploymentSynchronizer depsync = CarbonRepositoryUtils.newCarbonRepositorySynchronizer(tenantId);
            depsync.doInitialSyncUp();
        }
        catch (DeploymentSynchronizerException e) {
            log.error((Object)("Error while initializing the deployment synchronizer for tenant: " + tenantId));
        }
    }

    public void terminatingConfigurationContext(ConfigurationContext configCtx) {
        int tenantId = MultitenantUtils.getTenantId((ConfigurationContext)configCtx);
        DeploymentSynchronizationManager.getInstance().deleteSynchronizer(tenantId);
    }
}

