/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.subversion;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNProgressListener;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapter;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.deployment.synchronizer.ArtifactRepository;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizerException;
import org.wso2.carbon.deployment.synchronizer.internal.repository.CarbonRepositoryUtils;
import org.wso2.carbon.deployment.synchronizer.internal.util.DeploymentSynchronizerConfiguration;
import org.wso2.carbon.deployment.synchronizer.internal.util.RepositoryConfigParameter;
import org.wso2.carbon.deployment.synchronizer.subversion.DefaultSVNConflictResolver;
import org.wso2.carbon.deployment.synchronizer.subversion.SVNNotifyListener;

public class SVNBasedArtifactRepository
implements ArtifactRepository {
    private static final Log log = LogFactory.getLog(SVNBasedArtifactRepository.class);
    private static final int UNVERSIONED = SVNStatusKind.UNVERSIONED.toInt();
    private static final int MISSING = SVNStatusKind.MISSING.toInt();
    private static final boolean RECURSIVE = true;
    private static final boolean NO_SET_DEPTH = false;
    private SVNUrl svnUrl;
    private ISVNClientAdapter svnClient;
    private boolean ignoreExternals = true;
    private boolean forceUpdate = true;
    private List<RepositoryConfigParameter> parameters;

    public SVNBasedArtifactRepository() {
        this.populateParameters();
    }

    public void init(int tenantId) throws DeploymentSynchronizerException {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        DeploymentSynchronizerConfiguration conf = CarbonRepositoryUtils.getActiveSynchronizerConfiguration((int)tenantId);
        String url = null;
        boolean appendTenantId = false;
        String user = null;
        String password = null;
        RepositoryConfigParameter[] configParameters = conf.getRepositoryConfigParameters();
        if (configParameters == null || configParameters.length == 0) {
            this.handleException("SVN configuration parameters must be specified for the SVN based deployment synchronizer");
        }
        for (int i = 0; i < configParameters.length; ++i) {
            RepositoryConfigParameter parameter = configParameters[i];
            if ("DeploymentSynchronizer.SvnUrl".equals(parameter.getName())) {
                url = parameter.getValue();
                continue;
            }
            if ("DeploymentSynchronizer.SvnUser".equals(parameter.getName())) {
                user = parameter.getValue();
                continue;
            }
            if ("DeploymentSynchronizer.SvnPassword".equals(parameter.getName())) {
                password = parameter.getValue();
                continue;
            }
            if ("DeploymentSynchronizer.SvnUrlAppendTenantId".equals(parameter.getName())) {
                appendTenantId = Boolean.valueOf(parameter.getValue());
                continue;
            }
            if ("DeploymentSynchronizer.SvnIgnoreExternals".equals(parameter.getName())) {
                this.ignoreExternals = Boolean.valueOf(parameter.getValue());
                continue;
            }
            if (!"DeploymentSynchronizer.SvnForceUpdate".equals(parameter.getName())) continue;
            this.forceUpdate = Boolean.valueOf(parameter.getValue());
        }
        if (url == null) {
            this.handleException("SVN URL must be specified for the SVN based deployment synchronizer");
            return;
        }
        if (appendTenantId) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + tenantId;
        }
        try {
            this.svnUrl = new SVNUrl(url);
        }
        catch (MalformedURLException e) {
            this.handleException("Provided SVN URL is malformed: " + url, e);
        }
        String clientType = serverConfig.getFirstProperty("DeploymentSynchronizer.SvnClient");
        if (clientType == null) {
            try {
                clientType = SVNClientAdapterFactory.getPreferredSVNClientType();
            }
            catch (SVNClientException e) {
                this.handleException("Error while retrieving the preferred SVN client type", (Exception)((Object)e));
            }
        }
        this.svnClient = SVNClientAdapterFactory.createSVNClient((String)clientType);
        if (user != null) {
            this.svnClient.setUsername(user);
            this.svnClient.setPassword(password);
        }
        SVNNotifyListener notifyListener = new SVNNotifyListener();
        this.svnClient.addNotifyListener((ISVNNotifyListener)notifyListener);
        this.svnClient.setProgressListener((ISVNProgressListener)notifyListener);
        this.svnClient.addConflictResolutionCallback((ISVNConflictResolver)new DefaultSVNConflictResolver());
        this.checkRemoteDirectory();
    }

    private void populateParameters() {
        this.parameters = new ArrayList<RepositoryConfigParameter>();
        RepositoryConfigParameter parameter = new RepositoryConfigParameter();
        parameter.setName("DeploymentSynchronizer.SvnUrl");
        parameter.setType("string");
        parameter.setRequired(true);
        parameter.setMaxlength(50);
        this.parameters.add(parameter);
        parameter = new RepositoryConfigParameter();
        parameter.setName("DeploymentSynchronizer.SvnUser");
        parameter.setType("string");
        parameter.setRequired(true);
        this.parameters.add(parameter);
        parameter = new RepositoryConfigParameter();
        parameter.setName("DeploymentSynchronizer.SvnPassword");
        parameter.setType("string");
        parameter.setRequired(true);
        parameter.setMasked(true);
        this.parameters.add(parameter);
        parameter = new RepositoryConfigParameter();
        parameter.setName("DeploymentSynchronizer.SvnIgnoreExternals");
        parameter.setType("boolean");
        this.parameters.add(parameter);
        parameter = new RepositoryConfigParameter();
        parameter.setName("DeploymentSynchronizer.SvnForceUpdate");
        parameter.setType("boolean");
        this.parameters.add(parameter);
        parameter = new RepositoryConfigParameter();
        parameter.setName("DeploymentSynchronizer.SvnUrlAppendTenantId");
        parameter.setType("boolean");
        this.parameters.add(parameter);
    }

    private void checkRemoteDirectory() throws DeploymentSynchronizerException {
        try {
            ISVNInfo info = this.svnClient.getInfo(this.svnUrl);
            if (info != null && log.isDebugEnabled()) {
                log.debug((Object)("Remote directory: " + this.svnUrl + " exists"));
            }
        }
        catch (SVNClientException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error while retrieving information from the directory: " + this.svnUrl), (Throwable)ex);
                log.debug((Object)("Attempting to create the directory: " + this.svnUrl));
            }
            try {
                this.svnClient.mkdir(this.svnUrl, true, "Directory creation by deployment synchronizer");
            }
            catch (SVNClientException e) {
                this.handleException("Error while attempting to create the directory: " + this.svnUrl, (Exception)((Object)e));
            }
        }
    }

    private void svnAddFiles(File root) throws SVNClientException {
        ISVNStatus[] status;
        for (ISVNStatus s : status = this.svnClient.getStatus(root, true, false)) {
            File[] children;
            File file;
            String fileName;
            if (s.getTextStatus().toInt() != UNVERSIONED || (fileName = (file = s.getFile()).getName()).startsWith(".") || fileName.startsWith("~") || fileName.endsWith(".bk")) continue;
            if (file.isFile()) {
                this.svnClient.addFile(file);
                continue;
            }
            this.svnClient.addDirectory(file, false);
            for (File child : children = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.getName().equals(".svn");
                }
            })) {
                this.svnAddFiles(child);
            }
        }
    }

    public boolean commit(String filePath) throws DeploymentSynchronizerException {
        File root = new File(filePath);
        try {
            this.svnClient.cleanup(root);
            this.svnAddFiles(root);
            this.cleanupDeletedFiles(root);
            ISVNStatus[] status = this.svnClient.getStatus(root, true, false);
            if (status != null && status.length > 0 && !this.isAllUnversioned(status)) {
                File[] files = new File[]{root};
                this.svnClient.commit(files, "Commit initiated by deployment synchronizer", true);
                return true;
            }
            log.debug((Object)"No changes in the local working copy");
        }
        catch (SVNClientException e) {
            this.handleException("Error while committing artifacts to the SVN repository", (Exception)((Object)e));
        }
        return false;
    }

    private boolean isAllUnversioned(ISVNStatus[] status) {
        for (ISVNStatus s : status) {
            if (s.getTextStatus().toInt() == UNVERSIONED) continue;
            return false;
        }
        return true;
    }

    public boolean checkout(String filePath) throws DeploymentSynchronizerException {
        File root = new File(filePath);
        try {
            this.cleanupDeletedFiles(root);
            ISVNStatus status = this.svnClient.getSingleStatus(root);
            if (status != null && status.getTextStatus().toInt() == UNVERSIONED) {
                this.cleanupUnversionedFiles(root);
                if (this.svnClient instanceof CmdLineClientAdapter) {
                    this.svnClient.checkout(this.svnUrl, root, SVNRevision.HEAD, true);
                } else {
                    this.svnClient.checkout(this.svnUrl, root, SVNRevision.HEAD, 3, this.ignoreExternals, this.forceUpdate);
                }
                return true;
            }
            long filesUpdated = -1L;
            this.svnClient.cleanup(root);
            filesUpdated = this.svnClient instanceof CmdLineClientAdapter ? this.svnClient.update(root, SVNRevision.HEAD, true) : this.svnClient.update(root, SVNRevision.HEAD, 3, false, this.ignoreExternals, this.forceUpdate);
            return filesUpdated > 1L;
        }
        catch (SVNClientException e) {
            this.handleException("Error while checking out or updating artifacts from the SVN repository", (Exception)((Object)e));
            return false;
        }
    }

    private void cleanupUnversionedFiles(File root) throws SVNClientException {
        ISVNDirEntry[] entries;
        for (ISVNDirEntry entry : entries = this.svnClient.getList(this.svnUrl, SVNRevision.HEAD, false)) {
            ISVNStatus status;
            String fileName = entry.getPath();
            SVNNodeKind nodeType = entry.getNodeKind();
            File localFile = new File(root, fileName);
            if (!localFile.exists() || (status = this.svnClient.getSingleStatus(localFile)) != null && status.getTextStatus().toInt() != UNVERSIONED) continue;
            if (localFile.isFile() && SVNNodeKind.FILE.equals((Object)nodeType)) {
                log.info((Object)("Unversioned file: " + localFile.getPath() + " will be deleted"));
                if (localFile.delete()) continue;
                log.error((Object)("Unable to delete the file: " + localFile.getPath()));
                continue;
            }
            if (!localFile.isDirectory() || !SVNNodeKind.DIR.equals((Object)nodeType)) continue;
            log.info((Object)("Unversioned directory: " + localFile.getPath() + " will be deleted"));
            try {
                FileUtils.deleteDirectory((File)localFile);
            }
            catch (IOException e) {
                log.error((Object)("Error while deleting the directory: " + localFile.getPath()), (Throwable)e);
            }
        }
    }

    private void cleanupDeletedFiles(File root) throws SVNClientException {
        ISVNStatus[] status = this.svnClient.getStatus(root, true, false);
        if (status != null) {
            ArrayList<File> deletableFiles = new ArrayList<File>();
            for (ISVNStatus s : status) {
                int statusCode = s.getTextStatus().toInt();
                if (statusCode != MISSING) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scheduling the file: " + s.getPath() + " for SVN delete"));
                }
                deletableFiles.add(s.getFile());
            }
            if (deletableFiles.size() > 0) {
                this.svnClient.remove(deletableFiles.toArray(new File[deletableFiles.size()]), true);
            }
        }
    }

    public void initAutoCheckout(boolean useEventing) throws DeploymentSynchronizerException {
    }

    public void cleanupAutoCheckout() {
    }

    public String getRepositoryType() {
        return "svn";
    }

    public List<RepositoryConfigParameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SVNBasedArtifactRepository that = (SVNBasedArtifactRepository)o;
        return this.getRepositoryType().equals(that.getRepositoryType());
    }

    public int hashCode() {
        return this.getRepositoryType().hashCode();
    }

    private void handleException(String msg) throws DeploymentSynchronizerException {
        log.error((Object)msg);
        throw new DeploymentSynchronizerException(msg);
    }

    private void handleException(String msg, Exception e) throws DeploymentSynchronizerException {
        log.error((Object)msg, (Throwable)e);
        throw new DeploymentSynchronizerException(msg, (Throwable)e);
    }
}

