/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.services;

import java.util.List;
import java.util.Set;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.deployment.synchronizer.ArtifactRepository;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizerException;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSynchronizationManager;
import org.wso2.carbon.deployment.synchronizer.internal.DeploymentSynchronizer;
import org.wso2.carbon.deployment.synchronizer.internal.repository.CarbonRepositoryUtils;
import org.wso2.carbon.deployment.synchronizer.internal.util.DeploymentSynchronizerConfiguration;
import org.wso2.carbon.deployment.synchronizer.internal.util.RepositoryConfigParameter;
import org.wso2.carbon.deployment.synchronizer.internal.util.RepositoryReferenceHolder;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DeploymentSynchronizerAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(DeploymentSynchronizerAdmin.class);

    public void enableSynchronizerForCarbonRepository(DeploymentSynchronizerConfiguration config) throws DeploymentSynchronizerException {
        int tenantId = MultitenantUtils.getTenantId((ConfigurationContext)this.getConfigContext());
        try {
            CarbonRepositoryUtils.persistConfiguration(config, tenantId);
            DeploymentSynchronizer synchronizer = CarbonRepositoryUtils.newCarbonRepositorySynchronizer(tenantId);
            if (synchronizer == null) {
                String msg = "Unable to create a deployment synchronizer instance";
                log.warn((Object)msg);
                throw new DeploymentSynchronizerException(msg);
            }
            synchronizer.start();
        }
        catch (RegistryException e) {
            this.handleException("Error while enabling deployment synchronizer", (Exception)((Object)e));
        }
    }

    public void disableSynchronizerForCarbonRepository() throws DeploymentSynchronizerException {
        int tenantId = MultitenantUtils.getTenantId((ConfigurationContext)this.getConfigContext());
        try {
            DeploymentSynchronizerConfiguration config = CarbonRepositoryUtils.getActiveSynchronizerConfiguration(tenantId);
            if (config == null || !config.isEnabled()) {
                log.warn((Object)"Attempted to disable an already disabled deployment synchronizer");
                return;
            }
            config.setEnabled(false);
            CarbonRepositoryUtils.persistConfiguration(config, tenantId);
        }
        catch (RegistryException e) {
            this.handleException("Error while persisting the deployment synchronizer configuration", (Exception)((Object)e));
        }
        String filePath = CarbonRepositoryUtils.getCarbonRepositoryFilePath(this.getConfigContext());
        DeploymentSynchronizer synchronizer = DeploymentSynchronizationManager.getInstance().deleteSynchronizer(filePath);
        if (synchronizer != null) {
            synchronizer.stop();
        }
    }

    public void updateSynchronizerForCarbonRepository(DeploymentSynchronizerConfiguration config) throws DeploymentSynchronizerException {
        this.disableSynchronizerForCarbonRepository();
        this.enableSynchronizerForCarbonRepository(config);
    }

    public long getLastCommitTime() {
        String filePath = CarbonRepositoryUtils.getCarbonRepositoryFilePath(this.getConfigContext());
        DeploymentSynchronizer synchronizer = DeploymentSynchronizationManager.getInstance().getSynchronizer(filePath);
        if (synchronizer != null) {
            return synchronizer.getLastCommitTime();
        }
        return -1L;
    }

    public long getLastCheckoutTime() {
        String filePath = CarbonRepositoryUtils.getCarbonRepositoryFilePath(this.getConfigContext());
        DeploymentSynchronizer synchronizer = DeploymentSynchronizationManager.getInstance().getSynchronizer(filePath);
        if (synchronizer != null) {
            return synchronizer.getLastCheckoutTime();
        }
        return -1L;
    }

    public void checkout() throws DeploymentSynchronizerException {
        String filePath = CarbonRepositoryUtils.getCarbonRepositoryFilePath(this.getConfigContext());
        DeploymentSynchronizer synchronizer = DeploymentSynchronizationManager.getInstance().getSynchronizer(filePath);
        synchronizer.checkout();
    }

    public void commit() throws DeploymentSynchronizerException {
        String filePath = CarbonRepositoryUtils.getCarbonRepositoryFilePath(this.getConfigContext());
        DeploymentSynchronizer synchronizer = DeploymentSynchronizationManager.getInstance().getSynchronizer(filePath);
        synchronizer.commit();
    }

    public boolean synchronizerEnabledForCarbonRepository() {
        String filePath = CarbonRepositoryUtils.getCarbonRepositoryFilePath(this.getConfigContext());
        return DeploymentSynchronizationManager.getInstance().getSynchronizer(filePath) != null;
    }

    public DeploymentSynchronizerConfiguration getSynchronizerConfigurationForCarbonRepository() throws DeploymentSynchronizerException {
        int tenantId = MultitenantUtils.getTenantId((ConfigurationContext)this.getConfigContext());
        return CarbonRepositoryUtils.getActiveSynchronizerConfiguration(tenantId);
    }

    public RepositoryConfigParameter[] getParamsByRepositoryType(String repositoryType) {
        Set<ArtifactRepository> repositories = RepositoryReferenceHolder.getInstance().getRepositories().keySet();
        if (repositories != null && !repositories.isEmpty()) {
            for (ArtifactRepository repository : repositories) {
                List<RepositoryConfigParameter> parameters;
                if (!repository.getRepositoryType().equals(repositoryType) || (parameters = RepositoryReferenceHolder.getInstance().getRepositories().get(repository)) == null || parameters.isEmpty()) continue;
                return parameters.toArray(new RepositoryConfigParameter[parameters.size()]);
            }
        }
        return new RepositoryConfigParameter[0];
    }

    public String[] getRepositoryTypes() {
        Set<ArtifactRepository> repositories = RepositoryReferenceHolder.getInstance().getRepositories().keySet();
        if (repositories != null) {
            String[] repositoryTypes = new String[repositories.size()];
            int index = 0;
            for (ArtifactRepository repository : repositories) {
                repositoryTypes[index] = repository.getRepositoryType();
                ++index;
            }
            return repositoryTypes;
        }
        return null;
    }

    private void handleException(String msg, Exception e) throws DeploymentSynchronizerException {
        log.error((Object)msg, (Throwable)e);
        throw new DeploymentSynchronizerException(msg, e);
    }
}

