/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.registry;

import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizerException;
import org.wso2.carbon.deployment.synchronizer.internal.util.ServiceReferenceHolder;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.event.ws.internal.builders.exceptions.InvalidMessageException;
import org.wso2.carbon.event.ws.internal.builders.utils.BuilderUtils;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.eventing.services.EventingService;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.utils.ConfigurationContextService;

public class RegistryUtils {
    public static String getAbsoluteRegistryPath(String registryPath, String basePath) {
        if (!registryPath.startsWith("/")) {
            registryPath = "/" + registryPath;
        }
        return basePath + registryPath;
    }

    public static String subscribeForRegistryEvents(UserRegistry registry, String absolutePath, String endpoint) throws DeploymentSynchronizerException {
        EventingService eventingService = ServiceReferenceHolder.getEventingService();
        if (eventingService == null) {
            throw new IllegalStateException("Registry eventing service unavailable");
        }
        String topic = "/registry/notifications" + absolutePath + "/" + "#";
        SuperTenantCarbonContext.startTenantFlow();
        try {
            Subscription subscription = BuilderUtils.createSubscription((String)endpoint, (String)"http://wso2.org/registry/eventing/dialect/topicFilter", (String)topic);
            subscription.setEventDispatcherName("/registry/notifications");
            subscription.setTenantId(registry.getCallerTenantId());
            subscription.setOwner(registry.getUserName());
            SuperTenantCarbonContext currentContext = SuperTenantCarbonContext.getCurrentContext();
            currentContext.setTenantId(registry.getCallerTenantId(), true);
            currentContext.setUserRealm((UserRealm)registry.getUserRealm());
            currentContext.setUsername(registry.getUserName());
            String string = eventingService.subscribe(subscription);
            return string;
        }
        catch (InvalidMessageException e) {
            throw new DeploymentSynchronizerException("Error while subscribing for registry events on collection: " + absolutePath, e);
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unsubscribeForRegistryEvents(String subscriptionId, int tenantId) {
        EventingService eventingService = ServiceReferenceHolder.getEventingService();
        if (eventingService == null) {
            throw new IllegalStateException("Registry eventing service unavailable");
        }
        SuperTenantCarbonContext.startTenantFlow();
        try {
            SuperTenantCarbonContext currentContext = SuperTenantCarbonContext.getCurrentContext();
            currentContext.setTenantId(tenantId, true);
            boolean bl = eventingService.unsubscribe(subscriptionId);
            return bl;
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    public static String getEventReceiverEndpoint() {
        AxisService service;
        ConfigurationContextService configurationContextService = ServiceReferenceHolder.getConfigurationContextService();
        if (configurationContextService == null) {
            throw new IllegalStateException("Configuration context service not available");
        }
        AxisConfiguration axisConfig = configurationContextService.getServerConfigContext().getAxisConfiguration();
        try {
            service = axisConfig.getService("AutoCheckoutService");
        }
        catch (AxisFault axisFault) {
            throw new IllegalStateException("Event receiver service not available", axisFault);
        }
        for (String epr : service.getEPRs()) {
            if (!epr.startsWith("http")) continue;
            return epr;
        }
        return null;
    }
}

