/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.subversion;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapterFactory;
import org.wso2.carbon.deployment.synchronizer.ArtifactRepository;
import org.wso2.carbon.deployment.synchronizer.subversion.SVNBasedArtifactRepository;

public class SVNDeploymentSynchronizerComponent {
    private static final Log log = LogFactory.getLog(SVNDeploymentSynchronizerComponent.class);
    private ServiceRegistration svnDepSyncServiceRegistration;

    protected void activate(ComponentContext context) {
        boolean allClientsFailed = true;
        try {
            SvnKitClientAdapterFactory.setup();
            allClientsFailed = false;
            log.debug((Object)"SVN Kit client adapter initialized");
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to initialize the SVN Kit client adapter - Required jars may be missing", t);
        }
        try {
            JhlClientAdapterFactory.setup();
            allClientsFailed = false;
            log.debug((Object)"Java HL client adapter initialized");
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to initialize the Java HL client adapter - Required jars  or the native libraries may be missing", t);
        }
        try {
            CmdLineClientAdapterFactory.setup();
            allClientsFailed = false;
            log.debug((Object)"Command line client adapter initialized");
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to initialize the command line client adapter - SVN command line tools may be missing", t);
        }
        if (allClientsFailed) {
            String error = "Could not initialize any of the SVN client adapters - Required jars/libraries may be missing";
            log.debug((Object)error);
            return;
        }
        SVNBasedArtifactRepository svnBasedArtifactRepository = new SVNBasedArtifactRepository();
        this.svnDepSyncServiceRegistration = context.getBundleContext().registerService(ArtifactRepository.class.getName(), (Object)svnBasedArtifactRepository, null);
        log.debug((Object)"SVN based deployment synchronizer component activated");
    }

    protected void deactivate(ComponentContext context) {
        if (this.svnDepSyncServiceRegistration != null) {
            this.svnDepSyncServiceRegistration.unregister();
            this.svnDepSyncServiceRegistration = null;
        }
        log.debug((Object)"SVN based deployment synchronizer component deactivated");
    }
}

