/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.eventing.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.event.core.Message;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.subscription.EventDispatcher;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.registry.common.eventing.RegistryEvent;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.eventing.RegistryEventDispatcher;
import org.wso2.carbon.registry.eventing.events.DispatchEvent;
import org.wso2.carbon.registry.eventing.internal.Utils;
import org.wso2.carbon.registry.eventing.services.EventingService;
import org.wso2.carbon.registry.eventing.services.SubscriptionEmailVerficationService;

public class EventingServiceImpl
implements EventingService,
SubscriptionEmailVerficationService {
    private Map<String, String[]> eventTypeMap;
    private Map<String, List<String>> eventTypeExclusionMap;
    private static boolean initialized = false;
    private static EventDispatcher dispatcher = null;
    private ExecutorService executor = null;
    private String emailIndexStoragePath;
    private static final Log log = LogFactory.getLog(EventingServiceImpl.class);

    @Override
    public String verifyEmail(String data) {
        String subscriptionId = null;
        String username = null;
        String remoteURL = null;
        String email = null;
        if (data != null) {
            try {
                OMElement dataElement = AXIOMUtil.stringToOM((String)data);
                Iterator it = dataElement.getChildElements();
                while (it.hasNext()) {
                    OMElement element = (OMElement)it.next();
                    if ("subscriptionId".equals(element.getLocalName())) {
                        subscriptionId = element.getText();
                        continue;
                    }
                    if ("username".equals(element.getLocalName())) {
                        username = element.getText();
                        continue;
                    }
                    if ("remoteURL".equals(element.getLocalName())) {
                        remoteURL = element.getText();
                        continue;
                    }
                    if (!"email".equals(element.getLocalName())) continue;
                    email = element.getText();
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)"Unable to verify e-mail address", (Throwable)e);
                return null;
            }
        }
        try {
            if (username != null || remoteURL != null) {
                throw new UnsupportedOperationException("This method is no longer supported");
            }
            Subscription subscription = this.getSubscription(subscriptionId);
            Map subscriptionData = subscription.getProperties();
            subscriptionData.remove("notVerfied");
            subscription.setProperties(subscriptionData);
            subscription.setId(subscriptionId);
            Utils.getRegistryEventBrokerService().renewSubscription(subscription);
            return email;
        }
        catch (Exception e) {
            log.error((Object)"Unable to verify e-mail address", (Throwable)e);
            return null;
        }
    }

    public EventingServiceImpl() {
        try {
            if (initialized) {
                return;
            }
            initialized = true;
            this.eventTypeMap = new TreeMap<String, String[]>();
            this.eventTypeExclusionMap = new HashMap<String, List<String>>();
            this.emailIndexStoragePath = "/repository/components/org.wso2.carbon.email-verification/emailIndex";
            this.registerBuiltInEventTypes();
        }
        catch (Exception e) {
            log.error((Object)"Error initializing Registry Event Broker");
        }
    }

    public void registerBuiltInEventTypes() {
        this.registerEventType("update", "ResourceUpdated", "CollectionUpdated");
        this.registerEventType("delete", "ResourceDeleted", "CollectionDeleted");
        this.registerEventType("child.deleted", null, "ChildDeleted");
        this.registerEventType("child.created", null, "ChildCreated");
    }

    public void notify(RegistryEvent event) throws Exception {
        this.notify(event, null);
    }

    public void notify(RegistryEvent event, String endpoint) throws Exception {
        this.notify(event, endpoint, false);
    }

    private static synchronized void initializeDispatcher() {
        if (dispatcher == null) {
            dispatcher = new RegistryEventDispatcher();
            ((RegistryEventDispatcher)dispatcher).init(Utils.getConfigurationContext());
        }
    }

    public void notify(RegistryEvent event, String endpoint, boolean doRest) throws Exception {
        if (!initialized) {
            return;
        }
        if (this.executor == null) {
            this.setupExecutorService();
        }
        if (dispatcher == null) {
            try {
                EventingServiceImpl.initializeDispatcher();
            }
            catch (IllegalStateException ignored) {
                return;
            }
        }
        this.executor.submit(new Publisher(new DispatchEvent(event, endpoint, doRest)));
    }

    public void registerEventType(String typeId, String resourceEvent, String collectionEvent) {
        String[] eventNames = new String[]{resourceEvent, collectionEvent};
        this.eventTypeMap.put(typeId, eventNames);
    }

    @Override
    public List<Subscription> getAllSubscriptions() throws EventBrokerException {
        return Utils.getRegistryEventBrokerService().getAllSubscriptions(null);
    }

    @Override
    public List<Subscription> getAllSubscriptions(String userName, String remoteURL) throws EventBrokerException {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public Map getEventTypes() {
        return this.eventTypeMap;
    }

    @Override
    public String getSubscriptionManagerUrl() {
        return Utils.getDefaultEventingServiceURL();
    }

    @Override
    public Subscription getSubscription(String id) {
        try {
            return Utils.getRegistryEventBrokerService().getSubscription(id);
        }
        catch (EventBrokerException e) {
            log.error((Object)("Unable to get subscription for given id: " + id), (Throwable)e);
            return null;
        }
    }

    private void requestEmailVerification(Subscription subscription, String userName, String remoteURL) {
        int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
        if (this.executor == null) {
            this.setupExecutorService();
        }
        if (!subscription.getProperties().isEmpty()) {
            this.executor.submit(new EmailVerifier(subscription, userName, remoteURL, tenantId));
        }
    }

    private synchronized void setupExecutorService() {
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(25, 150, 1000L, TimeUnit.NANOSECONDS, new ArrayBlockingQueue<Runnable>(100));
        }
    }

    @Override
    public String subscribe(Subscription subscription, String userName, String remoteURL) {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    @Override
    public String subscribe(Subscription subscription) {
        try {
            boolean emailAvailability = this.isEmailAlreadyAvailable(subscription);
            if ((subscription.getEventSinkURL().startsWith("mailto:") || subscription.getEventSinkURL().startsWith("digest:")) && !emailAvailability) {
                Map subscriptionData = subscription.getProperties();
                subscriptionData.put("notVerfied", Boolean.toString(true));
                subscription.setProperties(subscriptionData);
            }
            String subscribe = Utils.getRegistryEventBrokerService().subscribe(subscription);
            this.requestEmailVerification(subscription, null, null);
            return subscribe;
        }
        catch (EventBrokerException e) {
            log.error((Object)"Unable to add subscription", (Throwable)e);
            return null;
        }
    }

    private boolean isEmailAlreadyAvailable(Subscription subscription) {
        if (Boolean.parseBoolean(System.getProperty("onetime.email.verification", Boolean.toString(false)))) {
            String email = subscription.getEventSinkURL().substring(subscription.getEventSinkURL().indexOf(":") + 1, subscription.getEventSinkURL().length());
            try {
                UserRegistry registry = Utils.getRegistryService().getConfigSystemRegistry();
                String emailIndexPath = this.emailIndexStoragePath;
                if (registry.resourceExists(emailIndexPath)) {
                    Resource emailIndexResource = registry.get(emailIndexPath);
                    Collection<Object> values = emailIndexResource.getProperties().values();
                    Iterator<Object> it = values.iterator();
                    while (it.hasNext()) {
                        String value = ((ArrayList)it.next()).toArray()[0].toString();
                        if (!value.equals(email)) continue;
                        return true;
                    }
                } else {
                    Resource emailIndexResource = registry.newResource();
                    registry.put(emailIndexPath, emailIndexResource);
                }
            }
            catch (RegistryException e) {
                log.error((Object)"Unable to check email verification resource", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public Subscription getSubscription(String id, String userName, String remoteURL) {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    @Override
    public boolean unsubscribe(String subscriptionID) {
        try {
            Utils.getRegistryEventBrokerService().unsubscribe(subscriptionID);
            return true;
        }
        catch (EventBrokerException e) {
            log.error((Object)("Unable to unsubscribe using given id: " + subscriptionID), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean unsubscribe(String subscriptionID, String userName, String remoteURL) {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public void registerEventTypeExclusion(String typeId, String path) {
        if (path == null) {
            return;
        }
        List<String> list = this.eventTypeExclusionMap.get(typeId);
        if (list == null) {
            list = new LinkedList<String>();
        }
        list.add(path);
        this.eventTypeExclusionMap.put(typeId, list);
    }

    public boolean isEventTypeExclusionRegistered(String typeId, String path) {
        List<String> list = this.eventTypeExclusionMap.get(typeId);
        if (list == null) {
            return false;
        }
        for (String s : list) {
            if (!path.matches(s)) continue;
            return true;
        }
        return false;
    }

    private static class Publisher
    implements Runnable {
        private DispatchEvent event;

        public Publisher(DispatchEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SuperTenantCarbonContext.startTenantFlow();
                try {
                    String username;
                    RegistryEvent.RegistrySession registrySessionDetails;
                    SuperTenantCarbonContext context = SuperTenantCarbonContext.getCurrentContext();
                    int tenantId = this.event.getTenantId();
                    if (tenantId > -1) {
                        context.setTenantId(tenantId, true);
                    }
                    if ((registrySessionDetails = this.event.getRegistrySessionDetails()) != null && (username = registrySessionDetails.getUsername()) != null) {
                        context.setUsername(username);
                    }
                    if (this.event.getTopic().contains("ResourceUpdated")) {
                        Utils.getRegistryEventBrokerService().publish((Message)this.event, this.event.getTopic());
                        Utils.getRegistryEventBrokerService().publish((Message)this.event, this.event.getTopic().replace("ResourceUpdated", "CollectionUpdated"));
                    } else if (this.event.getTopic().contains("ResourceAdded")) {
                        Utils.getRegistryEventBrokerService().publish((Message)this.event, this.event.getTopic());
                        Utils.getRegistryEventBrokerService().publish((Message)this.event, this.event.getTopic().replace("ResourceAdded", "CollectionAdded"));
                    } else if (this.event.getTopic().contains("ResourceCreated")) {
                        Utils.getRegistryEventBrokerService().publish((Message)this.event, this.event.getTopic());
                        Utils.getRegistryEventBrokerService().publish((Message)this.event, this.event.getTopic().replace("ResourceCreated", "CollectionCreated"));
                    } else if (this.event.getTopic().contains("ResourceDeleted")) {
                        Utils.getRegistryEventBrokerService().publish((Message)this.event, this.event.getTopic());
                        Utils.getRegistryEventBrokerService().publish((Message)this.event, this.event.getTopic().replace("ResourceDeleted", "CollectionDeleted"));
                    } else {
                        Utils.getRegistryEventBrokerService().publish((Message)this.event, this.event.getTopic());
                    }
                }
                finally {
                    SuperTenantCarbonContext.endTenantFlow();
                }
            }
            catch (EventBrokerException e) {
                log.error((Object)"Unable to send notification", (Throwable)e);
            }
        }
    }

    private static class EmailVerifier
    implements Runnable {
        private Subscription subscription;
        private String userName;
        private String remoteURL;
        private int tenantId;

        public EmailVerifier(Subscription subscription, String userName, String remoteURL, int tenantId) {
            this.subscription = subscription;
            this.userName = userName;
            this.remoteURL = remoteURL;
            this.tenantId = tenantId;
        }

        @Override
        public void run() {
            SuperTenantCarbonContext.getCurrentContext().setTenantId(this.tenantId, true);
            if (Utils.getEmailVerificationSubscriber() == null) {
                return;
            }
            String email = this.subscription.getEventSinkURL().toLowerCase();
            if (email.startsWith("digest:")) {
                email = email.substring("digest:".length() + 4);
            }
            email = email.substring("mailto:".length());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("email", email);
            data.put("subscriptionId", this.subscription.getId());
            if (this.userName != null) {
                data.put("username", this.userName);
            }
            if (this.remoteURL != null) {
                data.put("remoteURL", this.remoteURL);
            }
            try {
                Utils.getEmailVerificationSubscriber().requestUserVerification(data, Utils.getEmailVerifierConfig());
            }
            catch (Exception e) {
                log.error((Object)"Unable to create e-mail verification request", (Throwable)e);
            }
        }
    }
}

