/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.eventing.internal;

import java.io.File;
import java.net.SocketException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.email.verification.util.EmailVerifcationSubscriber;
import org.wso2.carbon.email.verification.util.EmailVerifierConfig;
import org.wso2.carbon.email.verification.util.Util;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.event.core.subscription.EventDispatcher;
import org.wso2.carbon.registry.admin.api.jmx.INotificationService;
import org.wso2.carbon.registry.app.RemoteRegistryService;
import org.wso2.carbon.registry.common.eventing.NotificationService;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.URLMatcher;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.eventing.RegistryEventDispatcher;
import org.wso2.carbon.registry.eventing.exceptions.ActivationException;
import org.wso2.carbon.registry.eventing.handlers.RegistryEventingHandler;
import org.wso2.carbon.registry.eventing.handlers.erbsm.EmbeddedRegistryBasedSubscriptionManagerResourceRelocateHandler;
import org.wso2.carbon.registry.eventing.internal.JMXEventsBean;
import org.wso2.carbon.registry.eventing.internal.Utils;
import org.wso2.carbon.registry.eventing.services.EventingService;
import org.wso2.carbon.registry.eventing.services.EventingServiceImpl;
import org.wso2.carbon.registry.eventing.services.SubscriptionEmailVerficationService;
import org.wso2.carbon.registry.extensions.jmx.Events;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.NetworkUtils;

public class RegistryEventingServiceComponent {
    private static Log log = LogFactory.getLog(RegistryEventingServiceComponent.class);
    private boolean configurationDone = false;
    private Registry registry = null;
    private ConfigurationContextService configurationContextService = null;
    private ListenerManager listenerManager = null;
    private boolean initialized = false;
    private String endpoint = null;
    private ServiceRegistration eventingServiceRegistration = null;
    private ServiceRegistration notificationServiceRegistration = null;
    private ServiceRegistration emailVerificationServiceRegistration = null;
    private EventingServiceImpl service = null;
    private BundleContext bundleContext = null;
    private String eventingRoot = "/repository/components/org.wso2.carbon.event/";

    protected void activate(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
        this.initialize();
        this.registerEventingService();
        log.debug((Object)"Registry Eventing bundle is activated ");
    }

    private void registerEventingService() {
        if (this.listenerManager != null && this.eventingServiceRegistration == null && this.bundleContext != null) {
            this.service = new EventingServiceImpl();
            this.eventingServiceRegistration = this.bundleContext.registerService(EventingService.class.getName(), (Object)this.service, null);
            this.notificationServiceRegistration = this.bundleContext.registerService(NotificationService.class.getName(), (Object)this.service, null);
            this.emailVerificationServiceRegistration = this.bundleContext.registerService(SubscriptionEmailVerficationService.class.getName(), (Object)this.service, null);
            Utils.setRegistryEventingService(this.service);
            log.debug((Object)"Successfully setup the Eventing OGSi Service");
        }
    }

    private void unregisterEventingService() {
        if (this.eventingServiceRegistration != null) {
            Utils.setRegistryEventingService(null);
            this.eventingServiceRegistration.unregister();
            this.eventingServiceRegistration = null;
            this.notificationServiceRegistration.unregister();
            this.notificationServiceRegistration = null;
            this.emailVerificationServiceRegistration.unregister();
            this.emailVerificationServiceRegistration = null;
            this.service = null;
            log.debug((Object)"Successfully unregistered the Eventing OGSi Service");
        }
    }

    protected void deactivate(ComponentContext context) {
        this.unregisterEventingService();
        log.debug((Object)"Registry Eventing bundle is deactivated ");
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"The Configuration Context Service was set");
        this.configurationContextService = configurationContextService;
        if (configurationContextService != null) {
            Utils.setConfigurationContext(configurationContextService.getServerConfigContext());
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        Utils.setConfigurationContext(null);
    }

    protected void setRegistryService(RegistryService registryService) {
        Utils.setRegistryService(registryService);
    }

    private void setupEmailVerification() {
        if (Utils.getEmailVerificationSubscriber() == null) {
            return;
        }
        EmailVerifierConfig emailVerifierConfig = Utils.getEmailVerifierConfig();
        if (emailVerifierConfig == null) {
            String fileName = CarbonUtils.getCarbonConfigDirPath() + File.separator + "notifications-email-verification.xml";
            if (new File(fileName).exists()) {
                emailVerifierConfig = Util.loadeMailVerificationConfig((String)fileName);
            }
            if (emailVerifierConfig == null) {
                emailVerifierConfig = new EmailVerifierConfig();
            }
            if (emailVerifierConfig.getEmailBody() == null) {
                emailVerifierConfig.setEmailBody("To complete your subscription process, please click on the link below to verify your e-mail address.");
            }
            if (emailVerifierConfig.getEmailFooter() == null) {
                emailVerifierConfig.setEmailFooter("This message is automatically generated by the WSO2 Carbon Registry.");
            }
            if (emailVerifierConfig.getTargetEpr() == null) {
                String registryURL = Utils.getDefaultEventingServiceURL();
                if (registryURL != null && registryURL.indexOf("/services/RegistryEventingService") > -1) {
                    registryURL = registryURL.substring(0, registryURL.length() - "/services/RegistryEventingService".length()) + "/carbon";
                }
                if (registryURL == null) {
                    log.error((Object)"Unable to obtain registry URL");
                    emailVerifierConfig = null;
                    return;
                }
                if (!registryURL.endsWith("/")) {
                    registryURL = registryURL + "/";
                }
                emailVerifierConfig.setTargetEpr(registryURL + "info/subscription-email-verification.jsp");
            }
            if (emailVerifierConfig.getSubject() == null) {
                emailVerifierConfig.setSubject("E-mail Address Verification");
            }
            if (emailVerifierConfig.getRedirectPath() == null) {
                emailVerifierConfig.setRedirectPath("../info/subscription-email-verified.jsp");
            }
            log.debug((Object)"The E-mail Verfication Component Configuration has been done.");
            Utils.setEmailVerifierConfig(emailVerifierConfig);
        }
    }

    protected void unsetEmailVerificationSubscriber(EmailVerifcationSubscriber emailVerificationSubscriber) {
        Utils.setEmailVerificationSubscriber(null);
    }

    protected void setEmailVerificationSubscriber(EmailVerifcationSubscriber emailVerificationSubscriber) {
        Utils.setEmailVerificationSubscriber(emailVerificationSubscriber);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Utils.setRegistryService(null);
    }

    protected void setEventBroker(EventBroker eventBroker) {
        Utils.setRegistryEventBrokerService(eventBroker);
    }

    protected void unsetEventBroker(EventBroker eventBroker) {
        Utils.setRegistryEventBrokerService(null);
    }

    protected void setListenerManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    protected void setEvents(Events notifications) {
        JMXEventsBean implBean = new JMXEventsBean();
        notifications.setImplBean((INotificationService)implBean);
        Utils.setEventsBean(implBean);
    }

    protected void unsetEvents(Events notifications) {
        Utils.setEventsBean(null);
        notifications.setImplBean(null);
    }

    protected void unsetListenerManager(ListenerManager listenerManager) {
        this.listenerManager = null;
        this.unregisterEventingService();
    }

    private void initialize() {
        ConfigurationContext serverConfigurationContext = this.configurationContextService.getServerConfigContext();
        if (!this.configurationDone && this.listenerManager != null && Utils.getRegistryService() != null) {
            AxisConfiguration config;
            String host;
            try {
                host = NetworkUtils.getLocalHostname();
            }
            catch (SocketException e) {
                host = null;
                log.warn((Object)"An error occured while determining server host", (Throwable)e);
            }
            if (host == null) {
                host = System.getProperty("carbon.local.ip");
                log.warn((Object)"Unable to obtain server host, using the carbon.local.ip system property to determine the ip address.");
            }
            log.debug((Object)("Found Server Host: " + host));
            if (serverConfigurationContext != null && (config = serverConfigurationContext.getAxisConfiguration()) != null && config.getTransportIn("https") != null && config.getTransportIn("https").getReceiver() != null) {
                String msg;
                try {
                    EndpointReference[] eprArray = config.getTransportIn("https").getReceiver().getEPRsForService("RegistryEventingService", host);
                    if (eprArray != null && eprArray[0] != null) {
                        this.endpoint = eprArray[0].getAddress();
                        if (this.endpoint != null && this.endpoint.endsWith("/")) {
                            this.endpoint = this.endpoint.substring(0, this.endpoint.length() - 1);
                        }
                    } else {
                        msg = "Unable to obtain EPR for service. Attempting to construct EPR based on known parameters.";
                        log.warn((Object)msg);
                    }
                }
                catch (AxisFault e) {
                    msg = "Error occured while obtaining EPR for service. Attempting to construct EPR based on known parameters.";
                    log.warn((Object)msg, (Throwable)e);
                }
            }
            if (this.endpoint == null) {
                StringBuffer epBuf = new StringBuffer("https://");
                String port = null;
                try {
                    port = Integer.toString(CarbonUtils.getTransportPort((ConfigurationContext)serverConfigurationContext, (String)"https"));
                }
                catch (Exception e) {
                    port = null;
                    log.warn((Object)"Unable to get HTTP port from Server Axis Configuration, using system defined value");
                }
                if (port == null) {
                    port = System.getProperty("carbon.https.port");
                }
                log.debug((Object)("Found Server Port: " + port));
                if (host != null && port != null) {
                    epBuf.append(host);
                    epBuf.append(':');
                    epBuf.append(port);
                    AxisConfiguration axisConfig = null;
                    if (serverConfigurationContext != null) {
                        axisConfig = serverConfigurationContext.getAxisConfiguration();
                    }
                    if (axisConfig != null) {
                        log.debug((Object)"Successfully obtained the Axis Configuration");
                    }
                    if (axisConfig != null && serverConfigurationContext.getContextRoot() != null) {
                        String contextRoot = serverConfigurationContext.getContextRoot();
                        log.debug((Object)("Found Context Root: " + contextRoot));
                        epBuf.append(contextRoot);
                        if (!contextRoot.endsWith("/")) {
                            epBuf.append('/');
                        }
                    }
                    if (axisConfig != null && axisConfig.getParameter("servicePath") != null) {
                        log.debug((Object)("Found Service Path: " + axisConfig.getParameter("servicePath").getValue()));
                        epBuf.append((String)axisConfig.getParameter("servicePath").getValue());
                        epBuf.append('/');
                        this.endpoint = epBuf.toString() + "RegistryEventingService";
                    }
                }
            }
            if (this.endpoint == null) {
                String msg = "Failed obtaining server configuration";
                log.error((Object)msg);
                throw new ActivationException(msg);
            }
            log.debug((Object)("The Registry Eventing Service is available at: " + this.endpoint));
            try {
                this.setupHandlers();
                this.setupDispatchers();
                this.setupEmailVerification();
                log.debug((Object)"Successfully instantiated the Registry Event Source");
            }
            catch (Exception e) {
                String msg = "Error Instantiating Registry Event Source";
                log.error((Object)msg);
                throw new ActivationException(msg);
            }
            this.configurationDone = true;
        }
    }

    private void setupDispatchers() throws Exception {
        RegistryEventDispatcher dispatcher = new RegistryEventDispatcher();
        dispatcher.init(Utils.getConfigurationContext());
        if (Utils.getRegistryEventBrokerService() != null) {
            Utils.getRegistryEventBrokerService().registerEventDispatcher("/registry/notifications", (EventDispatcher)dispatcher);
        }
    }

    private void setupHandlers() {
        if (Boolean.toString(Boolean.TRUE).equals(System.getProperty("disable.event.handlers"))) {
            this.initialized = true;
            log.debug((Object)"Default Eventing Handlers have been disabled. Events will not be generated unless a custom handler has been configured.");
            return;
        }
        RegistryService registryService = Utils.getRegistryService();
        if (registryService instanceof RemoteRegistryService && !this.initialized) {
            this.initialized = true;
            log.warn((Object)"Eventing is not available on Remote Registry");
            return;
        }
        if (!this.initialized && this.listenerManager != null && registryService != null) {
            this.initialized = true;
            try {
                UserRegistry systemRegistry = registryService.getConfigSystemRegistry();
                if (this.registry != null && this.registry == systemRegistry) {
                    return;
                }
                this.registry = systemRegistry;
                if (this.registry == null || this.registry.getRegistryContext() == null || this.registry.getRegistryContext().getHandlerManager() == null) {
                    String msg = "Error Initializing Registry Eventing Handler";
                    log.error((Object)msg);
                } else {
                    URLMatcher filter = new URLMatcher();
                    filter.setDeletePattern(".*");
                    filter.setPutPattern(".*");
                    filter.setPutChildPattern(".*");
                    filter.setMovePattern(".*");
                    filter.setCopyPattern(".*");
                    filter.setRenamePattern(".*");
                    filter.setCreateVersionPattern(".*");
                    filter.setApplyTagPattern(".*");
                    filter.setRemoveTagPattern(".*");
                    filter.setAddCommentPattern(".*");
                    filter.setAddAssociationPattern(".*");
                    filter.setRemoveAssociationPattern(".*");
                    filter.setRateResourcePattern(".*");
                    filter.setCreateLinkPattern(".*");
                    filter.setRemoveLinkPattern(".*");
                    filter.setRestorePattern(".*");
                    RegistryEventingHandler handler = new RegistryEventingHandler();
                    this.registry.getRegistryContext().getHandlerManager().addHandler(null, (Filter)filter, (Handler)handler, "reporting");
                    this.registry.setEventingServiceURL(null, this.endpoint);
                    Utils.setDefaultEventingServiceURL(this.endpoint);
                    log.debug((Object)"Successfully Initialized the Registry Eventing Handler");
                    URLMatcher erbSubManagerRRFilter = new URLMatcher();
                    erbSubManagerRRFilter.setCopyPattern(".*");
                    erbSubManagerRRFilter.setRenamePattern(".*");
                    erbSubManagerRRFilter.setMovePattern(".*");
                    erbSubManagerRRFilter.setDeletePattern(".*");
                    EmbeddedRegistryBasedSubscriptionManagerResourceRelocateHandler erbSubManagerRRHanlder = new EmbeddedRegistryBasedSubscriptionManagerResourceRelocateHandler();
                    this.registry.getRegistryContext().getHandlerManager().addHandler(null, (Filter)erbSubManagerRRFilter, (Handler)erbSubManagerRRHanlder, "reporting");
                    erbSubManagerRRHanlder.init(this.registry.getRegistryContext(), this.eventingRoot);
                    log.debug((Object)"Successfully Initialized the Subscription Manager Resource Relocate Handler");
                    log.info((Object)"Successfully Initialized Eventing on Registry");
                }
            }
            catch (Exception e) {
                String msg = "Error Initializing Eventing on Registry";
                log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
    }
}

