/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.eventing.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.wso2.carbon.registry.admin.api.jmx.INotificationService;

public class JMXEventsBean
implements INotificationService {
    private static final SimpleDateFormat NOTIFICATION_TIME = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss,SSS] ");
    private volatile Queue<String> notifications = new LinkedList<String>();
    private NotificationBroadcasterSupport broadcaster;
    private String event;
    private AtomicLong sequenceNumber = new AtomicLong();

    public void addNotification(Date timestamp, String notification) {
        this.broadcaster.sendNotification(new Notification(this.event, this.broadcaster, this.sequenceNumber.getAndIncrement(), timestamp.getTime(), notification));
        this.notifications.add(NOTIFICATION_TIME.format(timestamp) + notification);
    }

    public String[] getList() {
        return this.notifications.toArray(new String[this.notifications.size()]);
    }

    public void clearAll() {
        this.notifications = new LinkedList<String>();
    }

    public void registerBroadcaster(NotificationBroadcasterSupport broadcaster, String event) {
        this.broadcaster = broadcaster;
        this.event = event;
    }
}

