/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.eventing.handlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.eventing.RegistryEvent;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.eventing.events.ChildCreatedEvent;
import org.wso2.carbon.registry.eventing.events.ChildDeletedEvent;
import org.wso2.carbon.registry.eventing.events.CollectionAddedEvent;
import org.wso2.carbon.registry.eventing.events.CollectionDeletedEvent;
import org.wso2.carbon.registry.eventing.events.CollectionUpdatedEvent;
import org.wso2.carbon.registry.eventing.events.ResourceAddedEvent;
import org.wso2.carbon.registry.eventing.events.ResourceDeletedEvent;
import org.wso2.carbon.registry.eventing.events.ResourceUpdatedEvent;
import org.wso2.carbon.registry.eventing.internal.Utils;

public class RegistryEventingHandler
extends Handler {
    private static final Log log = LogFactory.getLog(RegistryEventingHandler.class);

    public void put(RequestContext requestContext) throws RegistryException {
        RegistryEvent event;
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        boolean isNotCollection = !(requestContext.getResource() instanceof Collection);
        Resource resource = requestContext.getOldResource();
        if (resource == null) {
            if (isNotCollection) {
                event = new ResourceAddedEvent<String>("A resource was added at Path: " + relativePath);
                ((ResourceAddedEvent)event).setResourcePath(relativePath);
            } else {
                event = new CollectionAddedEvent<String>("A collection was added at Path: " + relativePath);
                ((CollectionAddedEvent)event).setResourcePath(relativePath);
            }
            event.setTenantId(CurrentSession.getCallerTenantId());
        } else {
            if (isNotCollection) {
                event = new ResourceUpdatedEvent<String>("The resource at path " + relativePath + " was updated.");
                ((ResourceUpdatedEvent)event).setResourcePath(relativePath);
            } else {
                event = new CollectionUpdatedEvent<String>("The collection at path " + relativePath + " was updated.");
                ((CollectionUpdatedEvent)event).setResourcePath(relativePath);
            }
            event.setParameter("RegistryOperation", "put");
            event.setTenantId(CurrentSession.getCallerTenantId());
        }
        try {
            this.notify(event, requestContext.getRegistry(), relativePath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Put Operation", e);
        }
    }

    public void delete(RequestContext requestContext) throws RegistryException {
        RegistryEvent event;
        ChildDeletedEvent<String> childDeletedEvent;
        boolean isNotCollection;
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        String parentPath = RegistryUtils.getParentPath((String)relativePath);
        boolean bl = isNotCollection = !(requestContext.getResource() instanceof Collection);
        if (isNotCollection) {
            childDeletedEvent = new ChildDeletedEvent<String>("A resource was removed from the collection " + parentPath + " at Path: " + relativePath);
            childDeletedEvent.setResourcePath(parentPath);
            childDeletedEvent.setParameter("ChildPath", relativePath);
            event = new ResourceDeletedEvent<String>("A resource at path " + relativePath + " was deleted.");
            ((ResourceDeletedEvent)event).setResourcePath(relativePath);
        } else {
            childDeletedEvent = new ChildDeletedEvent<String>("A collection was removed from the collection " + parentPath + " at Path: " + relativePath);
            childDeletedEvent.setResourcePath(parentPath);
            childDeletedEvent.setParameter("ChildPath", relativePath);
            event = new CollectionDeletedEvent<String>("A collection at path " + relativePath + " was deleted.");
            ((CollectionDeletedEvent)event).setResourcePath(relativePath);
        }
        childDeletedEvent.setTenantId(CurrentSession.getCallerTenantId());
        event.setTenantId(CurrentSession.getCallerTenantId());
        CollectionUpdatedEvent<String> parentEvent = new CollectionUpdatedEvent<String>("The collection at path " + parentPath + " was updated.");
        parentEvent.setResourcePath(parentPath);
        parentEvent.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(childDeletedEvent, requestContext.getRegistry(), parentPath);
            this.notify(event, requestContext.getRegistry(), relativePath);
            this.notify(parentEvent, requestContext.getRegistry(), parentPath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Delete Operation", e);
        }
    }

    public void createVersion(RequestContext requestContext) throws RegistryException {
        RegistryEvent event;
        boolean isNotCollection;
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        boolean bl = isNotCollection = !(requestContext.getRepository().get(path) instanceof Collection);
        if (isNotCollection) {
            event = new ResourceUpdatedEvent<String>("A Checkpoint was created for the resource at path " + relativePath + ".");
            ((ResourceUpdatedEvent)event).setResourcePath(relativePath);
        } else {
            event = new CollectionUpdatedEvent<String>("A Checkpoint was created for the collection at path " + relativePath + ".");
            ((CollectionUpdatedEvent)event).setResourcePath(relativePath);
        }
        event.setParameter("RegistryOperation", "createVersion");
        event.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(event, requestContext.getRegistry(), relativePath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Create Version Operation", e);
        }
    }

    public void applyTag(RequestContext requestContext) throws RegistryException {
        RegistryEvent event;
        boolean isNotCollection;
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        String tag = requestContext.getTag();
        boolean bl = isNotCollection = !(requestContext.getRepository().get(path) instanceof Collection);
        if (isNotCollection) {
            event = new ResourceUpdatedEvent<String>("The tag " + tag + " was applied on resource " + relativePath + ".");
            ((ResourceUpdatedEvent)event).setResourcePath(relativePath);
        } else {
            event = new CollectionUpdatedEvent<String>("The tag " + tag + " was applied on resource " + relativePath + ".");
            ((CollectionUpdatedEvent)event).setResourcePath(relativePath);
        }
        event.setParameter("RegistryOperation", "applyTag");
        event.setParameter("TagsAdded", tag);
        event.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(event, requestContext.getRegistry(), relativePath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Apply Tag Operation", e);
        }
    }

    public void removeTag(RequestContext requestContext) throws RegistryException {
        RegistryEvent event;
        boolean isNotCollection;
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        String tag = requestContext.getTag();
        boolean bl = isNotCollection = !(requestContext.getRepository().get(path) instanceof Collection);
        if (isNotCollection) {
            event = new ResourceUpdatedEvent<String>("An attempt was made to remove the tag " + tag + ", applied on resource " + relativePath + ".");
            ((ResourceUpdatedEvent)event).setResourcePath(relativePath);
        } else {
            event = new CollectionUpdatedEvent<String>("An attempt was made to remove the tag " + tag + ", applied on collection " + relativePath + ".");
            ((CollectionUpdatedEvent)event).setResourcePath(relativePath);
        }
        event.setParameter("RegistryOperation", "removeTag");
        event.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(event, requestContext.getRegistry(), relativePath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Remove Tag Operation", e);
        }
    }

    public String addComment(RequestContext requestContext) throws RegistryException {
        RegistryEvent event;
        boolean isNotCollection;
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        if (requestContext.getComment() == null) {
            return null;
        }
        String comment = requestContext.getComment().getText();
        boolean bl = isNotCollection = !(requestContext.getRepository().get(path) instanceof Collection);
        if (isNotCollection) {
            event = new ResourceUpdatedEvent<String>("A comment was added to the resource at " + relativePath + ". Comment: " + comment);
            ((ResourceUpdatedEvent)event).setResourcePath(relativePath);
        } else {
            event = new CollectionUpdatedEvent<String>("A comment was added to the collection at " + relativePath + ". Comment: " + comment);
            ((CollectionUpdatedEvent)event).setResourcePath(relativePath);
        }
        event.setParameter("RegistryOperation", "addComment");
        event.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(event, requestContext.getRegistry(), relativePath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Add Comment Operation", e);
        }
        return null;
    }

    public void rateResource(RequestContext requestContext) throws RegistryException {
        RegistryEvent event;
        boolean isNotCollection;
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        int rating = requestContext.getRating();
        boolean bl = isNotCollection = !(requestContext.getRepository().get(path) instanceof Collection);
        if (isNotCollection) {
            event = new ResourceUpdatedEvent<String>("A rating of " + Integer.toString(rating) + " was given to the resource at " + relativePath + ".");
            ((ResourceUpdatedEvent)event).setResourcePath(relativePath);
        } else {
            event = new CollectionUpdatedEvent<String>("A rating of " + Integer.toString(rating) + " was given to the collection at " + relativePath + ".");
            ((CollectionUpdatedEvent)event).setResourcePath(relativePath);
        }
        event.setParameter("RegistryOperation", "rateResource");
        event.setParameter("Rating", Integer.toString(rating));
        event.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(event, requestContext.getRegistry(), relativePath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Rate Resource Operation", e);
        }
    }

    private String getPathWithoutVersion(String pathWithVersion) {
        ResourcePath path = new ResourcePath(pathWithVersion);
        return path.getPath();
    }

    public void addAssociation(RequestContext requestContext) throws RegistryException {
        RegistryEvent event;
        String targetType;
        String path = this.getPathWithoutVersion(requestContext.getSourcePath());
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        String targetPath = this.getPathWithoutVersion(requestContext.getTargetPath());
        String relativeTargetPath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)targetPath);
        String type = requestContext.getAssociationType();
        boolean isNotCollection = true;
        if (requestContext.getRepository().get(targetPath) == null) {
            return;
        }
        if (!(requestContext.getRepository().get(targetPath) instanceof Collection)) {
            targetType = "resource";
        } else {
            targetType = "collection";
            isNotCollection = false;
        }
        if (isNotCollection) {
            event = new ResourceUpdatedEvent<String>("An association of type " + type + " to the " + targetType + " at " + relativeTargetPath + " was added to the resource at " + relativePath + ".");
            ((ResourceUpdatedEvent)event).setResourcePath(relativePath);
        } else {
            event = new CollectionUpdatedEvent<String>("An association of type " + type + " to the " + targetType + " at " + relativeTargetPath + " was added to the collection at " + relativePath + ".");
            ((CollectionUpdatedEvent)event).setResourcePath(relativePath);
        }
        event.setParameter("RegistryOperation", "addAssociation");
        event.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(event, requestContext.getRegistry(), relativePath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Add Association Operation", e);
        }
    }

    public void removeAssociation(RequestContext requestContext) throws RegistryException {
        RegistryEvent event;
        String targetType;
        String path = this.getPathWithoutVersion(requestContext.getSourcePath());
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        String targetPath = this.getPathWithoutVersion(requestContext.getTargetPath());
        String relativeTargetPath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)targetPath);
        String type = requestContext.getAssociationType();
        boolean isNotCollection = true;
        if (requestContext.getRepository().get(targetPath) == null) {
            return;
        }
        if (!(requestContext.getRepository().get(targetPath) instanceof Collection)) {
            targetType = "resource";
        } else {
            targetType = "collection";
            isNotCollection = false;
        }
        if (isNotCollection) {
            event = new ResourceUpdatedEvent<String>("The association of type " + type + " to the " + targetType + " at " + relativeTargetPath + " was removed from the resource at " + relativePath + ".");
            ((ResourceUpdatedEvent)event).setResourcePath(relativePath);
        } else {
            event = new CollectionUpdatedEvent<String>("The association of type " + type + " to the " + targetType + " at " + relativeTargetPath + " was removed from the collection at " + relativePath + ".");
            ((CollectionUpdatedEvent)event).setResourcePath(relativePath);
        }
        event.setParameter("RegistryOperation", "removeAssociation");
        event.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(event, requestContext.getRegistry(), relativePath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Remove Association Operation", e);
        }
    }

    public void createLink(RequestContext requestContext) throws RegistryException {
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        String parentPath = RegistryUtils.getParentPath((String)relativePath);
        String target = requestContext.getTargetPath();
        String relativeTarget = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)target);
        CollectionUpdatedEvent<String> event = new CollectionUpdatedEvent<String>("A link to " + relativeTarget + " was created at " + relativePath + ".");
        event.setParameter("Destination", relativeTarget);
        event.setParameter("SymbolicLink", relativePath);
        event.setParameter("RegistryOperation", "createLink");
        event.setResourcePath(parentPath);
        event.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(event, requestContext.getRegistry(), parentPath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Create Link Operation", e);
        }
    }

    public void removeLink(RequestContext requestContext) throws RegistryException {
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        String parentPath = RegistryUtils.getParentPath((String)relativePath);
        CollectionUpdatedEvent<String> event = new CollectionUpdatedEvent<String>("The link at " + relativePath + " was removed.");
        event.setResourcePath(parentPath);
        event.setParameter("SymbolicLink", relativePath);
        event.setParameter("RegistryOperation", "removeLink");
        event.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(event, requestContext.getRegistry(), parentPath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Remove Link Operation", e);
        }
    }

    public void putChild(RequestContext requestContext) throws RegistryException {
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        boolean isNotCollection = !(requestContext.getResource() instanceof Collection);
        String parentPath = RegistryUtils.getParentPath((String)relativePath);
        Resource resource = requestContext.getOldResource();
        CollectionUpdatedEvent<String> parentEvent = null;
        ChildCreatedEvent<String> childCreatedEvent = null;
        if (resource == null) {
            if (isNotCollection) {
                childCreatedEvent = new ChildCreatedEvent<String>("A resource was added to the collection " + parentPath + " at Path: " + relativePath);
                childCreatedEvent.setParameter("ChildPath", relativePath);
                childCreatedEvent.setResourcePath(parentPath);
            } else {
                childCreatedEvent = new ChildCreatedEvent<String>("A collection was added to the collection " + parentPath + " at Path: " + relativePath);
                childCreatedEvent.setParameter("ChildPath", relativePath);
                childCreatedEvent.setResourcePath(parentPath);
            }
            childCreatedEvent.setTenantId(CurrentSession.getCallerTenantId());
            parentEvent = new CollectionUpdatedEvent<String>("The collection at path " + parentPath + " was updated.");
            parentEvent.setParameter("RegistryOperation", "putChild");
            parentEvent.setResourcePath(parentPath);
            parentEvent.setTenantId(CurrentSession.getCallerTenantId());
        }
        try {
            if (childCreatedEvent != null) {
                this.notify(childCreatedEvent, requestContext.getRegistry(), parentPath);
            }
            if (parentEvent != null) {
                this.notify(parentEvent, requestContext.getRegistry(), parentPath);
            }
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Put Operation", e);
        }
    }

    public String move(RequestContext requestContext) throws RegistryException {
        String path = requestContext.getSourcePath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        String targetPath = requestContext.getTargetPath();
        String relativeTargetPath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)targetPath);
        boolean isNotCollection = !(requestContext.getResource() instanceof Collection);
        String sourceParentPath = RegistryUtils.getParentPath((String)relativePath);
        String targetParentPath = RegistryUtils.getParentPath((String)relativeTargetPath);
        CollectionUpdatedEvent<String> sourceEvent = null;
        CollectionUpdatedEvent<String> targetEvent = null;
        RegistryEvent event = null;
        ChildDeletedEvent<String> childDeletedEvent = null;
        ChildCreatedEvent<String> childCreatedEvent = null;
        if (isNotCollection) {
            if (sourceParentPath != null) {
                sourceEvent = new CollectionUpdatedEvent<String>("A resource was moved from the collection " + sourceParentPath + " at Path: " + relativePath);
                sourceEvent.setResourcePath(sourceParentPath);
                sourceEvent.setParameter("RegistryOperation", "moveFrom");
                sourceEvent.setTenantId(CurrentSession.getCallerTenantId());
                childDeletedEvent = new ChildDeletedEvent<String>("A resource was removed from the collection " + sourceParentPath + " at Path: " + relativePath);
                childDeletedEvent.setResourcePath(sourceParentPath);
                childDeletedEvent.setParameter("ChildPath", relativePath);
                childDeletedEvent.setTenantId(CurrentSession.getCallerTenantId());
            }
            if (targetParentPath != null) {
                event = new ResourceUpdatedEvent<String>("The resource at Path: " + relativePath + " was moved to: " + targetParentPath);
                ((ResourceUpdatedEvent)event).setResourcePath(relativePath);
                event.setParameter("RegistryOperation", "move");
                event.setTenantId(CurrentSession.getCallerTenantId());
                targetEvent = new CollectionUpdatedEvent<String>("A resource was moved to the collection " + targetParentPath + " at Path: " + relativeTargetPath);
                targetEvent.setResourcePath(targetParentPath);
                targetEvent.setParameter("RegistryOperation", "moveTo");
                targetEvent.setTenantId(CurrentSession.getCallerTenantId());
                childCreatedEvent = new ChildCreatedEvent<String>("A resource was added to the collection " + targetParentPath + " at Path: " + relativeTargetPath);
                childCreatedEvent.setResourcePath(targetParentPath);
                childCreatedEvent.setParameter("ChildPath", relativeTargetPath);
                childCreatedEvent.setTenantId(CurrentSession.getCallerTenantId());
            }
        } else {
            if (sourceParentPath != null) {
                sourceEvent = new CollectionUpdatedEvent<String>("A collection was moved from the collection " + sourceParentPath + " at Path: " + relativePath);
                sourceEvent.setResourcePath(sourceParentPath);
                sourceEvent.setParameter("RegistryOperation", "moveFrom");
                sourceEvent.setTenantId(CurrentSession.getCallerTenantId());
                childDeletedEvent = new ChildDeletedEvent<String>("A collection was removed from the collection " + sourceParentPath + " at Path: " + relativePath);
                childDeletedEvent.setResourcePath(sourceParentPath);
                childDeletedEvent.setParameter("ChildPath", relativePath);
                childDeletedEvent.setTenantId(CurrentSession.getCallerTenantId());
            }
            if (targetParentPath != null) {
                event = new CollectionUpdatedEvent<String>("The collection at Path: " + relativePath + " was moved to: " + targetParentPath);
                ((CollectionUpdatedEvent)event).setResourcePath(relativePath);
                event.setParameter("RegistryOperation", "move");
                event.setTenantId(CurrentSession.getCallerTenantId());
                targetEvent = new CollectionUpdatedEvent<String>("A collection was moved to the collection " + targetParentPath + " at Path: " + relativeTargetPath);
                targetEvent.setResourcePath(targetParentPath);
                targetEvent.setParameter("RegistryOperation", "moveTo");
                targetEvent.setTenantId(CurrentSession.getCallerTenantId());
                childCreatedEvent = new ChildCreatedEvent<String>("A collection was added to the collection " + targetParentPath + " at Path: " + relativeTargetPath);
                childCreatedEvent.setResourcePath(targetParentPath);
                childCreatedEvent.setParameter("ChildPath", relativeTargetPath);
                childCreatedEvent.setTenantId(CurrentSession.getCallerTenantId());
            }
        }
        try {
            if (sourceEvent != null) {
                this.notify(sourceEvent, requestContext.getRegistry(), sourceParentPath);
            }
            if (event != null) {
                this.notify(event, requestContext.getRegistry(), relativePath);
            }
            if (targetEvent != null) {
                this.notify(targetEvent, requestContext.getRegistry(), targetParentPath);
            }
            if (childDeletedEvent != null) {
                this.notify(childDeletedEvent, requestContext.getRegistry(), sourceParentPath);
            }
            if (childCreatedEvent != null) {
                this.notify(childCreatedEvent, requestContext.getRegistry(), targetParentPath);
            }
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Move Operation", e);
        }
        return null;
    }

    public String copy(RequestContext requestContext) throws RegistryException {
        String path = requestContext.getSourcePath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        String targetPath = requestContext.getTargetPath();
        String relativeTargetPath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)targetPath);
        boolean isNotCollection = !(requestContext.getResource() instanceof Collection);
        String sourceParentPath = RegistryUtils.getParentPath((String)relativePath);
        String targetParentPath = RegistryUtils.getParentPath((String)relativeTargetPath);
        CollectionUpdatedEvent<String> sourceEvent = null;
        CollectionUpdatedEvent<String> targetEvent = null;
        ChildCreatedEvent<String> childCreatedEvent = null;
        if (isNotCollection) {
            if (sourceParentPath != null) {
                sourceEvent = new CollectionUpdatedEvent<String>("A resource was copied from the collection " + sourceParentPath + " at Path: " + relativePath);
                sourceEvent.setResourcePath(sourceParentPath);
                sourceEvent.setParameter("RegistryOperation", "copyFrom");
                sourceEvent.setTenantId(CurrentSession.getCallerTenantId());
            }
            if (targetParentPath != null) {
                targetEvent = new CollectionUpdatedEvent<String>("A resource was copied to the collection " + targetParentPath + " at Path: " + relativeTargetPath);
                targetEvent.setResourcePath(targetParentPath);
                targetEvent.setParameter("RegistryOperation", "copyTo");
                targetEvent.setTenantId(CurrentSession.getCallerTenantId());
                childCreatedEvent = new ChildCreatedEvent<String>("A resource was added to the collection " + targetParentPath + " at Path: " + relativeTargetPath);
                childCreatedEvent.setResourcePath(targetParentPath);
                childCreatedEvent.setParameter("ChildPath", relativeTargetPath);
                childCreatedEvent.setTenantId(CurrentSession.getCallerTenantId());
            }
        } else {
            if (sourceParentPath != null) {
                sourceEvent = new CollectionUpdatedEvent<String>("A collection was copied from the collection " + sourceParentPath + " at Path: " + relativePath);
                sourceEvent.setResourcePath(sourceParentPath);
                sourceEvent.setParameter("RegistryOperation", "copyFrom");
                sourceEvent.setTenantId(CurrentSession.getCallerTenantId());
            }
            if (targetParentPath != null) {
                targetEvent = new CollectionUpdatedEvent<String>("A collection was copied to the collection " + targetParentPath + " at Path: " + relativeTargetPath);
                targetEvent.setResourcePath(targetParentPath);
                targetEvent.setParameter("RegistryOperation", "copyTo");
                targetEvent.setTenantId(CurrentSession.getCallerTenantId());
                childCreatedEvent = new ChildCreatedEvent<String>("A collection was added to the collection " + targetParentPath + " at Path: " + relativeTargetPath);
                childCreatedEvent.setResourcePath(targetParentPath);
                childCreatedEvent.setParameter("ChildPath", relativeTargetPath);
                childCreatedEvent.setTenantId(CurrentSession.getCallerTenantId());
            }
        }
        try {
            if (sourceEvent != null) {
                this.notify(sourceEvent, requestContext.getRegistry(), sourceParentPath);
            }
            if (targetEvent != null) {
                this.notify(targetEvent, requestContext.getRegistry(), targetParentPath);
            }
            if (childCreatedEvent != null) {
                this.notify(childCreatedEvent, requestContext.getRegistry(), targetParentPath);
            }
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Copy Operation", e);
        }
        return null;
    }

    public String rename(RequestContext requestContext) throws RegistryException {
        RegistryEvent event;
        String path = requestContext.getSourcePath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        String targetPath = requestContext.getTargetPath();
        String relativeTargetPath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)targetPath);
        boolean isNotCollection = !(requestContext.getResource() instanceof Collection);
        String parentPath = RegistryUtils.getParentPath((String)relativePath);
        CollectionUpdatedEvent<String> parentEvent = null;
        if (isNotCollection) {
            event = new ResourceUpdatedEvent<String>("The resource at Path: " + relativePath + " was renamed to: " + relativeTargetPath);
            ((ResourceUpdatedEvent)event).setResourcePath(relativePath);
            event.setParameter("RegistryOperation", "rename");
            if (parentPath != null) {
                parentEvent = new CollectionUpdatedEvent<String>("A resource in the collection " + parentPath + " at Path: " + relativePath + " was renamed to: " + relativeTargetPath);
                parentEvent.setResourcePath(parentPath);
                parentEvent.setParameter("RegistryOperation", "childRenamed");
                parentEvent.setTenantId(CurrentSession.getCallerTenantId());
            }
        } else {
            event = new CollectionUpdatedEvent<String>("The collection at Path: " + relativePath + " was renamed to: " + relativeTargetPath);
            ((CollectionUpdatedEvent)event).setResourcePath(relativePath);
            event.setParameter("RegistryOperation", "rename");
            if (parentPath != null) {
                parentEvent = new CollectionUpdatedEvent<String>("A collection in the collection " + parentPath + " at Path: " + relativePath + " was renamed to: " + relativeTargetPath);
                parentEvent.setResourcePath(parentPath);
                parentEvent.setParameter("RegistryOperation", "childRenamed");
                parentEvent.setTenantId(CurrentSession.getCallerTenantId());
            }
        }
        event.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(event, requestContext.getRegistry(), relativePath);
            if (parentEvent != null) {
                this.notify(parentEvent, requestContext.getRegistry(), parentPath);
            }
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Rename Operation", e);
        }
        return null;
    }

    public void restore(RequestContext requestContext) throws RegistryException {
        RegistryEvent event;
        boolean isNotCollection;
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        boolean bl = isNotCollection = !(requestContext.getResource() instanceof Collection);
        if (isNotCollection) {
            event = new ResourceUpdatedEvent<String>("The resource at path " + relativePath + " was restored.");
            ((ResourceUpdatedEvent)event).setResourcePath(relativePath);
        } else {
            event = new CollectionUpdatedEvent<String>("The collection at path " + relativePath + " was restored.");
            ((CollectionUpdatedEvent)event).setResourcePath(relativePath);
        }
        event.setParameter("RegistryOperation", "restore");
        event.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(event, requestContext.getRegistry(), relativePath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Restore Operation", e);
        }
    }

    protected void notify(RegistryEvent event, Registry registry, String path) throws Exception {
        try {
            if (Utils.getRegistryEventingService() == null) {
                log.debug((Object)"Eventing service is unavailable.");
                return;
            }
            if (registry == null || registry.getEventingServiceURL(path) == null) {
                Utils.getRegistryEventingService().notify(event);
                return;
            }
            if (Utils.getDefaultEventingServiceURL() != null) {
                if (registry.getEventingServiceURL(path).equals(Utils.getDefaultEventingServiceURL())) {
                    Utils.getRegistryEventingService().notify(event);
                    return;
                }
                Utils.getRegistryEventingService().notify(event, registry.getEventingServiceURL(path));
                return;
            }
            log.error((Object)"Registry Eventing Handler is not properly initialized");
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to send notification", (Throwable)e);
            return;
        }
        log.error((Object)"Unable to send notification");
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
    }
}

