/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.samples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;

public class Sample {
    public void setup() {
        try {
            JhlClientAdapterFactory.setup();
        }
        catch (SVNClientException e) {
            // empty catch block
        }
        try {
            CmdLineClientAdapterFactory.setup();
        }
        catch (SVNClientException sVNClientException) {
            // empty catch block
        }
    }

    public void run() {
        ISVNClientAdapter svnClient;
        this.setup();
        try {
            String bestClientType = SVNClientAdapterFactory.getPreferredSVNClientType();
            System.out.println("Using " + bestClientType + " factory");
            svnClient = SVNClientAdapterFactory.createSVNClient(bestClientType);
        }
        catch (SVNClientException e) {
            System.out.println(e.getMessage());
            return;
        }
        svnClient.setUsername("guest");
        svnClient.setPassword(" ");
        NotifyListener listener = new NotifyListener();
        svnClient.addNotifyListener(listener);
        try {
            InputStream is = svnClient.getContent(new SVNUrl("http://subclipse.tigris.org/svn/subclipse/trunk/svnClientAdapter/readme.txt"), SVNRevision.HEAD);
            System.out.println("The beginning of the file is :");
            byte[] bytes = new byte[100];
            is.read(bytes);
            System.out.println(new String(bytes));
        }
        catch (IOException e) {
            System.out.println("An exception occured while getting remote file :" + e.getMessage());
        }
        catch (SVNClientException e) {
            System.out.println("An exception occured while getting remote file :" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        Sample sample = new Sample();
        sample.run();
    }

    public static class NotifyListener
    implements ISVNNotifyListener {
        public void setCommand(int cmd) {
        }

        public void logMessage(String message) {
            System.out.println(message);
        }

        public void logCommandLine(String message) {
            System.out.println(message);
        }

        public void logError(String message) {
            System.out.println("error :" + message);
        }

        public void logRevision(long revision, String path) {
            System.out.println("revision :" + revision);
        }

        public void logCompleted(String message) {
            System.out.println(message);
        }

        public void onNotify(File path, SVNNodeKind nodeKind) {
            System.out.println("Status of " + path.toString() + " has changed");
        }
    }
}

