/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigris.subversion.svnclientadapter.AbstractClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNDirEntryWithLock;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.ISVNMergeInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNProgressListener;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineAnnotations;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineInfoPart;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineLogMessage;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotificationHandler;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineProperty;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineRemoteDirEntry;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineRemoteDirEntryWithLock;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineStatusPart;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineStatuses;
import org.tigris.subversion.svnclientadapter.commandline.Helper;
import org.tigris.subversion.svnclientadapter.commandline.SvnAdminCommandLine;
import org.tigris.subversion.svnclientadapter.commandline.SvnCommandLine;
import org.tigris.subversion.svnclientadapter.commandline.SvnMultiArgCommandLine;

public class CmdLineClientAdapter
extends AbstractClientAdapter {
    protected final CmdLineNotificationHandler notificationHandler;
    protected final SvnCommandLine _cmd;
    protected final SvnMultiArgCommandLine _cmdMulti;
    protected final SvnAdminCommandLine svnAdminCmd;
    protected String version = null;
    private static boolean availabilityCached = false;
    private static boolean available;
    private static String dirName;

    public CmdLineClientAdapter(CmdLineNotificationHandler notificationHandler) {
        this(notificationHandler, new SvnCommandLine("svn", notificationHandler), new SvnMultiArgCommandLine("svn", notificationHandler), new SvnAdminCommandLine("svnadmin", notificationHandler));
    }

    protected CmdLineClientAdapter(CmdLineNotificationHandler notificationHandler, SvnCommandLine cmd, SvnMultiArgCommandLine multiCmd, SvnAdminCommandLine adminCmd) {
        this.notificationHandler = notificationHandler;
        this._cmd = cmd;
        this._cmdMulti = multiCmd;
        this.svnAdminCmd = adminCmd;
    }

    public boolean isThreadsafe() {
        return false;
    }

    public static boolean isAvailable() {
        if (!availabilityCached) {
            SvnCommandLine cmd = new SvnCommandLine("svn", new CmdLineNotificationHandler());
            try {
                String version = cmd.version();
                int i = version.indexOf(System.getProperty("line.separator"));
                version = version.substring(0, i);
                available = true;
                available &= version.indexOf("version 0.") == -1;
                available &= version.indexOf("version 1.0") == -1;
                available &= version.indexOf("version 1.1") == -1;
                available &= version.indexOf("version 1.2") == -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                available = false;
            }
            availabilityCached = true;
        }
        return available;
    }

    public String getVersion() throws SVNClientException {
        if (this.version != null) {
            return this.version;
        }
        try {
            this.notificationHandler.disableLog();
            this.version = this._cmd.version();
            int i = this.version.indexOf(System.getProperty("line.separator"));
            String string = this.version = this.version.substring(0, i);
            return string;
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
        finally {
            this.notificationHandler.enableLog();
        }
    }

    public void addNotifyListener(ISVNNotifyListener listener) {
        this.notificationHandler.add(listener);
    }

    public void removeNotifyListener(ISVNNotifyListener listener) {
        this.notificationHandler.remove(listener);
    }

    public SVNNotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    private boolean isManaged(File file) {
        if (file.isDirectory()) {
            return this.isManagedDir(file.getParentFile()) || this.isManagedDir(file);
        }
        return this.isManagedDir(file.getParentFile());
    }

    private boolean isManagedDir(File dir) {
        File entries = new File(dir, this.getAdminDirectoryName() + "/entries");
        return entries.exists();
    }

    public ISVNStatus[] getStatus(File[] files) throws SVNClientException {
        int i;
        CmdLineStatuses cmdLineStatuses;
        ISVNStatus[] statuses = new ISVNStatus[files.length];
        ArrayList<String> pathsList = new ArrayList<String>();
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = files[i2];
            if (this.isManaged(file)) {
                pathsList.add(CmdLineClientAdapter.toString(file));
                continue;
            }
            statuses[i2] = new SVNStatusUnversioned(file, false);
        }
        String[] paths = pathsList.toArray(new String[pathsList.size()]);
        try {
            CmdLineStatusPart[] cmdLineStatusParts = this.getCmdStatuses(paths, false, true, false, false);
            ArrayList<String> targetsInfo = new ArrayList<String>(cmdLineStatusParts.length);
            for (int i3 = 0; i3 < cmdLineStatusParts.length; ++i3) {
                if (!cmdLineStatusParts[i3].isManaged()) continue;
                targetsInfo.add(cmdLineStatusParts[i3].getFile().toString());
            }
            String cmdLineInfoStrings = this._cmd.info(targetsInfo.toArray(new String[targetsInfo.size()]), null, null);
            cmdLineStatuses = new CmdLineStatuses(cmdLineInfoStrings, cmdLineStatusParts);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
        for (i = 0; i < cmdLineStatuses.size(); ++i) {
            ISVNStatus status = cmdLineStatuses.get(i);
            for (int j = 0; j < files.length; ++j) {
                if (!files[j].getAbsoluteFile().equals(status.getFile())) continue;
                statuses[j] = status;
            }
        }
        for (i = 0; i < statuses.length; ++i) {
            if (statuses[i] != null) continue;
            statuses[i] = new SVNStatusUnversioned(files[i], false);
        }
        return statuses;
    }

    public ISVNStatus getSingleStatus(File path) throws SVNClientException {
        return this.getStatus(new File[]{path})[0];
    }

    private ISVNDirEntry[] getList(String target, SVNRevision rev, boolean recursive) throws SVNClientException {
        try {
            byte[] listXml = this._cmd.list(target, CmdLineClientAdapter.toString(rev), recursive);
            return CmdLineRemoteDirEntry.createDirEntries(listXml);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public ISVNDirEntry[] getList(SVNUrl svnUrl, SVNRevision revision, boolean recurse) throws SVNClientException {
        return this.getList(CmdLineClientAdapter.toString(svnUrl), revision, recurse);
    }

    public ISVNDirEntry[] getList(File path, SVNRevision revision, boolean recurse) throws SVNClientException {
        return this.getList(CmdLineClientAdapter.toString(path), revision, recurse);
    }

    public ISVNDirEntryWithLock[] getListWithLocks(SVNUrl url, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        ISVNDirEntry[] entries = this.getList(url, revision, pegRevision, recurse);
        ISVNDirEntryWithLock[] entriesWithLocks = new ISVNDirEntryWithLock[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            entriesWithLocks[i] = new CmdLineRemoteDirEntryWithLock(entries[i], null);
        }
        return entriesWithLocks;
    }

    public ISVNDirEntry getDirEntry(SVNUrl url, SVNRevision revision) throws SVNClientException {
        ISVNDirEntry[] entries = this.getList(url.getParent(), revision, false);
        String expectedPath = url.getLastPathSegment();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getPath().equals(expectedPath)) continue;
            return entries[i];
        }
        return null;
    }

    public ISVNDirEntry getDirEntry(File path, SVNRevision revision) throws SVNClientException {
        ISVNDirEntry[] entries = this.getList(path.getParentFile(), revision, false);
        String expectedPath = path.getName();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getPath().equals(expectedPath)) continue;
            return entries[i];
        }
        return null;
    }

    public void remove(File[] files, boolean force) throws SVNClientException {
        String[] paths = new String[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                paths[i] = files[i].toString();
            }
            this._cmd.delete(paths, null, force);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void revert(File file, boolean recursive) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.revert(new String[]{CmdLineClientAdapter.toString(file)}, recursive);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public InputStream getContent(SVNUrl arg0, SVNRevision arg1) throws SVNClientException {
        try {
            InputStream content = this._cmd.cat(CmdLineClientAdapter.toString(arg0), CmdLineClientAdapter.toString(arg1));
            byte[] byteArray = CmdLineClientAdapter.streamToByteArray(content);
            content.close();
            return new ByteArrayInputStream(byteArray);
        }
        catch (IOException e) {
            throw SVNClientException.wrapException(e);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public InputStream getContent(File path, SVNRevision revision) throws SVNClientException {
        try {
            InputStream content = this._cmd.cat(CmdLineClientAdapter.toString(path), CmdLineClientAdapter.toString(revision));
            byte[] byteArray = CmdLineClientAdapter.streamToByteArray(content);
            content.close();
            return new ByteArrayInputStream(byteArray);
        }
        catch (IOException e) {
            throw SVNClientException.wrapException(e);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void mkdir(SVNUrl arg0, String arg1) throws SVNClientException {
        try {
            this._cmd.mkdir(CmdLineClientAdapter.toString(arg0), arg1);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void remove(SVNUrl[] urls, String message) throws SVNClientException {
        String[] urlsStrings = new String[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            urlsStrings[i] = urls[i].toString();
        }
        try {
            this._cmd.delete(urlsStrings, message, false);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void copy(SVNUrl src, SVNUrl dest, String message, SVNRevision rev) throws SVNClientException {
        try {
            if (message == null) {
                message = "";
            }
            this._cmd.copy(CmdLineClientAdapter.toString(src), CmdLineClientAdapter.toString(dest), message, CmdLineClientAdapter.toString(rev), false);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void copy(File srcPath, File destPath) throws SVNClientException {
        try {
            this._cmd.copy(CmdLineClientAdapter.toString(srcPath), CmdLineClientAdapter.toString(destPath));
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
        for (int i = 0; i < 50 && !destPath.exists(); ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
        }
    }

    public void move(SVNUrl url, SVNUrl destUrl, String message, SVNRevision revision) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(new File("."));
            this._cmd.move(CmdLineClientAdapter.toString(url), CmdLineClientAdapter.toString(destUrl), message, CmdLineClientAdapter.toString(revision), false);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void move(File file, File file2, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{file, file2}));
            this._cmd.move(CmdLineClientAdapter.toString(file), CmdLineClientAdapter.toString(file2), null, null, force);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void setUsername(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this._cmd.setUsername(string);
    }

    public void setPassword(String password) {
        if (password == null) {
            return;
        }
        this._cmd.setPassword(password);
    }

    public void addDirectory(File file, boolean recurse) throws SVNClientException {
        this.addDirectory(file, recurse, false);
    }

    public void addDirectory(File file, boolean recurse, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.add(CmdLineClientAdapter.toString(file), recurse, force);
        }
        catch (CmdLineException e) {
            if (e.getMessage().startsWith("svn: warning: ")) {
                return;
            }
            throw SVNClientException.wrapException(e);
        }
    }

    public void addFile(File file) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.add(CmdLineClientAdapter.toString(file), false, false);
        }
        catch (CmdLineException e) {
            if (e.getMessage().startsWith("svn: warning: ")) {
                return;
            }
            throw SVNClientException.wrapException(e);
        }
    }

    public long commit(File[] parents, String comment, boolean recurse) throws SVNClientException {
        return this.commit(parents, comment, recurse, false);
    }

    public long commit(File[] parents, String comment, boolean recurse, boolean keepLocks) throws SVNClientException {
        String[] paths = new String[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            paths[i] = CmdLineClientAdapter.toString(parents[i]);
        }
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(parents));
            this._cmd.checkin(paths, comment, keepLocks);
            return this._cmd.getRevision();
        }
        catch (CmdLineException e) {
            if ("".equals(e.getMessage())) {
                return -1L;
            }
            if (e.getMessage().startsWith("svn: Attempted to lock an already-locked dir")) {
                for (int i = 0; i < 50; ++i) {
                    try {
                        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(parents));
                        this._cmd.checkin(paths, comment, keepLocks);
                        return this._cmd.getRevision();
                    }
                    catch (CmdLineException e1) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e2) {
                            // empty catch block
                        }
                        continue;
                    }
                }
            }
            throw SVNClientException.wrapException(e);
        }
    }

    public long update(File file, SVNRevision revision, boolean b) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.update(CmdLineClientAdapter.toString(file), CmdLineClientAdapter.toString(revision));
            return this._cmd.getRevision();
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public long[] update(File[] files, SVNRevision revision, boolean recurse, boolean ignoreExternals) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(files[0]));
            this._cmdMulti.update(CmdLineClientAdapter.toString(files), CmdLineClientAdapter.toString(revision));
            return this._cmdMulti.getRevisions();
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void checkout(SVNUrl url, File destPath, SVNRevision revision, boolean b) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(destPath));
            this._cmd.checkout(CmdLineClientAdapter.toString(url), CmdLineClientAdapter.toString(destPath), CmdLineClientAdapter.toString(revision), b);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll) throws SVNClientException {
        return this.getStatus(path, descend, getAll, false);
    }

    protected CmdLineStatusPart[] getCmdStatuses(File[] paths, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws CmdLineException {
        String[] pathNames = new String[paths.length];
        for (int i = 0; i < pathNames.length; ++i) {
            pathNames[i] = CmdLineClientAdapter.toString(paths[i]);
        }
        return this.getCmdStatuses(pathNames, descend, getAll, contactServer, ignoreExternals);
    }

    protected CmdLineStatusPart[] getCmdStatuses(String[] paths, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws CmdLineException {
        if (paths.length == 0) {
            return new CmdLineStatusPart[0];
        }
        byte[] listXml = this._cmd.status(paths, descend, getAll, contactServer, ignoreExternals);
        return CmdLineStatusPart.CmdLineStatusPartFromXml.createStatusParts(listXml);
    }

    private void diff(String oldPath, SVNRevision oldPathRevision, String newPath, SVNRevision newPathRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        if (newPath == null) {
            newPath = oldPath;
        }
        if (oldPathRevision == null) {
            oldPathRevision = SVNRevision.BASE;
        }
        if (newPathRevision == null) {
            newPathRevision = SVNRevision.WORKING;
        }
        try {
            InputStream is = this._cmd.diff(oldPath, CmdLineClientAdapter.toString(oldPathRevision), newPath, CmdLineClientAdapter.toString(newPathRevision), recurse, ignoreAncestry, noDiffDeleted, force);
            CmdLineClientAdapter.streamToFile(is, outFile);
            is.close();
        }
        catch (IOException e) {
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void diff(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse) throws SVNClientException {
        if (oldPath == null) {
            oldPath = new File(".");
        }
        this.diff(oldPath, oldPathRevision, newPath, newPathRevision, outFile, recurse, true, false, false);
    }

    public void diff(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        if (oldPath == null) {
            oldPath = new File(".");
        }
        this.diff(CmdLineClientAdapter.toString(oldPath), oldPathRevision, CmdLineClientAdapter.toString(newPath), newPathRevision, outFile, recurse, ignoreAncestry, noDiffDeleted, force);
    }

    public void diff(File path, File outFile, boolean recurse) throws SVNClientException {
        this.diff(path, null, null, null, outFile, recurse);
    }

    public void diff(SVNUrl oldUrl, SVNRevision oldUrlRevision, SVNUrl newUrl, SVNRevision newUrlRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(oldUrl, oldUrlRevision, newUrl, newUrlRevision, outFile, recurse, true, false, false);
    }

    public void diff(SVNUrl oldUrl, SVNRevision oldUrlRevision, SVNUrl newUrl, SVNRevision newUrlRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        this.diff(CmdLineClientAdapter.toString(oldUrl), oldUrlRevision, CmdLineClientAdapter.toString(newUrl), newUrlRevision, outFile, recurse, ignoreAncestry, noDiffDeleted, force);
    }

    public void diff(SVNUrl url, SVNRevision oldUrlRevision, SVNRevision newUrlRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(url, oldUrlRevision, url, newUrlRevision, outFile, recurse);
    }

    public ISVNProperty propertyGet(File path, String propertyName) throws SVNClientException {
        try {
            InputStream valueAndData = this._cmd.propget(CmdLineClientAdapter.toString(path), propertyName);
            byte[] bytes = CmdLineClientAdapter.streamToByteArray(valueAndData);
            valueAndData.close();
            if (bytes.length == 0) {
                return null;
            }
            return new CmdLineProperty(propertyName, new String(bytes), path, bytes);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
        catch (IOException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public ISVNProperty propertyGet(SVNUrl url, String propertyName) throws SVNClientException {
        try {
            InputStream valueAndData = this._cmd.propget(url.toString(), propertyName);
            byte[] bytes = CmdLineClientAdapter.streamToByteArray(valueAndData);
            valueAndData.close();
            if (bytes.length == 0) {
                return null;
            }
            return new CmdLineProperty(propertyName, new String(bytes), url, bytes);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
        catch (IOException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public ISVNProperty propertyGet(SVNUrl url, SVNRevision revision, SVNRevision peg, String propertyName) throws SVNClientException {
        try {
            InputStream valueAndData = this._cmd.propget(url.toString(), propertyName, CmdLineClientAdapter.toString(revision), CmdLineClientAdapter.toString(peg));
            byte[] bytes = CmdLineClientAdapter.streamToByteArray(valueAndData);
            if (bytes.length == 0) {
                return null;
            }
            return new CmdLineProperty(propertyName, new String(bytes), url, bytes);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
        catch (IOException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void propertySet(File path, String propertyName, File propertyFile, boolean recurse) throws SVNClientException, IOException {
        try {
            this._cmd.propsetFile(propertyName, CmdLineClientAdapter.toString(propertyFile), CmdLineClientAdapter.toString(path), recurse);
            ISVNStatus[] statuses = this.getStatus(path, recurse, false);
            for (int i = 0; i < statuses.length; ++i) {
                this.notificationHandler.notifyListenersOfChange(statuses[i].getFile().getAbsolutePath());
            }
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void propertyDel(File path, String propertyName, boolean recurse) throws SVNClientException {
        try {
            this._cmd.propdel(propertyName, CmdLineClientAdapter.toString(path), recurse);
            ISVNStatus[] statuses = this.getStatus(path, recurse, false);
            for (int i = 0; i < statuses.length; ++i) {
                this.notificationHandler.notifyListenersOfChange(statuses[i].getFile().getAbsolutePath());
            }
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void setRevProperty(SVNUrl path, SVNRevision.Number revisionNo, String propName, String propertyData, boolean force) throws SVNClientException {
        try {
            this._cmd.revpropset(propName, propertyData, CmdLineClientAdapter.toString(path), Long.toString(revisionNo.getNumber()), force);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void mkdir(File file) throws SVNClientException {
        try {
            this._cmd.mkdir(CmdLineClientAdapter.toString(file));
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
        for (int i = 0; i < 50 && !file.exists(); ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void doImport(File path, SVNUrl url, String message, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this._cmd.importFiles(CmdLineClientAdapter.toString(path), CmdLineClientAdapter.toString(url), message, recurse);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void doExport(SVNUrl srcUrl, File destPath, SVNRevision revision, boolean force) throws SVNClientException {
        try {
            this._cmd.export(CmdLineClientAdapter.toString(srcUrl), CmdLineClientAdapter.toString(destPath), CmdLineClientAdapter.toString(revision), force);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void doExport(File srcPath, File destPath, boolean force) throws SVNClientException {
        try {
            this._cmd.export(CmdLineClientAdapter.toString(srcPath), CmdLineClientAdapter.toString(destPath), null, force);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void copy(File srcPath, SVNUrl destUrl, String message) throws SVNClientException {
        try {
            if (message == null) {
                message = "";
            }
            this._cmd.copy(CmdLineClientAdapter.toString(srcPath), CmdLineClientAdapter.toString(destUrl), message, null, false);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision) throws SVNClientException {
        try {
            this._cmd.copy(CmdLineClientAdapter.toString(srcUrl), CmdLineClientAdapter.toString(destPath), null, CmdLineClientAdapter.toString(revision), false);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void propertySet(File path, String propertyName, String propertyValue, boolean recurse) throws SVNClientException {
        try {
            this._cmd.propset(propertyName, propertyValue, CmdLineClientAdapter.toString(path), recurse);
            ISVNStatus[] statuses = this.getStatus(path, recurse, false);
            for (int i = 0; i < statuses.length; ++i) {
                this.notificationHandler.notifyListenersOfChange(statuses[i].getFile().getAbsolutePath());
            }
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    protected static String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    private ISVNLogMessage[] getLogMessages(String pathOrUrl, String[] paths, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        String revRange = CmdLineClientAdapter.toString(revisionStart) + ":" + CmdLineClientAdapter.toString(revisionEnd);
        try {
            byte[] messages = fetchChangePath ? this._cmd.logVerbose(pathOrUrl, paths, revRange, stopOnCopy, limit) : this._cmd.log(pathOrUrl, revRange, stopOnCopy, limit);
            return CmdLineLogMessage.createLogMessages(messages);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    private static void streamToFile(InputStream stream, File outFile) throws IOException {
        try {
            int tempByte;
            FileOutputStream os = new FileOutputStream(outFile);
            while ((tempByte = stream.read()) != -1) {
                os.write(tempByte);
            }
            os.close();
            stream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static byte[] streamToByteArray(InputStream stream) throws IOException {
        int tempByte;
        Vector<Byte> buffer = new Vector<Byte>(1024);
        while ((tempByte = stream.read()) != -1) {
            buffer.add(new Byte((byte)tempByte));
        }
        byte[] byteArray = new byte[buffer.size()];
        for (int i = 0; i < byteArray.length; ++i) {
            Byte b = (Byte)buffer.get(i);
            byteArray[i] = b;
        }
        return byteArray;
    }

    protected ISVNAnnotations annotate(String target, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(25);
            if (revisionStart == null) {
                revisionStart = new SVNRevision.Number(1L);
            }
            if (revisionEnd == null) {
                revisionEnd = SVNRevision.HEAD;
            }
            byte[] annotations = this._cmd.annotate(target, CmdLineClientAdapter.toString(revisionStart), CmdLineClientAdapter.toString(revisionEnd));
            InputStream contents = this._cmd.cat(target, revisionEnd.toString());
            CmdLineAnnotations result = CmdLineAnnotations.createFromXml(annotations, contents);
            try {
                contents.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return result;
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public ISVNAnnotations annotate(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        return this.annotate(CmdLineClientAdapter.toString(url), revisionStart, revisionEnd);
    }

    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        String target = CmdLineClientAdapter.toString(file);
        ISVNInfo info = this.getInfoFromWorkingCopy(file);
        if (SVNScheduleKind.ADD == info.getSchedule() && info.getCopyUrl() != null) {
            target = info.getCopyUrl().toString();
        }
        return this.annotate(target, revisionStart, revisionEnd);
    }

    public ISVNProperty[] getProperties(File path) throws SVNClientException {
        try {
            String propertiesString = this._cmd.proplist(CmdLineClientAdapter.toString(path), false);
            LinkedList<ISVNProperty> properties = new LinkedList<ISVNProperty>();
            StringTokenizer st = new StringTokenizer(propertiesString, Helper.NEWLINE);
            while (st.hasMoreTokens()) {
                String propertyLine = st.nextToken();
                if (propertyLine.startsWith("Properties on '")) continue;
                String propertyName = propertyLine.substring(2);
                properties.add(this.propertyGet(path, propertyName));
            }
            return properties.toArray(new ISVNProperty[0]);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public ISVNProperty[] getProperties(SVNUrl url) throws SVNClientException {
        try {
            String propertiesString = this._cmd.proplist(url.toString(), false);
            LinkedList<ISVNProperty> properties = new LinkedList<ISVNProperty>();
            StringTokenizer st = new StringTokenizer(propertiesString, Helper.NEWLINE);
            while (st.hasMoreTokens()) {
                String propertyLine = st.nextToken();
                if (propertyLine.startsWith("Properties on '")) continue;
                String propertyName = propertyLine.substring(2);
                properties.add(this.propertyGet(url, propertyName));
            }
            return properties.toArray(new ISVNProperty[0]);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void resolved(File path) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this._cmd.resolved(new String[]{CmdLineClientAdapter.toString(path)}, false);
            this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void createRepository(File path, String repositoryType) throws SVNClientException {
        try {
            this.svnAdminCmd.create(CmdLineClientAdapter.toString(path), repositoryType);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer) throws SVNClientException {
        return this.getStatus(path, descend, getAll, contactServer, false);
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws SVNClientException {
        try {
            CmdLineStatusPart[] cmdLineStatusParts = this.getCmdStatuses(new File[]{path}, descend, getAll, contactServer, ignoreExternals);
            ArrayList<String> targetsInfo = new ArrayList<String>(cmdLineStatusParts.length);
            ArrayList<Integer> nonManagedParts = new ArrayList<Integer>();
            for (int i = 0; i < cmdLineStatusParts.length; ++i) {
                if (cmdLineStatusParts[i].isManaged()) {
                    targetsInfo.add(cmdLineStatusParts[i].getFile().toString());
                    continue;
                }
                nonManagedParts.add(new Integer(i));
            }
            String infoLinesString = this._cmd.info(targetsInfo.toArray(new String[targetsInfo.size()]), null, null);
            String[] parts = CmdLineInfoPart.parseInfoParts(infoLinesString);
            CmdLineInfoPart[] cmdLineInfoParts = new CmdLineInfoPart[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                cmdLineInfoParts[i] = new CmdLineInfoPart(parts[i]);
            }
            CmdLineInfoPart[] allInfoParts = new CmdLineInfoPart[cmdLineStatusParts.length];
            for (Integer indexOfNonManaged : nonManagedParts) {
                allInfoParts[indexOfNonManaged.intValue()] = CmdLineInfoPart.createUnversioned(null);
            }
            block5: for (int i = 0; i < cmdLineInfoParts.length; ++i) {
                for (int j = i; j < allInfoParts.length; ++j) {
                    if (allInfoParts[j] != null) continue;
                    allInfoParts[j] = cmdLineInfoParts[i];
                    continue block5;
                }
            }
            CmdLineStatuses cmdLineStatuses = new CmdLineStatuses(cmdLineInfoParts, cmdLineStatusParts);
            return cmdLineStatuses.toArray();
        }
        catch (CmdLineException e) {
            if (e.getMessage().trim().matches("svn:.*is not a working copy.*")) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            throw SVNClientException.wrapException(e);
        }
    }

    public void cancelOperation() throws SVNClientException {
        this.notificationHandler.logMessage("Warning: operation canceled.");
        this._cmd.stopProcess();
    }

    public ISVNInfo getInfoFromWorkingCopy(File path) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            CmdLineStatusPart[] cmdLineStatusParts = this.getCmdStatuses(new File[]{path}, false, true, false, false);
            if (cmdLineStatusParts.length > 0 && cmdLineStatusParts[0].isManaged()) {
                String cmdLineInfoStrings = this._cmd.info(new String[]{CmdLineClientAdapter.toString(path)}, null, null);
                return new CmdLineInfoPart(cmdLineInfoStrings);
            }
            return CmdLineInfoPart.createUnversioned(path.getPath());
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public ISVNInfo getInfo(File path) throws SVNClientException {
        return this.getInfoFromWorkingCopy(path);
    }

    public ISVNInfo getInfo(SVNUrl url, SVNRevision revision, SVNRevision peg) throws SVNClientException {
        return this.getInfo(new SVNUrl[]{url}, revision, peg);
    }

    private ISVNInfo getInfo(SVNUrl[] urls, SVNRevision revision, SVNRevision peg) throws SVNClientException {
        try {
            String[] urlStrings = new String[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                urlStrings[i] = CmdLineClientAdapter.toString(urls[i]);
            }
            String cmdLineInfoStrings = this._cmd.info(urlStrings, CmdLineClientAdapter.toString(revision), CmdLineClientAdapter.toString(peg));
            return new CmdLineInfoPart(cmdLineInfoStrings);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public ISVNInfo getInfo(SVNUrl[] urls) throws SVNClientException {
        return this.getInfo(urls, null, null);
    }

    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this._cmd.switchUrl(CmdLineClientAdapter.toString(path), CmdLineClientAdapter.toString(url), CmdLineClientAdapter.toString(revision), recurse);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void setConfigDirectory(File dir) throws SVNClientException {
        this._cmd.setConfigDirectory(CmdLineClientAdapter.toString(dir));
    }

    public void cleanup(File path) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(path));
            this._cmd.cleanup(CmdLineClientAdapter.toString(path));
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, boolean recurse, boolean dryRun, boolean ignoreAncestry) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(localPath));
            this._cmd.merge(CmdLineClientAdapter.toString(path1), CmdLineClientAdapter.toString(revision1), CmdLineClientAdapter.toString(path2), CmdLineClientAdapter.toString(revision2), CmdLineClientAdapter.toString(localPath), force, recurse, dryRun, ignoreAncestry);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void lock(SVNUrl[] uris, String comment, boolean force) throws SVNClientException {
        try {
            this._cmd.lock(uris, comment, force);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void unlock(SVNUrl[] uris, boolean force) throws SVNClientException {
        try {
            this._cmd.unlock(uris, force);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void lock(File[] paths, String comment, boolean force) throws SVNClientException {
        Object[] files = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = CmdLineClientAdapter.toString(paths[i]);
        }
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(paths));
            this._cmd.lock(files, comment, force);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
        finally {
            for (int i = 0; i < files.length; ++i) {
                this.notificationHandler.notifyListenersOfChange((String)files[i]);
            }
        }
    }

    public void unlock(File[] paths, boolean force) throws SVNClientException {
        Object[] files = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = CmdLineClientAdapter.toString(paths[i]);
        }
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(paths));
            this._cmd.unlock(files, force);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
        finally {
            for (int i = 0; i < files.length; ++i) {
                this.notificationHandler.notifyListenersOfChange((String)files[i]);
            }
        }
    }

    public String getAdminDirectoryName() {
        if (dirName == null) {
            if (CmdLineClientAdapter.isOsWindows()) {
                dirName = CmdLineClientAdapter.getEnvironmentVariable("SVN_ASP_DOT_NET_HACK");
            }
            dirName = dirName != null ? "_svn" : ".svn";
        }
        return dirName;
    }

    public boolean isAdminDirectory(String name) {
        return this.getAdminDirectoryName().equals(name);
    }

    public static String getEnvironmentVariable(String var) {
        try {
            return System.getenv(var);
        }
        catch (Error e) {
            try {
                return CmdLineClientAdapter.getEnvVars().getProperty(var);
            }
            catch (Throwable e1) {
                return null;
            }
        }
    }

    public static Properties getEnvVars() throws Throwable {
        Process p = null;
        Properties envVars = new Properties();
        Runtime r = Runtime.getRuntime();
        p = CmdLineClientAdapter.isOsWindows() ? (System.getProperty("os.name").toLowerCase().indexOf("windows 9") > -1 ? r.exec("command.com /c set") : r.exec("cmd.exe /c set")) : r.exec("env");
        if (p != null) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                int idx = line.indexOf(61);
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                envVars.setProperty(key, value);
            }
            p.getInputStream().close();
            p.getOutputStream().close();
            p.getErrorStream().close();
        }
        return envVars;
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revStart, SVNRevision revEnd, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(path, revStart, revEnd, false, fetchChangePath);
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(path, revStart, revEnd, stopOnCopy, fetchChangePath, 0L);
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        String target = CmdLineClientAdapter.toString(path);
        ISVNInfo info = this.getInfoFromWorkingCopy(path);
        if (SVNScheduleKind.ADD == info.getSchedule() && info.getCopyUrl() != null) {
            target = info.getCopyUrl().toString();
        }
        return this.getLogMessages(target, null, revStart, revEnd, stopOnCopy, fetchChangePath, limit);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision revStart, SVNRevision revEnd, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(url, null, revStart, revEnd, false, fetchChangePath);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision pegRevision, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        return this.getLogMessages(CmdLineClientAdapter.toString(url), null, revStart, revEnd, stopOnCopy, fetchChangePath, limit);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, String[] paths, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(CmdLineClientAdapter.toString(url), paths, revStart, revEnd, stopOnCopy, fetchChangePath, 0L);
    }

    public void relocate(String from, String to, String path, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File(path)));
            this._cmd.relocate(from, to, path, recurse);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void diff(File path, SVNUrl url, SVNRevision urlRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(CmdLineClientAdapter.toString(path), null, CmdLineClientAdapter.toString(url) + "@" + CmdLineClientAdapter.toString(urlRevision), null, outFile, recurse, true, false, false);
    }

    public void addConflictResolutionCallback(ISVNConflictResolver callback) {
    }

    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public ISVNAnnotations annotate(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public ISVNMergeInfo getMergeInfo(File path, SVNRevision revision) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public ISVNMergeInfo getMergeInfo(SVNUrl url, SVNRevision revision) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public void merge(SVNUrl url, SVNRevision pegRevision, SVNRevisionRange[] revisions, File localPath, boolean force, int depth, boolean ignoreAncestry, boolean dryRun) throws SVNClientException {
        this.notImplementedYet();
    }

    public SVNDiffSummary[] diffSummarize(File target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, int depth, boolean ignoreAncestry) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public SVNDiffSummary[] diffSummarize(File target1, SVNRevision revision1, SVNUrl target2, SVNRevision revision2, int depth, boolean ignoreAncestry) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public SVNDiffSummary[] diffSummarize(SVNUrl target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, int depth, boolean ignoreAncestry) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public SVNDiffSummary[] diffSummarize(SVNUrl target1, SVNRevision revision1, SVNUrl target2, SVNRevision revision2, int depth, boolean ignoreAncestry) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public String[] suggestMergeSources(File path) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public String[] suggestMergeSources(SVNUrl url, SVNRevision peg) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public void checkout(SVNUrl moduleName, File destPath, SVNRevision revision, int depth, boolean ignoreExternals, boolean force) throws SVNClientException {
        this.notImplementedYet();
    }

    public void copy(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision, boolean makeParents) throws SVNClientException {
        try {
            if (message == null) {
                message = "";
            }
            this._cmd.copy(CmdLineClientAdapter.toString(srcUrl), CmdLineClientAdapter.toString(destUrl), message, CmdLineClientAdapter.toString(revision), makeParents);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }

    public void diff(SVNUrl target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, File outFile, int depth, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        this.notImplementedYet();
    }

    public void diff(SVNUrl target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, File outFile, boolean recurse) throws SVNClientException {
        this.notImplementedYet();
    }

    public void dispose() {
    }

    public InputStream getContent(SVNUrl url, SVNRevision revision, SVNRevision pegRevision) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public ISVNDirEntry[] getList(SVNUrl url, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public ISVNDirEntry[] getList(File path, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public void resolve(File path, int result) throws SVNClientException {
        this.notImplementedYet();
    }

    public void setProgressListener(ISVNProgressListener progressListener) {
    }

    public void merge(SVNUrl url, SVNRevision pegRevision, SVNRevisionRange[] revisions, File localPath, boolean force, int depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws SVNClientException {
        this.notImplementedYet();
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, int depth, boolean dryRun, boolean ignoreAncestry, boolean recordOnly) throws SVNClientException {
        this.notImplementedYet();
    }

    public void copy(File[] srcPaths, SVNUrl destUrl, String message, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        this.notImplementedYet();
    }

    public void copy(SVNUrl[] srcUrls, SVNUrl destUrl, String message, SVNRevision revision, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        this.notImplementedYet();
    }

    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        this.notImplementedYet();
    }

    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, SVNRevision pegRevision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        this.notImplementedYet();
    }

    public long update(File path, SVNRevision revision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        this.notImplementedYet();
        return 0L;
    }

    public long[] update(File[] path, SVNRevision revision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public void mergeReintegrate(SVNUrl path, SVNRevision pegRevision, File localPath, boolean force, boolean dryRun) throws SVNClientException {
        this.notImplementedYet();
    }

    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        this.notImplementedYet();
    }

    public ISVNLogMessage[] getMergeinfoLog(int kind, File path, SVNRevision pegRevision, SVNUrl mergeSourceUrl, SVNRevision srcPegRevision, boolean discoverChangedPaths) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public ISVNLogMessage[] getMergeinfoLog(int kind, SVNUrl url, SVNRevision pegRevision, SVNUrl mergeSourceUrl, SVNRevision srcPegRevision, boolean discoverChangedPaths) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public void getLogMessages(File path, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions, String[] requestedProperties, ISVNLogMessageCallback callback) throws SVNClientException {
        this.notImplementedYet();
    }

    public void getLogMessages(SVNUrl url, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions, String[] requestedProperties, ISVNLogMessageCallback callback) throws SVNClientException {
        this.notImplementedYet();
    }

    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision, SVNRevision pegRevision, boolean copyAsChild, boolean makeParents) throws SVNClientException {
    }

    public ISVNInfo[] getInfo(File file, boolean descend) throws SVNClientException {
        return null;
    }

    public String getRevProperty(SVNUrl path, SVNRevision.Number revisionNo, String propName) throws SVNClientException {
        return null;
    }

    public ISVNAnnotations annotate(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd, SVNRevision pegRevision, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        return null;
    }

    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd, SVNRevision pegRevision, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        return null;
    }

    public ISVNProperty[] getProperties(SVNUrl url, SVNRevision revision, SVNRevision peg) throws SVNClientException {
        return null;
    }

    public ISVNProperty[] getRevProperties(SVNUrl url, SVNRevision.Number revision) throws SVNClientException {
        return null;
    }

    public SVNDiffSummary[] diffSummarize(File path, SVNUrl toUrl, SVNRevision toRevision, boolean recurse) throws SVNClientException {
        return null;
    }
}

