/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.eventing;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SimpleTimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.core.Message;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.event.ws.internal.notify.WSEventDispatcher;
import org.wso2.carbon.governance.notifications.worklist.stub.WorkListServiceStub;
import org.wso2.carbon.registry.common.eventing.RegistryEvent;
import org.wso2.carbon.registry.common.eventing.WorkListConfig;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.eventing.events.DispatchEvent;
import org.wso2.carbon.registry.eventing.internal.JMXEventsBean;
import org.wso2.carbon.registry.eventing.internal.Utils;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.utils.CarbonUtils;

public class RegistryEventDispatcher
extends WSEventDispatcher {
    private static final SimpleDateFormat EVENT_TIME = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private ConfigurationContext configContext = null;
    private Map<String, Queue<DigestEntry>> digestQueues = new LinkedHashMap<String, Queue<DigestEntry>>();
    private static final Log log = LogFactory.getLog(RegistryEventDispatcher.class);
    private static WorkListConfig workListConfig = new WorkListConfig();

    public RegistryEventDispatcher() {
        for (String s : new String[]{"h", "d", "w", "f", "m", "y"}) {
            this.digestQueues.put(s, new ConcurrentLinkedQueue());
        }
        final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                GregorianCalendar utc = new GregorianCalendar(SimpleTimeZone.getTimeZone("UTC"));
                HashMap digestEntries = new HashMap();
                try {
                    RegistryEventDispatcher.this.addToDigestEntryQueue(digestEntries, "h");
                    if (utc.get(11) == 0) {
                        RegistryEventDispatcher.this.addToDigestEntryQueue(digestEntries, "d");
                        if (utc.get(7) == 1) {
                            RegistryEventDispatcher.this.addToDigestEntryQueue(digestEntries, "w");
                            if (utc.get(3) % 2 != 0) {
                                RegistryEventDispatcher.this.addToDigestEntryQueue(digestEntries, "f");
                            }
                        }
                        if (utc.get(5) == 1) {
                            RegistryEventDispatcher.this.addToDigestEntryQueue(digestEntries, "m");
                            if (utc.get(6) == 1) {
                                RegistryEventDispatcher.this.addToDigestEntryQueue(digestEntries, "y");
                            }
                        }
                    }
                    for (Map.Entry e : digestEntries.entrySet()) {
                        List value = (List)e.getValue();
                        Collections.sort(value, new Comparator<DigestEntry>(){

                            @Override
                            public int compare(DigestEntry o1, DigestEntry o2) {
                                if (o1.getTime() > o2.getTime()) {
                                    return -1;
                                }
                                if (o1.getTime() < o2.getTime()) {
                                    return 1;
                                }
                                return 0;
                            }
                        });
                        StringBuffer buffer = new StringBuffer();
                        for (DigestEntry entry : value) {
                            buffer.append(entry.getMessage()).append("\n\n");
                        }
                        RegistryEvent re = new RegistryEvent((Object)buffer.toString());
                        re.setTopic("/DigestEvent");
                        DispatchEvent de = new DispatchEvent(re, (String)e.getKey(), true);
                        Subscription subscription = new Subscription();
                        subscription.setTopicName(re.getTopic());
                        RegistryEventDispatcher.this.publishEvent(de, subscription, (String)e.getKey(), true);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }, System.currentTimeMillis() % 3600000L, 3600000L, TimeUnit.MILLISECONDS);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    executorService.shutdownNow();
                }
            });
        }
        catch (IllegalStateException e) {
            executorService.shutdownNow();
            throw new IllegalStateException("Unable to create registry event dispatcher during shutdown process.");
        }
    }

    private void addToDigestEntryQueue(Map<String, List<DigestEntry>> digestEntries, String digestType) {
        Queue<DigestEntry> digestQueue = this.getDigestQueue(digestType);
        while (!digestQueue.isEmpty()) {
            List<Object> digestEntriesForEndpoint;
            DigestEntry entry = digestQueue.poll();
            String endpoint = entry.getEndpoint();
            if (!digestEntries.containsKey(endpoint)) {
                digestEntriesForEndpoint = new LinkedList();
                digestEntries.put(endpoint, digestEntriesForEndpoint);
            } else {
                digestEntriesForEndpoint = digestEntries.get(endpoint);
            }
            digestEntriesForEndpoint.add(entry);
        }
    }

    private Queue<DigestEntry> getDigestQueue(String digestType) {
        Queue<DigestEntry> entryQueue = this.digestQueues.get(digestType);
        if (entryQueue != null) {
            return entryQueue;
        }
        String msg = "Invalid Digest Type: " + digestType;
        log.error((Object)msg);
        throw new RuntimeException(msg);
    }

    public void notify(Message event, Subscription subscription) {
        block33: {
            String email;
            boolean doRest;
            if (subscription == null) {
                return;
            }
            String endpoint = subscription.getEventSinkURL();
            if (endpoint == null) {
                return;
            }
            if (subscription.getProperties() != null) {
                int tenantIdOfEventObj;
                int tenantId = subscription.getTenantId();
                if (event instanceof DispatchEvent && tenantId != (tenantIdOfEventObj = ((DispatchEvent)event).getTenantId())) {
                    log.warn((Object)"TenantId for subscription doesn't match with the logged-in tenant");
                    return;
                }
            }
            String topic = subscription.getTopicName();
            boolean bl = doRest = subscription.getProperties() != null && subscription.getProperties().get("doRest") != null && ((String)subscription.getProperties().get("doRest")).equals(Boolean.toString(Boolean.TRUE));
            if (endpoint.toLowerCase().startsWith("digest://")) {
                String digestType = endpoint.substring(9, 10);
                endpoint = endpoint.substring(11);
                OMElement payload = event.getMessage();
                if (payload != null && payload.getFirstElement() != null) {
                    String[] temp = subscription.getTopicName().split("/");
                    String eventName = "";
                    eventName = temp[0].equals("") ? temp[3] : temp[2];
                    String path = topic.substring("/registry/notifications".length() + eventName.length(), topic.lastIndexOf("/"));
                    String time = ((OMElement)payload.getFirstElement().getNextOMSibling()).getText();
                    String message = time + ": [" + eventName + "] at path " + path + ":\n    " + payload.getFirstElement().getText();
                    this.getDigestQueue(digestType).add(new DigestEntry(message, endpoint, System.currentTimeMillis()));
                    return;
                }
            }
            if (endpoint.toLowerCase().startsWith("mailto:")) {
                if (subscription.getProperties() != null && Boolean.toString(true).equals(subscription.getProperties().get("notVerfied"))) {
                    email = endpoint.toLowerCase().substring("mailto:".length());
                    log.warn((Object)("Unable to send notification. The e-mail address " + email + " has not been verified."));
                    return;
                }
                log.debug((Object)("Sending Notification to: " + endpoint));
                this.publishEvent(event, subscription, endpoint, true);
            } else if (endpoint.toLowerCase().startsWith("user://")) {
                email = null;
                try {
                    UserRegistry registry;
                    String username = endpoint.substring(7);
                    if (Utils.getRegistryService() != null && (registry = Utils.getRegistryService().getConfigSystemRegistry()) != null && registry.getUserRealm() != null && registry.getUserRealm().getUserStoreManager() != null) {
                        UserStoreManager reader = registry.getUserRealm().getUserStoreManager();
                        email = "mailto:" + reader.getUserClaimValue(username, "http://wso2.org/claims/emailaddress", "default");
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Failed Sending Notification to: " + endpoint));
                    return;
                }
                log.debug((Object)("Sending Notification to: " + email));
                this.publishEvent(event, subscription, email, true);
            } else if (endpoint.toLowerCase().startsWith("role://")) {
                LinkedList<String> emails = new LinkedList<String>();
                try {
                    UserRegistry registry;
                    String roleName = endpoint.substring(7);
                    if (Utils.getRegistryService() != null && (registry = Utils.getRegistryService().getConfigSystemRegistry()) != null && registry.getUserRealm() != null && registry.getUserRealm().getUserStoreManager() != null) {
                        UserStoreManager reader = registry.getUserRealm().getUserStoreManager();
                        for (String username : reader.getUserListOfRole(roleName)) {
                            String temp = reader.getUserClaimValue(username, "http://wso2.org/claims/emailaddress", "default");
                            if (temp == null || temp.length() <= 0) continue;
                            emails.add("mailto:" + temp);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Failed Sending Notification to: " + endpoint));
                    return;
                }
                for (String email2 : emails) {
                    log.debug((Object)("Sending Notification to: " + email2));
                    this.publishEvent(event, subscription, email2, true);
                }
            } else if (endpoint.toLowerCase().startsWith("jmx://")) {
                log.debug((Object)"Sending Notification to JMX endpoint");
                JMXEventsBean eventsBean = Utils.getEventsBean();
                if (eventsBean == null) {
                    log.warn((Object)"Unable to generate notification. The notification bean has not been registered.");
                } else {
                    OMElement firstElement;
                    String namespaceURI;
                    OMElement message = event.getMessage();
                    OMElement timestamp = message.getFirstChildWithName(new QName(namespaceURI = (firstElement = message.getFirstElement()).getNamespace().getNamespaceURI(), "Timestamp"));
                    if (timestamp != null) {
                        try {
                            eventsBean.addNotification(EVENT_TIME.parse(timestamp.getText()), firstElement.getText());
                        }
                        catch (ParseException ignore) {
                            eventsBean.addNotification(new Date(), firstElement.getText());
                        }
                    }
                }
            } else if (endpoint.toLowerCase().startsWith("work://")) {
                log.debug((Object)"Sending Notification to work-list");
                try {
                    if (workListConfig.getServerURL() != null && workListConfig.getUsername() != null && workListConfig.getPassword() != null) {
                        WorkListServiceStub stub = new WorkListServiceStub(this.configContext, workListConfig.getServerURL() + "WorkListService");
                        ServiceClient client = stub._getServiceClient();
                        CarbonUtils.setBasicAccessSecurityHeaders((String)workListConfig.getUsername(), (String)workListConfig.getPassword(), (ServiceClient)client);
                        client.getOptions().setManageSession(true);
                        stub.addTask(endpoint.substring(7), event.getMessage().getFirstElement().getText(), 5);
                        break block33;
                    }
                    log.warn((Object)"Unable to generate notification. The work list config has not been setup.");
                }
                catch (RemoteException e) {
                    log.error((Object)"Failed Sending Notification to work-list", (Throwable)e);
                }
            } else {
                log.debug((Object)("Sending Notification to: " + endpoint));
                this.publishEvent(event, subscription, endpoint, doRest);
            }
        }
    }

    public void init(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    private OMElement buildPayload(OMFactory factory, Message event, boolean isEmail, String eventType) {
        OMElement messageElement = event.getMessage();
        if (!isEmail) {
            return event.getMessage();
        }
        try {
            OMElement payload = factory.createOMElement(BaseConstants.DEFAULT_TEXT_WRAPPER, null);
            String poweredBy = "This message was automatically generated by WSO2 Carbon.";
            String signature = "\n--\n" + poweredBy;
            String registryURL = Utils.getDefaultEventingServiceURL();
            if (registryURL != null && registryURL.indexOf("/services/RegistryEventingService") > -1) {
                registryURL = registryURL.substring(0, registryURL.length() - "/services/RegistryEventingService".length()) + "/carbon";
            }
            if (registryURL != null) {
                signature = signature + " URL: " + registryURL;
            }
            OMElement firstElement = messageElement.getFirstElement();
            String namespaceURI = firstElement.getNamespace().getNamespaceURI();
            OMElement timestamp = messageElement.getFirstChildWithName(new QName(namespaceURI, "Timestamp"));
            String time = null;
            if (timestamp != null) {
                time = timestamp.getText();
            }
            OMElement details = messageElement.getFirstChildWithName(new QName(namespaceURI, "Details"));
            String username = null;
            if (details != null) {
                username = details.getFirstChildWithName(new QName(namespaceURI, "Session")).getFirstChildWithName(new QName(namespaceURI, "Username")).getText();
            }
            if (time != null && username != null) {
                signature = "This event was generated" + (eventType.equals("DigestEvent") ? "" : " by " + username) + " at " + time + "." + signature;
            }
            payload.setText(firstElement.getText() + signature);
            return payload;
        }
        catch (Exception e) {
            log.error((Object)("Unable to Build Payload for " + messageElement.getText()), (Throwable)e);
            return null;
        }
    }

    private OMElement buildTopic(OMFactory factory, String topic) {
        OMNamespace topicNs = factory.createOMNamespace("http://wso2.org/ns/2009/09/eventing/notify", "ns");
        OMElement topicEle = factory.createOMElement("topic", topicNs);
        topicEle.setText(topic);
        return topicEle;
    }

    public void publishEvent(Message message, Subscription subscription, String endpoint, boolean doRest) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        String topicName = subscription.getTopicName();
        OMElement topicEle = this.buildTopic(factory, topicName);
        boolean isEmail = false;
        if (endpoint == null) {
            endpoint = this.getEndpoint();
        } else {
            isEmail = doRest && endpoint.startsWith("mailto:");
        }
        String[] temp = subscription.getTopicName().split("/");
        String eventName = "";
        eventName = temp[0].equals("") ? temp[3] : temp[2];
        OMElement payload = this.buildPayload(factory, message, isEmail, eventName);
        if (endpoint != null) {
            try {
                if (doRest) {
                    MessageContext messageContext;
                    if (this.configContext == null && (messageContext = MessageContext.getCurrentMessageContext()) != null) {
                        this.configContext = messageContext.getConfigurationContext();
                    }
                    ServiceClient serviceClient = this.configContext != null ? new ServiceClient(this.configContext, null) : new ServiceClient();
                    Options options = new Options();
                    serviceClient.engageModule("addressing");
                    options.setTo(new EndpointReference(endpoint));
                    options.setProperty("enableREST", (Object)"true");
                    if (endpoint.toLowerCase().startsWith("mailto:")) {
                        HashMap<String, String> headerMap = new HashMap<String, String>();
                        String topicText = topicEle.getText();
                        if (topicText != null && topicText.lastIndexOf("/") > 0) {
                            String[] tTemp = topicText.split("/");
                            String event = "";
                            event = tTemp[0].equals("") ? tTemp[3] : tTemp[2];
                            String path = topicText.substring("/registry/notifications".length() + event.length() + 1, topicText.lastIndexOf("/"));
                            String mailHeader = message.getProperty("Subject");
                            if (mailHeader != null) {
                                headerMap.put("Subject", mailHeader);
                            } else if (path == null || path.length() == 0) {
                                headerMap.put("Subject", "[" + event + "]");
                            } else {
                                headerMap.put("Subject", "[" + event + "] at path: " + path);
                            }
                        }
                        options.setProperty("TRANSPORT_HEADERS", headerMap);
                        options.setProperty("transport.mail.Format", (Object)"Text");
                    }
                    options.setProperty("ClientApiNonBlocking", (Object)Boolean.TRUE);
                    options.setAction("http://ws.apache.org/ws/2007/05/eventing-extended/Publish");
                    serviceClient.setOptions(options);
                    serviceClient.fireAndForget(payload);
                } else {
                    super.sendNotification(topicEle, payload, endpoint);
                }
            }
            catch (AxisFault e) {
                log.error((Object)"Unable to send message", (Throwable)e);
            }
        }
    }

    public String getEndpoint() {
        return Utils.getDefaultEventingServiceURL();
    }

    public static final class DigestEntry
    implements Serializable {
        private static final long serialVersionUID = -1805410413253360172L;
        private String message;
        private String endpoint;
        private long time;

        public DigestEntry(String message, String endpoint, long time) {
            this.message = message;
            this.endpoint = endpoint;
            this.time = time;
        }

        public String getMessage() {
            return this.message;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public long getTime() {
            return this.time;
        }
    }
}

