/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.factory.DataSourceInformationFactory;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;

public class MiscellaneousHelper {
    private static final Log log = LogFactory.getLog(MiscellaneousHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(OMElement element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading properties from : " + element));
        }
        String xml = "<!DOCTYPE properties   [\n\n<!ELEMENT properties ( comment?, entry* ) >\n\n<!ATTLIST properties version CDATA #FIXED \"1.0\">\n\n<!ELEMENT comment (#PCDATA) >\n\n<!ELEMENT entry (#PCDATA) >\n\n<!ATTLIST entry key CDATA #REQUIRED>\n]>" + element.toString();
        Properties properties = new Properties();
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(xml.getBytes());
            properties.loadFromXML(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            MiscellaneousHelper.handleException("IOError loading properties from : " + element, e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ignored) {}
            }
        }
        return properties;
    }

    public static Properties loadProperties(InputStream inputStream) {
        return MiscellaneousHelper.loadProperties(MiscellaneousHelper.getOMElement(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMElement createOMElement(Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Properties : " + properties));
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            properties.storeToXML(baos, "");
            String propertyS = new String(baos.toByteArray());
            String correctedS = propertyS.substring(propertyS.indexOf("<properties>"), propertyS.length());
            String inLined = "<!DOCTYPE properties   [\n\n<!ELEMENT properties ( comment?, entry* ) >\n\n<!ATTLIST properties version CDATA #FIXED \"1.0\">\n\n<!ELEMENT comment (#PCDATA) >\n\n<!ELEMENT entry (#PCDATA) >\n\n<!ATTLIST entry key CDATA #REQUIRED>\n]>";
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(inLined + correctedS));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement oMElement = builder.getDocumentElement();
            return oMElement;
        }
        catch (XMLStreamException e) {
            MiscellaneousHelper.handleException("Error Creating a OMElement from properties : " + properties, e);
        }
        catch (IOException e) {
            MiscellaneousHelper.handleException("IOError Creating a OMElement from properties : " + properties, e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException ignored) {}
            }
        }
        return null;
    }

    public static DataSourceInformation validateAndCreateDataSourceInformation(String name, OMElement element) {
        MiscellaneousHelper.validateName(name);
        MiscellaneousHelper.validateElement(element);
        Properties properties = MiscellaneousHelper.loadProperties(element);
        if (properties == null) {
            MiscellaneousHelper.handleException("Invalid properties");
        }
        if (properties != null && properties.isEmpty()) {
            MiscellaneousHelper.handleException("Empty property");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Properties " + properties));
        }
        DataSourceInformation information = DataSourceInformationFactory.createDataSourceInformation((String)name, (Properties)properties);
        MiscellaneousHelper.validateDataSourceDescription(information);
        if (log.isDebugEnabled()) {
            log.debug((Object)("DataSource Description : " + information));
        }
        return information;
    }

    public static DataSourceInformation validateAndCreateDataSourceInformation(String name, InputStream inputStream) {
        return MiscellaneousHelper.validateAndCreateDataSourceInformation(name, MiscellaneousHelper.getOMElement(inputStream));
    }

    private static void handleException(String msg, Throwable e) {
        log.error((Object)msg, e);
        throw new IllegalArgumentException(msg, e);
    }

    public static void validateName(String name) {
        if (name == null || "".equals(name)) {
            MiscellaneousHelper.handleException("Name is null or empty");
        } else if (name.contains("/")) {
            MiscellaneousHelper.handleException("Name must not contain the character: /");
        }
    }

    public static void handleException(String msg) {
        log.error((Object)msg);
        throw new RuntimeException(msg);
    }

    public static void validateDataSourceDescription(DataSourceInformation description) {
        if (description == null) {
            MiscellaneousHelper.handleException("DataSource Description can not be found.");
        }
    }

    public static void validateElement(OMElement element) {
        if (element == null) {
            MiscellaneousHelper.handleException("DataSource Description OMElement can not be found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMElement getOMElement(InputStream input) {
        BufferedInputStream inputStream = new BufferedInputStream(input);
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement oMElement = builder.getDocumentElement();
            return oMElement;
        }
        catch (Exception ignored) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ignored) {}
        }
        return null;
    }

    public static byte[] toByte(OMElement element) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            element.serialize((OutputStream)baos);
            return baos.toByteArray();
        }
        catch (XMLStreamException e) {
            MiscellaneousHelper.handleException("Error when serializing OMNode " + element, e);
            return null;
        }
    }

    public static OMElement encryptPassword(String name, OMElement dsEle) throws CryptoException {
        String passwordProp = "synapse.datasources." + name + ".password";
        Properties props = MiscellaneousHelper.loadProperties(dsEle);
        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
        String password = props.getProperty(passwordProp);
        String encryptedPassword = cryptoUtil.encryptAndBase64Encode(password.getBytes());
        props.setProperty(passwordProp, encryptedPassword);
        return MiscellaneousHelper.createOMElement(props);
    }

    public static OMElement decryptPassword(String name, OMElement dsEle) throws CryptoException {
        String passwordProp = "synapse.datasources." + name + ".password";
        Properties props = MiscellaneousHelper.loadProperties(dsEle);
        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
        String encryptedPassword = props.getProperty(passwordProp);
        byte[] decryptedPassword = cryptoUtil.base64DecodeAndDecrypt(encryptedPassword);
        props.setProperty(passwordProp, new String(decryptedPassword));
        return MiscellaneousHelper.createOMElement(props);
    }
}

