/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.DataSourceInformationRepository;
import org.apache.synapse.commons.datasource.DataSourceInformationRepositoryListener;
import org.apache.synapse.commons.datasource.DataSourceRepositoryManager;
import org.apache.synapse.commons.datasource.factory.DataSourceFactory;
import org.apache.synapse.commons.datasource.factory.DataSourceInformationRepositoryFactory;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.datasource.DataSourceManagementException;
import org.wso2.carbon.datasource.MiscellaneousHelper;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class DataSourceInformationManager {
    private static final Log log = LogFactory.getLog(DataSourceInformationManager.class);
    private Registry registry;
    private DataSourceInformationRepository repository;
    private static final String ROOT_PATH = "/repository/components/org.wso2.carbon.datasource";
    private final List<String> inactiveDataSourceList = new ArrayList<String>();

    public void populateDataSourceInformation() {
        block12: {
            try {
                if (this.getRegistry().resourceExists(ROOT_PATH)) {
                    String[] datasources;
                    Resource resource = this.getRegistry().get(ROOT_PATH);
                    if (!(resource instanceof Collection)) {
                        return;
                    }
                    Collection collection = (Collection)resource;
                    int length = collection.getChildCount();
                    if (length <= 0) {
                        return;
                    }
                    for (String ds : datasources = collection.getChildren()) {
                        InputStream in;
                        Resource child;
                        if (ds == null || (child = this.getRegistry().get(ds)) == null || (in = child.getContentStream()) == null) continue;
                        String alias = this.getResourceName(ds.trim());
                        if (alias == null || "".equals(alias)) {
                            return;
                        }
                        OMElement dsEle = MiscellaneousHelper.getOMElement(in);
                        try {
                            dsEle = MiscellaneousHelper.decryptPassword(alias, dsEle);
                        }
                        catch (CryptoException e) {
                            DataSourceInformationManager.handleException("Error decrypting datasource password", e);
                        }
                        DataSourceInformation information = MiscellaneousHelper.validateAndCreateDataSourceInformation(alias, dsEle);
                        try {
                            if (this.getRepository() == null) {
                                this.repository = DataSourceInformationRepositoryFactory.createDataSourceInformationRepository((Properties)new Properties());
                            }
                            this.getRepository().addDataSourceInformation(information);
                        }
                        catch (SynapseCommonsException e) {
                            this.inactiveDataSourceList.add(alias);
                            log.error((Object)"Error while creating DataSource Information Repository ", (Throwable)e);
                        }
                        child.discard();
                    }
                    resource.discard();
                    break block12;
                }
                CollectionImpl collection = new CollectionImpl();
                collection.setPath(ROOT_PATH);
                this.getRegistry().put(ROOT_PATH, (Resource)collection);
            }
            catch (RegistryException e) {
                DataSourceInformationManager.handleException("Error during initializing DataSources based on persisted configuration", e);
            }
        }
    }

    public void shutDown() {
        DataSourceInformationRepositoryListener listener = this.getRepository().getRepositoryListener();
        if (listener instanceof DataSourceRepositoryManager) {
            ((DataSourceRepositoryManager)listener).clear();
        }
    }

    public void addDataSourceInformation(DataSourceInformation information) {
        this.getRepository().addDataSourceInformation(information);
    }

    public void persistDataSourceInformation(String name, OMElement element) {
        MiscellaneousHelper.validateName(name);
        MiscellaneousHelper.validateElement(element);
        try {
            element = MiscellaneousHelper.encryptPassword(name, element);
        }
        catch (CryptoException e) {
            DataSourceInformationManager.handleException("Error encrypting datasource password", e);
        }
        byte[] value = MiscellaneousHelper.toByte(element);
        if (value != null) {
            String dataSourcePath = "/repository/components/org.wso2.carbon.datasource/" + name.trim();
            try {
                Object resource = this.getRegistry().resourceExists(dataSourcePath) ? this.getRegistry().get(dataSourcePath) : new ResourceImpl();
                if (resource != null) {
                    resource.setContent((Object)value);
                    this.getRegistry().put(dataSourcePath, (Resource)resource);
                }
            }
            catch (RegistryException e) {
                DataSourceInformationManager.handleException("Error persisting DataSource Information", e);
            }
        }
    }

    public DataSourceInformation removeDataSourceInformation(String name) {
        if (this.getRepository().getDataSourceInformation(name) != null) {
            return this.getRepository().removeDataSourceInformation(name);
        }
        return null;
    }

    public void removeDataSourceInformationFromRegistry(String name) {
        String dataSourcePath = "/repository/components/org.wso2.carbon.datasource/" + name;
        try {
            if (this.getRegistry().resourceExists(dataSourcePath)) {
                this.getRegistry().delete(dataSourcePath);
            }
        }
        catch (RegistryException e) {
            DataSourceInformationManager.handleException("Error occurred when removing data source configuration from registry ", e);
        }
    }

    public void configure(Properties properties) {
        this.getRepository().configure(properties);
    }

    public Iterator<DataSourceInformation> getAllDataSourceInformation() throws DataSourceManagementException {
        return this.getRepository().getAllDataSourceInformation();
    }

    public DataSourceInformation getDataSourceInformation(String name) {
        return this.getRepository().getDataSourceInformation(name);
    }

    public boolean isContains(String name) {
        return this.getRepository().getDataSourceInformation(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConnection(DataSourceInformation information) {
        block28: {
            DataSource dataSource;
            if (information == null) {
                DataSourceInformationManager.handleException("DataSourceInformation cannot be found.");
            }
            if ((dataSource = DataSourceFactory.createDataSource((DataSourceInformation)information)) == null) {
                DataSourceInformationManager.handleException("DataSource cannot be created or found for DataSource Information " + information);
            }
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                if (connection == null) break block28;
                String validationQuery = information.getValidationQuery();
                if (validationQuery != null && !"".equals(validationQuery)) {
                    PreparedStatement ps = null;
                    try {
                        ps = connection.prepareStatement(validationQuery.trim());
                        if (ps != null) {
                            ps.execute();
                            ps.close();
                        }
                    }
                    catch (SQLException e) {
                        DataSourceInformationManager.handleException("Error during executing validation query : " + e.getMessage(), e);
                    }
                    finally {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (SQLException ignored) {}
                        }
                    }
                }
                connection.close();
            }
            catch (SQLException e) {
                DataSourceInformationManager.handleException("Error during executing validation query : " + e.getMessage(), e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException ignored) {}
                }
            }
        }
        return true;
    }

    private String getResourceName(String path) {
        if (path != null) {
            String correctedPath = path;
            if (path.endsWith("/")) {
                correctedPath = path.substring(0, path.lastIndexOf("/"));
            }
            if (correctedPath.indexOf("/") < 0) {
                return correctedPath;
            }
            return correctedPath.substring(correctedPath.lastIndexOf("/") + 1, correctedPath.length());
        }
        return "";
    }

    private static void handleException(String msg, Throwable throwable) {
        log.error((Object)msg, throwable);
        throw new RuntimeException(msg, throwable);
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new RuntimeException(msg);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public DataSourceInformationRepository getRepository() {
        return this.repository;
    }

    public void setRepository(DataSourceInformationRepository repository) {
        this.repository = repository;
    }

    public List<String> getInactiveDataSourceList() {
        return this.inactiveDataSourceList;
    }

    public void setInactiveDataSourceList(List<String> inactiveDataSourceList) {
        this.inactiveDataSourceList.addAll(inactiveDataSourceList);
    }
}

