/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.factory.DataSourceInformationFactory;
import org.apache.synapse.commons.datasource.serializer.DataSourceInformationSerializer;
import org.wso2.carbon.datasource.ui.stub.DataSourceAdminStub;
import org.wso2.carbon.datasource.ui.stub.DataSourceManagementException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class DatasourceManagementClient {
    private static final Log log = LogFactory.getLog(DatasourceManagementClient.class);
    private static final String DATASOURCE_EXTENSION_NS = "http://www.wso2.org/products/wso2commons/datasource";
    private static final QName ROOT_QNAME = new QName("http://www.wso2.org/products/wso2commons/datasource", "datasourceExtension", "datasource");
    private DataSourceAdminStub stub;

    private DatasourceManagementClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "DataSourceAdmin";
        this.stub = new DataSourceAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public static DatasourceManagementClient getInstance(ServletConfig config, HttpSession session) throws AxisFault, DataSourceManagementException {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        return new DatasourceManagementClient(cookie, backendServerURL, configContext);
    }

    public void addDataSourceInformation(DataSourceInformation dataSourceInformation) throws DataSourceManagementException, RemoteException {
        Properties properties;
        DatasourceManagementClient.validateDataSourceInformation(dataSourceInformation);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to add DatasourceInformation :" + dataSourceInformation));
        }
        if ((properties = DataSourceInformationSerializer.serialize((DataSourceInformation)dataSourceInformation)).isEmpty()) {
            DatasourceManagementClient.handleException("Empty Properties");
        }
        OMElement element = DatasourceManagementClient.createOMElement(properties);
        DatasourceManagementClient.validateDataSourceElement(element);
        if (log.isDebugEnabled()) {
            log.debug((Object)("DataSourceconfiguration :" + element));
        }
        this.stub.addDataSourceInformation(dataSourceInformation.getAlias(), element);
    }

    public void deleteDatasourceInformation(String name) throws DataSourceManagementException, RemoteException {
        DatasourceManagementClient.validateName(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to delete a DatasourceInformation with name : " + name));
        }
        this.stub.removeDataSourceInformation(name);
    }

    public void editDatasourceInformation(DataSourceInformation information) throws DataSourceManagementException, RemoteException {
        Properties properties;
        DatasourceManagementClient.validateDataSourceInformation(information);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to Edit DataSourceInformation :" + information));
        }
        if ((properties = DataSourceInformationSerializer.serialize((DataSourceInformation)information)).isEmpty()) {
            DatasourceManagementClient.handleException("Empty Properties");
        }
        OMElement datasourceElement = DatasourceManagementClient.createOMElement(properties);
        DatasourceManagementClient.validateDataSourceElement(datasourceElement);
        if (log.isDebugEnabled()) {
            log.debug((Object)("DataSourceconfiguration :" + datasourceElement));
        }
        this.stub.editDataSourceInformation(information.getAlias(), datasourceElement);
    }

    public Map<String, String> getAllDataSourceInformations() throws DataSourceManagementException, RemoteException {
        OMElement element = this.stub.getAllDataSourceInformation();
        HashSet<String> getInactiveDataSourceList = null;
        if (this.stub.getInactiveDataSourceList() != null) {
            getInactiveDataSourceList = new HashSet<String>(Arrays.asList(this.stub.getInactiveDataSourceList()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("All datasources configurations :" + element));
        }
        HashMap<String, String> allDataSourceMap = new HashMap<String, String>();
        if (element == null) {
            return allDataSourceMap;
        }
        OMElement datasourceRoot = element.getFirstChildWithName(ROOT_QNAME);
        if (datasourceRoot == null) {
            return allDataSourceMap;
        }
        Iterator iterator = datasourceRoot.getChildElements();
        while (iterator.hasNext()) {
            String name;
            OMElement datasourceElement = (OMElement)iterator.next();
            if (datasourceElement == null || (name = datasourceElement.getAttributeValue(new QName("", "name", ""))) == null || "".equals(name)) continue;
            if (getInactiveDataSourceList != null && getInactiveDataSourceList.contains(name)) {
                allDataSourceMap.put(name, "Error");
                continue;
            }
            allDataSourceMap.put(name, "Active");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("All datasources Descriptions :" + allDataSourceMap));
        }
        return allDataSourceMap;
    }

    public DataSourceInformation getDataSourceInformation(String name) throws DataSourceManagementException, RemoteException {
        DatasourceManagementClient.validateName(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to retrieve a DataSourceDescription for give name :" + name));
        }
        OMElement returnElement = this.stub.getDataSourceInformation(name);
        DatasourceManagementClient.validateDataSourceElement(returnElement);
        OMElement element = returnElement.getFirstElement();
        return DatasourceManagementClient.validateAndCreate(name, element);
    }

    public boolean isContains(String name) throws DataSourceManagementException, RemoteException {
        DatasourceManagementClient.validateName(name);
        return this.stub.isContains(name);
    }

    public boolean testConnection(DataSourceInformation dataSourceInformation) throws DataSourceManagementException, RemoteException {
        Properties properties;
        DatasourceManagementClient.validateDataSourceInformation(dataSourceInformation);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to add DatasourceInformation :" + dataSourceInformation));
        }
        if ((properties = DataSourceInformationSerializer.serialize((DataSourceInformation)dataSourceInformation)).isEmpty()) {
            DatasourceManagementClient.handleException("Empty Properties");
        }
        OMElement element = DatasourceManagementClient.createOMElement(properties);
        DatasourceManagementClient.validateDataSourceElement(element);
        if (log.isDebugEnabled()) {
            log.debug((Object)("DataSourceconfiguration :" + element));
        }
        return this.stub.testConnection(dataSourceInformation.getAlias(), element);
    }

    private static void validateDataSourceInformation(DataSourceInformation description) {
        if (description == null) {
            DatasourceManagementClient.handleException("DataSourceDescription can not be found.");
        }
    }

    private static void validateDataSourceElement(OMElement datasourceElement) {
        if (datasourceElement == null) {
            DatasourceManagementClient.handleException("DataSourceDescription OMElement can not be found.");
        }
    }

    private static void validateName(String name) {
        if (name == null || "".equals(name)) {
            DatasourceManagementClient.handleException("Name is null or empty");
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new IllegalArgumentException(msg);
    }

    private static void handleException(String msg, Throwable e) {
        log.error((Object)msg, e);
        throw new IllegalArgumentException(msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(OMElement element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading properties from : " + element));
        }
        String xml = "<!DOCTYPE properties   [\n\n<!ELEMENT properties ( comment?, entry* ) >\n\n<!ATTLIST properties version CDATA #FIXED \"1.0\">\n\n<!ELEMENT comment (#PCDATA) >\n\n<!ELEMENT entry (#PCDATA) >\n\n<!ATTLIST entry key CDATA #REQUIRED>\n]>" + element.toString();
        Properties properties = new Properties();
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(xml.getBytes());
            properties.loadFromXML(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            DatasourceManagementClient.handleException("IOError loading properties from : " + element);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException inored) {}
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OMElement createOMElement(Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Properties : " + properties));
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            properties.storeToXML(baos, "");
            String propertyS = new String(baos.toByteArray());
            String correctedS = propertyS.substring(propertyS.indexOf("<properties>"), propertyS.length());
            String inLined = "<!DOCTYPE properties   [\n\n<!ELEMENT properties ( comment?, entry* ) >\n\n<!ATTLIST properties version CDATA #FIXED \"1.0\">\n\n<!ELEMENT comment (#PCDATA) >\n\n<!ELEMENT entry (#PCDATA) >\n\n<!ATTLIST entry key CDATA #REQUIRED>\n]>";
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(inLined + correctedS));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement oMElement = builder.getDocumentElement();
            return oMElement;
        }
        catch (XMLStreamException e) {
            DatasourceManagementClient.handleException("Error Creating a OMElement from properties : " + properties, e);
        }
        catch (IOException e) {
            DatasourceManagementClient.handleException("IOError Creating a OMElement from properties : " + properties, e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException ignored) {}
            }
        }
        return null;
    }

    private static DataSourceInformation validateAndCreate(String name, OMElement element) throws AxisFault {
        DatasourceManagementClient.validateName(name);
        DatasourceManagementClient.validateDataSourceElement(element);
        Properties properties = DatasourceManagementClient.loadProperties(element);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Properties " + properties));
        }
        if (properties.isEmpty()) {
            DatasourceManagementClient.handleException("Empty property");
        }
        DataSourceInformation information = DataSourceInformationFactory.createDataSourceInformation((String)name, (Properties)properties);
        DatasourceManagementClient.validateDataSourceInformation(information);
        if (log.isDebugEnabled()) {
            log.debug((Object)("DataSource Description : " + information));
        }
        return information;
    }

    public List<String> getInactiveDataSourceList() throws RemoteException {
        ArrayList<String> getInactiveDataSourceList = new ArrayList<String>();
        if (this.stub.getInactiveDataSourceList() != null) {
            getInactiveDataSourceList = new ArrayList<String>(Arrays.asList(this.stub.getInactiveDataSourceList()));
        }
        return getInactiveDataSourceList;
    }
}

