/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.ui;

import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.wso2.securevault.secret.SecretInformation;

public class DataSourceManagementHelper {
    private static final Log log = LogFactory.getLog(DataSourceManagementHelper.class);

    public static DataSourceInformation createDataSourceInformation(HttpServletRequest request) throws ServletException {
        String validationquery;
        String testwhileidle;
        String testonborrow;
        String poolstatements;
        String initialsize;
        String minIdle;
        String maxWait;
        String maxopenstatements;
        String maxIdle;
        String maxActive;
        String isolation;
        String autocommit;
        String dsrepotype;
        String dstype;
        String password;
        String url;
        String diver;
        ResourceBundle bundle = ResourceBundle.getBundle("org.wso2.carbon.datasource.ui.i18n.Resources", request.getLocale());
        String alias = request.getParameter("alias");
        if ((alias == null || "".equals(alias)) && ((alias = request.getParameter("alias_hidden")) == null || "".equals(alias))) {
            DataSourceManagementHelper.handleException(bundle.getString("ds.name.cannotfound.msg"));
        }
        if ((diver = request.getParameter("driver")) == null || "".equals(diver)) {
            DataSourceManagementHelper.handleException(bundle.getString("ds.driver.cannotfound.msg"));
        }
        if ((url = request.getParameter("url")) == null || "".equals(url)) {
            DataSourceManagementHelper.handleException(bundle.getString("ds.url.cannotfound.msg"));
        }
        DataSourceInformation dataSourceInformation = new DataSourceInformation();
        dataSourceInformation.setAlias(alias.trim());
        dataSourceInformation.setDatasourceName(alias.trim());
        dataSourceInformation.setDriver(diver.trim());
        dataSourceInformation.setUrl(url.trim());
        String user = request.getParameter("user");
        if (user != null && !"".equals(user)) {
            SecretInformation secretInfo = dataSourceInformation.getSecretInformation() == null ? new SecretInformation() : dataSourceInformation.getSecretInformation();
            secretInfo.setUser(user.trim());
            dataSourceInformation.setSecretInformation(secretInfo);
        }
        if ((password = request.getParameter("password")) != null && !"".equals(password)) {
            SecretInformation secretInfo = dataSourceInformation.getSecretInformation() == null ? new SecretInformation() : dataSourceInformation.getSecretInformation();
            secretInfo.setAliasSecret(password.trim());
            dataSourceInformation.setSecretInformation(secretInfo);
        }
        if ("peruserds".equals(dstype = request.getParameter("dstype"))) {
            dataSourceInformation.setType("PerUserPoolDataSource");
        }
        if ("JNDI".equals(dsrepotype = request.getParameter("dsrepotype"))) {
            dataSourceInformation.setRepositoryType("JNDI");
            StringBuffer buffer = new StringBuffer();
            buffer.append("synapse.datasources");
            buffer.append(".");
            buffer.append(alias.trim());
            buffer.append(".");
            String rootPrefix = buffer.toString();
            Properties jndiEvn = new Properties();
            String icFactory = request.getParameter("icFactory");
            String providerUrl = request.getParameter("providerUrl");
            String providerPort = request.getParameter("providerPort");
            String providerType = request.getParameter("providerType");
            if (icFactory != null && !"".equals(icFactory)) {
                jndiEvn.setProperty(rootPrefix + "icFactory", icFactory.trim());
            }
            if ("url".equals(providerType)) {
                if (providerUrl != null && !"".equals(providerUrl)) {
                    jndiEvn.setProperty(rootPrefix + "providerUrl", providerUrl.trim());
                }
            } else if (providerPort != null && !"".equals(providerPort)) {
                jndiEvn.setProperty(rootPrefix + "providerPort", providerPort.trim());
            }
            dataSourceInformation.setProperties(jndiEvn);
        }
        if ((autocommit = request.getParameter("autocommit")) != null && !"".equals(autocommit)) {
            dataSourceInformation.setDefaultAutoCommit(Boolean.parseBoolean(autocommit.trim()));
        }
        if ((isolation = request.getParameter("isolation")) != null && !"".equals(isolation)) {
            if ("TRANSACTION_NONE".equals(isolation)) {
                dataSourceInformation.setDefaultTransactionIsolation(0);
            } else if ("TRANSACTION_READ_COMMITTED".equals(isolation.trim())) {
                dataSourceInformation.setDefaultTransactionIsolation(2);
            } else if ("TRANSACTION_READ_UNCOMMITTED".equals(isolation.trim())) {
                dataSourceInformation.setDefaultTransactionIsolation(1);
            } else if ("TRANSACTION_REPEATABLE_READ".equals(isolation.trim())) {
                dataSourceInformation.setDefaultTransactionIsolation(4);
            } else if ("TRANSACTION_SERIALIZABLE".equals(isolation.trim())) {
                dataSourceInformation.setDefaultTransactionIsolation(8);
            }
        }
        if ((maxActive = request.getParameter("maxActive")) != null && !"".equals(maxActive) && !maxActive.contains("int")) {
            try {
                dataSourceInformation.setMaxActive(Integer.parseInt(maxActive.trim()));
            }
            catch (NumberFormatException e) {
                DataSourceManagementHelper.handleException(bundle.getString("invalid.maxActive"));
            }
        }
        if ((maxIdle = request.getParameter("maxIdle")) != null && !"".equals(maxIdle) && !maxIdle.contains("int")) {
            try {
                dataSourceInformation.setMaxIdle(Integer.parseInt(maxIdle.trim()));
            }
            catch (NumberFormatException e) {
                DataSourceManagementHelper.handleException(bundle.getString("invalid.maxidle"));
            }
        }
        if ((maxopenstatements = request.getParameter("maxopenstatements")) != null && !"".equals(maxopenstatements) && !maxopenstatements.contains("int")) {
            try {
                dataSourceInformation.setMaxOpenPreparedStatements(Integer.parseInt(maxopenstatements.trim()));
            }
            catch (NumberFormatException e) {
                DataSourceManagementHelper.handleException(bundle.getString("invalid.MaxOpenStatements"));
            }
        }
        if ((maxWait = request.getParameter("maxWait")) != null && !"".equals(maxWait) && !maxWait.contains("long")) {
            try {
                dataSourceInformation.setMaxWait(Long.parseLong(maxWait.trim()));
            }
            catch (NumberFormatException e) {
                DataSourceManagementHelper.handleException(bundle.getString("invalid.MaxWait"));
            }
        }
        if ((minIdle = request.getParameter("minIdle")) != null && !"".equals(minIdle) && !minIdle.contains("int")) {
            try {
                dataSourceInformation.setMinIdle(Integer.parseInt(minIdle.trim()));
            }
            catch (NumberFormatException e) {
                DataSourceManagementHelper.handleException(bundle.getString("invalid.MinIdle"));
            }
        }
        if ((initialsize = request.getParameter("initialsize")) != null && !"".equals(initialsize) && !initialsize.contains("int")) {
            try {
                dataSourceInformation.setInitialSize(Integer.parseInt(initialsize.trim()));
            }
            catch (NumberFormatException e) {
                DataSourceManagementHelper.handleException(bundle.getString("invalid.Initialsize"));
            }
        }
        if ((poolstatements = request.getParameter("poolstatements")) != null && !"".equals(poolstatements)) {
            dataSourceInformation.setPoolPreparedStatements(Boolean.parseBoolean(poolstatements.trim()));
        }
        if ((testonborrow = request.getParameter("testonborrow")) != null && !"".equals(testonborrow)) {
            dataSourceInformation.setTestOnBorrow(Boolean.parseBoolean(testonborrow.trim()));
        }
        if ((testwhileidle = request.getParameter("testwhileidle")) != null && !"".equals(testwhileidle)) {
            dataSourceInformation.setTestWhileIdle(Boolean.parseBoolean(testwhileidle.trim()));
        }
        if ((validationquery = request.getParameter("validationquery")) != null && !"".equals(validationquery)) {
            dataSourceInformation.setValidationQuery(validationquery.trim());
        }
        return dataSourceInformation;
    }

    public static String toStringIsolation(int isolation) {
        switch (isolation) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        return "TRANSACTION_UNKNOWN";
    }

    public static String getProperty(Properties properties, String name, String defaultValue) {
        if (properties != null) {
            String value = properties.getProperty(name, defaultValue);
            if (value == null) {
                return "";
            }
            return value.trim();
        }
        return defaultValue;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new IllegalArgumentException(msg);
    }
}

