/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.jmx;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.jmx.JmxInformation;
import org.apache.synapse.commons.util.MiscellaneousUtil;
import org.wso2.securevault.secret.SecretInformation;
import org.wso2.securevault.secret.SecretInformationFactory;

public class JmxInformationFactory {
    private static final Log log = LogFactory.getLog(JmxInformationFactory.class);

    private JmxInformationFactory() {
    }

    public static JmxInformation createJmxInformation(Properties properties, String defaultHostName) {
        String prefix = "synapse.jmx.";
        JmxInformation jmxInformation = new JmxInformation();
        SecretInformation secretInformation = SecretInformationFactory.createSecretInformation((Properties)properties, (String)prefix, null);
        secretInformation.setToken("jmx.password");
        jmxInformation.setSecretInformation(secretInformation);
        int jndiPort = MiscellaneousUtil.getProperty(properties, prefix + "jndiPort", -1, Integer.class);
        jmxInformation.setJndiPort(jndiPort);
        int rmiPort = MiscellaneousUtil.getProperty(properties, prefix + "rmiPort", 0, Integer.class);
        jmxInformation.setRmiPort(rmiPort);
        String jmxHostName = MiscellaneousUtil.getProperty(properties, prefix + "hostname", null);
        if (jmxHostName == null || jmxHostName.trim().length() == 0) {
            jmxHostName = defaultHostName;
        }
        jmxInformation.setHostName(jmxHostName);
        Properties managementProperties = JmxInformationFactory.readManagementProperties();
        String value = JmxInformationFactory.getConfigProperty(managementProperties, "com.sun.management.jmxremote.authenticate");
        Boolean authenticate = value != null ? Boolean.valueOf(value) : (secretInformation.getUser() == null ? Boolean.FALSE : Boolean.TRUE);
        jmxInformation.setAuthenticate(authenticate);
        value = JmxInformationFactory.getConfigProperty(managementProperties, "com.sun.management.jmxremote.access.file");
        if (value == null || value.trim().length() == 0) {
            value = MiscellaneousUtil.getProperty(properties, prefix + "remote.access.file", null);
        }
        if (value != null && value.trim().length() > 0) {
            jmxInformation.setRemoteAccessFile(value);
        }
        if ((value = JmxInformationFactory.getConfigProperty(managementProperties, "com.sun.management.jmxremote.password.file")) != null && value.trim().length() > 0) {
            jmxInformation.setRemotePasswordFile(value);
        }
        Boolean remoteSSL = (value = JmxInformationFactory.getConfigProperty(managementProperties, "com.sun.management.jmxremote.ssl")) != null ? Boolean.valueOf(value) : MiscellaneousUtil.getProperty(properties, prefix + "remote.ssl", Boolean.FALSE, Boolean.class);
        jmxInformation.setRemoteSSL(remoteSSL);
        return jmxInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readManagementProperties() {
        Properties managementProperties = new Properties();
        String configFileName = System.getProperty("com.sun.management.config.file");
        if (configFileName != null) {
            FileInputStream configFile = null;
            try {
                configFile = new FileInputStream(configFileName);
                managementProperties.load(configFile);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized management properties from file " + configFileName));
                }
            }
            catch (FileNotFoundException ex) {
                log.error((Object)("Cannot open " + configFileName), (Throwable)ex);
            }
            catch (IOException ex) {
                log.error((Object)("Error while reading " + configFileName), (Throwable)ex);
            }
            finally {
                if (configFile != null) {
                    try {
                        configFile.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return managementProperties;
    }

    private static String getConfigProperty(Properties managementProperties, String name) {
        String result = System.getProperty(name);
        if (result == null && managementProperties != null) {
            result = managementProperties.getProperty(name);
        }
        return result;
    }
}

