/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.beanstalk.enterprise;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.beanstalk.enterprise.EnterpriseBeanstalk;
import org.apache.synapse.commons.util.MiscellaneousUtil;

public class EnterpriseBeanstalkManager {
    private static final Log log = LogFactory.getLog(EnterpriseBeanstalkManager.class);
    private Map<String, EnterpriseBeanstalk> beanstalkMap = new ConcurrentHashMap<String, EnterpriseBeanstalk>();
    private ScheduledExecutorService scheduler;

    public void init(Properties props) {
        if (props == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Beanstalk properties cannot be found.");
            }
            return;
        }
        String beanstalkNameList = MiscellaneousUtil.getProperty(props, "synapse.beanstalks", null);
        if (beanstalkNameList == null || "".equals(beanstalkNameList)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No beanstalks defined for initialization.");
            }
            return;
        }
        String[] beanstalkNames = beanstalkNameList.split(",");
        if (beanstalkNames == null || beanstalkNames.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No beanstalk definitions found for initialization.");
            }
            return;
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "enterprise-beanstalk-cleaner");
            }
        });
        for (String beanstalkName : beanstalkNames) {
            if (beanstalkName == null || beanstalkName.trim().length() == 0) continue;
            String propertyPrefix = "synapse.beanstalks." + beanstalkName + ".";
            Properties currentBeanstalkProps = new Properties();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key;
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !(key = (String)entry.getKey()).startsWith(propertyPrefix)) continue;
                currentBeanstalkProps.setProperty(key.replace(propertyPrefix, ""), (String)entry.getValue());
            }
            EnterpriseBeanstalk beanstalk = new EnterpriseBeanstalk(beanstalkName, currentBeanstalkProps, this.scheduler);
            beanstalk.init();
            this.beanstalkMap.put(beanstalkName, beanstalk);
        }
    }

    public EnterpriseBeanstalk getBeanstalk(String name) {
        return this.beanstalkMap.get(name);
    }

    public void destroy() {
        Iterator<EnterpriseBeanstalk> it = this.beanstalkMap.values().iterator();
        while (it.hasNext()) {
            it.next().destroy();
            it.remove();
        }
        if (!this.scheduler.isShutdown()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Shutting down beanstalk cleaner executor...");
            }
            this.scheduler.shutdownNow();
        }
    }
}

