/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.services;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.serializer.DataSourceInformationSerializer;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.datasource.DataSourceInformationManager;
import org.wso2.carbon.datasource.DataSourceManagementException;
import org.wso2.carbon.datasource.DataSourceManagementHandler;
import org.wso2.carbon.datasource.MiscellaneousHelper;

public class DataSourceAdminService
extends AbstractAdmin {
    private DataSourceInformationManager dataSourceInformationManager = DataSourceManagementHandler.getInstance().getTenantDataSourceInformationManager();
    private static final Log log = LogFactory.getLog(DataSourceAdminService.class);
    private static final String DATASOURCE_EXTENSION_NS = "http://www.wso2.org/products/wso2commons/datasource";
    private static final OMFactory FACTORY = OMAbstractFactory.getOMFactory();

    public void addDataSourceInformation(String name, OMElement element) throws DataSourceManagementException {
        DataSourceInformation information = MiscellaneousHelper.validateAndCreateDataSourceInformation(name, element);
        if (this.isContains(information.getAlias())) {
            throw new DataSourceManagementException("A data source with name " + information.getAlias() + " is already there.");
        }
        try {
            this.dataSourceInformationManager.addDataSourceInformation(information);
            this.dataSourceInformationManager.persistDataSourceInformation(name.trim(), element);
        }
        catch (Exception e) {
            try {
                this.dataSourceInformationManager.removeDataSourceInformation(name.trim());
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw new DataSourceManagementException("Error adding a data source : " + e.getMessage(), e);
        }
    }

    public boolean testConnection(String name, OMElement element) throws DataSourceManagementException {
        try {
            return this.dataSourceInformationManager.testConnection(MiscellaneousHelper.validateAndCreateDataSourceInformation(name, element));
        }
        catch (Exception e) {
            throw new DataSourceManagementException("Error testing connection : " + e.getMessage(), e);
        }
    }

    public void removeDataSourceInformation(String name) throws DataSourceManagementException {
        MiscellaneousHelper.validateName(name);
        try {
            this.dataSourceInformationManager.removeDataSourceInformation(name);
            this.dataSourceInformationManager.removeDataSourceInformationFromRegistry(name.trim());
        }
        catch (Exception e) {
            throw new DataSourceManagementException("Error deleting a data source : " + e.getMessage(), e);
        }
    }

    public OMElement getDataSourceInformation(String name) throws DataSourceManagementException {
        MiscellaneousHelper.validateName(name);
        try {
            DataSourceInformation information = this.dataSourceInformationManager.getDataSourceInformation(name);
            MiscellaneousHelper.validateDataSourceDescription(information);
            Properties properties = DataSourceInformationSerializer.serialize((DataSourceInformation)information);
            if (properties.isEmpty()) {
                DataSourceAdminService.handleException("Empty Properties");
            }
            OMElement element = MiscellaneousHelper.createOMElement(properties);
            MiscellaneousHelper.validateElement(element);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning a datasource : " + element));
            }
            return element;
        }
        catch (Exception e) {
            throw new DataSourceManagementException("Error loading a data source : " + e.getMessage(), e);
        }
    }

    public void setConfigurationProperties(String name, OMElement element) throws DataSourceManagementException {
        MiscellaneousHelper.validateName(name);
        MiscellaneousHelper.validateElement(element);
        try {
            this.dataSourceInformationManager.configure(MiscellaneousHelper.loadProperties(element));
        }
        catch (Exception e) {
            throw new DataSourceManagementException("Error configuring a data source repository : " + e.getMessage(), e);
        }
    }

    public OMElement getAllDataSourceInformation() throws DataSourceManagementException {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement root = factory.createOMElement(new QName(DATASOURCE_EXTENSION_NS, "datasourceExtension", "datasource"));
        OMNamespace nullNS = FACTORY.createOMNamespace("", "");
        try {
            Iterator<DataSourceInformation> iterator = this.dataSourceInformationManager.getAllDataSourceInformation();
            while (iterator.hasNext()) {
                DataSourceInformation information = iterator.next();
                if (information == null) continue;
                OMElement element = factory.createOMElement(new QName(DATASOURCE_EXTENSION_NS, "datasource", "datasource"));
                element.addAttribute(factory.createOMAttribute("name", nullNS, information.getAlias()));
                root.addChild((OMNode)element);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new DataSourceManagementException("Error loading all data sources : " + e.getMessage(), e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("All DataSources : " + root));
        }
        return root;
    }

    public void editDataSourceInformation(String name, OMElement element) throws DataSourceManagementException {
        MiscellaneousHelper.validateName(name);
        DataSourceInformation editingDSI = this.dataSourceInformationManager.getDataSourceInformation(name);
        try {
            this.dataSourceInformationManager.removeDataSourceInformation(name);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.addDataSourceInformation(name, element);
            List<String> inactiveDataSourceList = this.getInactiveDataSourceList();
            if (inactiveDataSourceList != null && inactiveDataSourceList.contains(name)) {
                inactiveDataSourceList.remove(name);
                this.dataSourceInformationManager.setInactiveDataSourceList(inactiveDataSourceList);
            }
        }
        catch (Exception e) {
            this.dataSourceInformationManager.addDataSourceInformation(editingDSI);
            String message = "Error editing a data source. restoring the existing one.";
            log.error((Object)message, (Throwable)e);
            throw new DataSourceManagementException(message, e);
        }
    }

    public boolean isContains(String name) throws DataSourceManagementException {
        MiscellaneousHelper.validateName(name);
        try {
            return this.dataSourceInformationManager.isContains(name);
        }
        catch (Exception e) {
            throw new DataSourceManagementException("Error looking up a data source : " + e.getMessage(), e);
        }
    }

    private static void handleException(String msg) throws DataSourceManagementException {
        log.error((Object)msg);
        throw new DataSourceManagementException(msg);
    }

    public List<String> getInactiveDataSourceList() {
        return this.dataSourceInformationManager.getInactiveDataSourceList();
    }
}

