/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.multitenancy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.datasource.DataSourceInformationRepository;
import org.apache.synapse.commons.datasource.DataSourceInformationRepositoryListener;
import org.apache.synapse.commons.datasource.DataSourceRepositoryManager;
import org.apache.synapse.commons.datasource.InMemoryDataSourceRepository;
import org.apache.synapse.commons.datasource.JNDIBasedDataSourceRepository;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.datasource.DataSourceInformationManager;
import org.wso2.carbon.datasource.DataSourceManagementHandler;
import org.wso2.carbon.datasource.internal.DataSourceServiceComponent;
import org.wso2.carbon.datasource.multitenancy.DataSourceRepositoryListener;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class DataSourceInitializer
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(DataSourceInitializer.class);
    private static DataSourceManagementHandler handler = DataSourceManagementHandler.getInstance();
    private static Map<Integer, List<DataSourceRepositoryListener>> dsrListenerMap = new HashMap<Integer, List<DataSourceRepositoryListener>>();

    public void createdConfigurationContext(ConfigurationContext configurationContext) {
        int tenantId = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId();
        SuperTenantCarbonContext.startTenantFlow();
        SuperTenantCarbonContext.getCurrentContext().setTenantId(tenantId);
        DataSourceInformationRepository repository = new DataSourceInformationRepository();
        DataSourceRepositoryManager listener = new DataSourceRepositoryManager(new InMemoryDataSourceRepository(), new JNDIBasedDataSourceRepository());
        repository.setRepositoryListener((DataSourceInformationRepositoryListener)listener);
        try {
            DataSourceInformationManager dsManager = this.getDataSourceManagementHandler().getTenantDataSourceInformationManager();
            if (dsManager == null) {
                dsManager = new DataSourceInformationManager();
                dsManager.setRepository(repository);
                dsManager.setRepository(repository);
                dsManager.setRegistry((Registry)DataSourceServiceComponent.getRegistryService().getConfigSystemRegistry(tenantId));
                dsManager.populateDataSourceInformation();
                this.getDataSourceManagementHandler().addDataSourceManager(tenantId, dsManager);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e);
        }
        List<DataSourceRepositoryListener> dsrListeners = dsrListenerMap.get(tenantId);
        if (dsrListeners != null) {
            for (DataSourceRepositoryListener dsrListener : dsrListeners) {
                dsrListener.setDataSourceRepository(repository);
            }
            dsrListenerMap.remove(tenantId);
        }
        SuperTenantCarbonContext.endTenantFlow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDataSourceRepositoryListener(int tenantId, DataSourceRepositoryListener listener) {
        Map<Integer, DataSourceInformationManager> dsManagerMap;
        Map<Integer, DataSourceInformationManager> map = dsManagerMap = DataSourceManagementHandler.getInstance().getDataSourceManagerMap();
        synchronized (map) {
            DataSourceInformationRepository repository = dsManagerMap.get(tenantId).getRepository();
            if (repository != null) {
                listener.setDataSourceRepository(repository);
            } else {
                List<DataSourceRepositoryListener> listeners = dsrListenerMap.get(tenantId);
                if (listeners == null) {
                    listeners = new Vector<DataSourceRepositoryListener>();
                    dsrListenerMap.put(tenantId, listeners);
                }
                listeners.add(listener);
            }
        }
    }

    public DataSourceManagementHandler getDataSourceManagementHandler() {
        return handler;
    }
}

