/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.factory.DataSourceInformationFactory;
import org.apache.synapse.commons.util.MiscellaneousUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceInformationListFactory {
    private static final Log log = LogFactory.getLog(DataSourceInformationListFactory.class);

    public static List<DataSourceInformation> createDataSourceInformationList(Properties dsProperties) {
        ArrayList<DataSourceInformation> dataSourceInformations = new ArrayList<DataSourceInformation>();
        if (dsProperties == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"DataSource properties cannot be found..");
            }
            return dataSourceInformations;
        }
        String dataSources = MiscellaneousUtil.getProperty(dsProperties, "synapse.datasources", null);
        if (dataSources == null || "".equals(dataSources)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No DataSources defined for initialization..");
            }
            return dataSourceInformations;
        }
        String[] dataSourcesNames = dataSources.split(",");
        if (dataSourcesNames == null || dataSourcesNames.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No DataSource definitions found for initialization..");
            }
            return dataSourceInformations;
        }
        for (String dsName : dataSourcesNames) {
            DataSourceInformation information;
            if (dsName == null || (information = DataSourceInformationFactory.createDataSourceInformation(dsName, dsProperties)) == null) continue;
            dataSourceInformations.add(information);
        }
        return dataSourceInformations;
    }
}

