/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.beanstalk.enterprise;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.commons.beanstalk.enterprise.CacheEntry;
import org.apache.synapse.commons.beanstalk.enterprise.EnterpriseBeanstalk;
import org.apache.synapse.commons.beanstalk.enterprise.EnterpriseBeanstalkViewMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseBeanstalkView
implements EnterpriseBeanstalkViewMBean {
    private EnterpriseBeanstalk beanstalk;

    EnterpriseBeanstalkView(EnterpriseBeanstalk beanstalk) {
        this.beanstalk = beanstalk;
    }

    @Override
    public String getBeanstalkName() {
        return this.beanstalk.getName();
    }

    @Override
    public int getCachedStatelessStubCount() {
        return this.beanstalk.getStatelessBeans().size();
    }

    @Override
    public int getCachedStatefulStubCount() {
        return this.beanstalk.getStatefulBeans().size();
    }

    @Override
    public Map getStatelessStubCacheLastAccessTimes() {
        return this.getLastAccessTimesMap(this.beanstalk.getStatelessBeans());
    }

    @Override
    public Map getStatefulStubCacheLastAccessTimes() {
        return this.getLastAccessTimesMap(this.beanstalk.getStatefulBeans());
    }

    private Map getLastAccessTimesMap(Map<String, CacheEntry> beanMap) {
        HashMap<String, Date> results = new HashMap<String, Date>();
        for (Map.Entry<String, CacheEntry> entry : beanMap.entrySet()) {
            results.put(entry.getKey(), new Date(entry.getValue().getLastAccessTime()));
        }
        return results;
    }

    @Override
    public void cleanExpiredStubsNow() throws Exception {
        this.beanstalk.removeExpiredBeans();
    }

    @Override
    public void removeStatelessStub(String className) {
        this.beanstalk.removeEnterpriseBean(className, null);
    }

    @Override
    public void removeStatefulStub(String className, String sessionId) {
        this.beanstalk.removeEnterpriseBean(className, sessionId);
    }
}

