/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.datasource.DataSourceInformationRepository;
import org.apache.synapse.commons.datasource.DataSourceInformationRepositoryListener;
import org.apache.synapse.commons.datasource.DataSourceRepositoryManager;
import org.apache.synapse.commons.datasource.InMemoryDataSourceRepository;
import org.apache.synapse.commons.datasource.JNDIBasedDataSourceRepository;
import org.apache.synapse.commons.datasource.factory.DataSourceInformationRepositoryFactory;
import org.apache.synapse.commons.util.MiscellaneousUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.datasource.DataSourceInformationManager;
import org.wso2.carbon.datasource.DataSourceInformationRepositoryService;
import org.wso2.carbon.datasource.DataSourceInformationRepositoryServiceImpl;
import org.wso2.carbon.datasource.DataSourceManagementHandler;
import org.wso2.carbon.datasource.multitenancy.DataSourceInitializer;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;
import org.wso2.securevault.secret.SecretCallbackHandler;
import org.wso2.securevault.secret.handler.SharedSecretCallbackHandlerCache;

public class DataSourceServiceComponent {
    private static final Log log = LogFactory.getLog(DataSourceServiceComponent.class);
    private static RegistryService registryService;
    private static DataSourceManagementHandler handler;
    private static String DATA_SOURCE_PROPERTIES;
    private ServiceRegistration registration;
    private SecretCallbackHandlerService secretCallbackHandlerService;
    private static List<String> JNDIProviderPort;
    private static final int CARBON_DEFAULT_PORT_OFFSET = 0;
    private static final String CARBON_CONFIG_PORT_OFFSET_NODE = "Ports.Offset";
    private static final String CARBON_CONFIG_PORT_JNDI_PROVIDER_NODE = "Ports.JNDIProviderPort";
    private static final String DATA_SOURCE_PROPERTIES_JNDI_PROVIDER_PORT = "synapse.datasources.providerPort";

    protected void activate(ComponentContext cmpCtx) throws Exception {
        if (registryService != null) {
            try {
                DataSourceInformationManager dsManager;
                DataSourceInformationRepository repository;
                SuperTenantCarbonContext.startTenantFlow();
                SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
                int tenantId = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId();
                UserRegistry registry = registryService.getConfigSystemRegistry(tenantId);
                if (registry == null) {
                    this.handleException("Unable to retrieve the config registry from the registry service");
                }
                BundleContext bundleContext = cmpCtx.getBundleContext();
                bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new DataSourceInitializer(), null);
                if (this.secretCallbackHandlerService != null) {
                    SecretCallbackHandler secretCallbackHandler = this.secretCallbackHandlerService.getSecretCallbackHandler();
                    SharedSecretCallbackHandlerCache.getInstance().setSecretCallbackHandler(secretCallbackHandler);
                }
                if ((repository = this.getDSFromCarbonDSConfig()).getRepositoryListener() == null) {
                    DataSourceRepositoryManager listener = new DataSourceRepositoryManager(new InMemoryDataSourceRepository(), new JNDIBasedDataSourceRepository());
                    repository.setRepositoryListener((DataSourceInformationRepositoryListener)listener);
                }
                if ((dsManager = handler.getTenantDataSourceInformationManager()) == null) {
                    dsManager = new DataSourceInformationManager();
                    dsManager.setRepository(repository);
                    dsManager.setRegistry((Registry)registry);
                    dsManager.populateDataSourceInformation();
                    handler.addDataSourceManager(tenantId, dsManager);
                }
                DataSourceInformationRepositoryServiceImpl repositoryServiceImpl = new DataSourceInformationRepositoryServiceImpl();
                this.registration = cmpCtx.getBundleContext().registerService(DataSourceInformationRepositoryService.class.getName(), (Object)repositoryServiceImpl, null);
                SuperTenantCarbonContext.endTenantFlow();
            }
            catch (RegistryException e) {
                log.error((Object)e);
                this.handleException("Error in retrieving SystemRegistry from Registry Service");
            }
        }
    }

    protected void deactivate(ComponentContext componentContext) throws Exception {
        DataSourceInformationManager dsManager = handler.getTenantDataSourceInformationManager();
        if (dsManager != null) {
            dsManager.shutDown();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping the (RuleServerManager Component");
        }
        componentContext.getBundleContext().ungetService(this.registration.getReference());
    }

    protected void setRegistryService(RegistryService regService) {
        registryService = regService;
    }

    protected void unsetRegistryService(RegistryService regService) {
        registryService = null;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    private DataSourceInformationRepository getDSFromCarbonDSConfig() {
        String carbonConfDir = CarbonUtils.getCarbonConfigDirPath();
        String propertiesFile = carbonConfDir + File.separator + DATA_SOURCE_PROPERTIES;
        Properties props = this.loadProperties(propertiesFile);
        this.trimProperties(props);
        int portOffset = this.readPortOffset();
        if (CarbonUtils.getServerConfiguration().getFirstProperty(CARBON_CONFIG_PORT_JNDI_PROVIDER_NODE) != null) {
            JNDIProviderPort = Arrays.asList(CarbonUtils.getServerConfiguration().getProperties(CARBON_CONFIG_PORT_JNDI_PROVIDER_NODE));
            props.setProperty(DATA_SOURCE_PROPERTIES_JNDI_PROVIDER_PORT, Integer.toString(Integer.parseInt(JNDIProviderPort.get(0).trim()) + portOffset));
        } else {
            String dsConfigJNDIPort = props.getProperty(DATA_SOURCE_PROPERTIES_JNDI_PROVIDER_PORT);
            if (dsConfigJNDIPort != null) {
                props.setProperty(DATA_SOURCE_PROPERTIES_JNDI_PROVIDER_PORT, Integer.toString(Integer.parseInt(props.getProperty(DATA_SOURCE_PROPERTIES_JNDI_PROVIDER_PORT).trim()) + portOffset));
            } else {
                props.setProperty(DATA_SOURCE_PROPERTIES_JNDI_PROVIDER_PORT, Integer.toString(2199 + portOffset));
            }
        }
        return DataSourceInformationRepositoryFactory.createDataSourceInformationRepository((Properties)props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String filePath) {
        File dataSourceFile = new File(filePath);
        if (!dataSourceFile.exists()) {
            return MiscellaneousUtil.loadProperties((String)DATA_SOURCE_PROPERTIES);
        }
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(dataSourceFile);
            properties.load(in);
        }
        catch (IOException e) {
            String msg = "Error loading properties from a file at :" + filePath;
            log.warn((Object)msg, (Throwable)e);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ignored) {}
            }
        }
        return properties;
    }

    private int readPortOffset() {
        String portOffset = CarbonUtils.getServerConfiguration().getFirstProperty(CARBON_CONFIG_PORT_OFFSET_NODE);
        try {
            return portOffset != null ? Integer.parseInt(portOffset.trim()) : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new IllegalArgumentException(msg);
    }

    protected void setSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SecretCallbackHandlerService bound to the ESB initialization process");
        }
        this.secretCallbackHandlerService = secretCallbackHandlerService;
    }

    protected void unsetSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SecretCallbackHandlerService  unbound from the ESB environment");
        }
        this.secretCallbackHandlerService = null;
    }

    private void trimProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String trimmedValue = value.trim();
            props.put(key, trimmedValue);
        }
    }

    static {
        handler = DataSourceManagementHandler.getInstance();
        DATA_SOURCE_PROPERTIES = "datasources.properties";
    }
}

