/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.datasource.DataSourceInformationManager;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class DataSourceManagementHandler {
    private static DataSourceManagementHandler thisInstance = new DataSourceManagementHandler();
    private static Map<Integer, DataSourceInformationManager> instanceMap = new HashMap<Integer, DataSourceInformationManager>();

    public static DataSourceManagementHandler getInstance() {
        return thisInstance;
    }

    private DataSourceManagementHandler() {
    }

    public void addDataSourceManager(int tenantId, DataSourceInformationManager dsManager) {
        this.getDataSourceManagerMap().put(tenantId, dsManager);
    }

    public Map<Integer, DataSourceInformationManager> getDataSourceManagerMap() {
        return instanceMap;
    }

    public DataSourceInformationManager getTenantDataSourceInformationManager() {
        int tenantId = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId();
        return this.getDataSourceManagerMap().get(tenantId);
    }
}

