/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.task;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.dataservices.task.DSTaskConstants;
import org.wso2.carbon.dataservices.task.DSTaskUtils;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;
import org.wso2.carbon.ntask.solutions.webservice.WebServiceCallTask;

public class DSTask
extends WebServiceCallTask {
    private final Log log = LogFactory.getLog(DSTask.class);
    private boolean serviceInit = false;

    public boolean isServiceInit() {
        return this.serviceInit;
    }

    private AxisService lookupAxisService(int tid, String serviceName) {
        AxisConfiguration tenantAxisConf;
        ConfigurationContext mainConfigCtx = TasksDSComponent.getConfigurationContextService().getServerConfigContext();
        if (tid == -1234) {
            tenantAxisConf = mainConfigCtx.getAxisConfiguration();
        } else {
            String tenantDomain = DSTaskUtils.getTenantDomainFromId(tid);
            tenantAxisConf = TenantAxisUtils.getTenantAxisConfiguration((String)tenantDomain, (ConfigurationContext)mainConfigCtx);
        }
        try {
            if (tenantAxisConf != null) {
                return tenantAxisConf.getService(serviceName);
            }
            return null;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    private boolean checkServiceInit() {
        if (this.isServiceInit()) {
            return true;
        }
        String serviceName = (String)this.getProperties().get(DSTaskConstants.DATA_SERVICE_NAME);
        String opName = (String)this.getProperties().get(DSTaskConstants.DATA_SERVICE_OPERATION_NAME);
        String tidProp = (String)this.getProperties().get("__TENANT_ID_PROP__");
        if (tidProp == null) {
            throw new RuntimeException("Cannot determine the tenant id for the scheduled service: " + serviceName);
        }
        int tid = Integer.parseInt(tidProp);
        AxisService axisService = this.lookupAxisService(tid, serviceName);
        if (axisService == null) {
            return false;
        }
        String httpEPR = DSTaskUtils.extractHTTPEPR(axisService);
        if (httpEPR == null) {
            throw new RuntimeException("No HTTP endpoint found for service: " + serviceName + " for scheduling service calls");
        }
        this.getProperties().put("SERVICE_TARGET_EPR", httpEPR);
        String mep = DSTaskUtils.isInOutMEPInOperation(axisService, opName) ? "IN_OUT" : "IN_ONLY";
        this.getProperties().put("SERVICE_MEP", mep);
        this.serviceInit = true;
        super.init();
        return this.isServiceInit();
    }

    public void init() {
        this.checkServiceInit();
    }

    public void execute() {
        if (this.checkServiceInit()) {
            super.execute();
        } else {
            this.log.info((Object)("Target service '" + (String)this.getProperties().get(DSTaskConstants.DATA_SERVICE_NAME) + "' not initialized yet..."));
        }
    }
}

