/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.htmlcleaner.HtmlCleanerException;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.TagInfo;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigFileTagProvider
extends HashMap
implements ITagInfoProvider {
    static SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private boolean generateCode = false;

    private ConfigFileTagProvider() {
    }

    public ConfigFileTagProvider(InputSource inputSource) {
        try {
            new ConfigParser(this).parse(inputSource);
        }
        catch (Exception exception) {
            throw new HtmlCleanerException("Error parsing tag configuration file!", exception);
        }
    }

    public ConfigFileTagProvider(File file) {
        try {
            new ConfigParser(this).parse(new InputSource(new FileReader(file)));
        }
        catch (Exception exception) {
            throw new HtmlCleanerException("Error parsing tag configuration file!", exception);
        }
    }

    public ConfigFileTagProvider(URL uRL) {
        try {
            Object object = uRL.getContent();
            if (object instanceof InputStream) {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
                new ConfigParser(this).parse(new InputSource(inputStreamReader));
            }
        }
        catch (Exception exception) {
            throw new HtmlCleanerException("Error parsing tag configuration file!", exception);
        }
    }

    public TagInfo getTagInfo(String string) {
        return (TagInfo)this.get(string);
    }

    public static void main(String[] stringArray) throws IOException, SAXException, ParserConfigurationException {
        ConfigFileTagProvider configFileTagProvider = new ConfigFileTagProvider();
        configFileTagProvider.generateCode = true;
        File file = new File("default.xml");
        String string = "org.htmlcleaner";
        String string2 = "DefaultTagProvider";
        ConfigFileTagProvider configFileTagProvider2 = configFileTagProvider;
        configFileTagProvider2.getClass();
        ConfigParser configParser = configFileTagProvider2.new ConfigParser(configFileTagProvider);
        System.out.println("package " + string + ";");
        System.out.println("import java.util.HashMap;");
        System.out.println("public class " + string2 + " extends HashMap implements ITagInfoProvider {");
        System.out.println("public " + string2 + "() {");
        System.out.println("TagInfo tagInfo;");
        configParser.parse(new InputSource(new FileReader(file)));
        System.out.println("}");
        System.out.println("}");
    }

    static {
        parserFactory.setValidating(false);
        parserFactory.setNamespaceAware(false);
    }

    private class ConfigParser
    extends DefaultHandler {
        private TagInfo tagInfo = null;
        private String dependencyName = null;
        private Map tagInfoMap;

        ConfigParser(Map map) {
            this.tagInfoMap = map;
        }

        public void parse(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
            SAXParser sAXParser = parserFactory.newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)this);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.tagInfo != null) {
                String string = new String(cArray, n, n2).trim();
                if ("fatal-tags".equals(this.dependencyName)) {
                    this.tagInfo.defineFatalTags(string);
                    if (ConfigFileTagProvider.this.generateCode) {
                        System.out.println("tagInfo.defineFatalTags(\"" + string + "\");");
                    }
                } else if ("req-enclosing-tags".equals(this.dependencyName)) {
                    this.tagInfo.defineRequiredEnclosingTags(string);
                    if (ConfigFileTagProvider.this.generateCode) {
                        System.out.println("tagInfo.defineRequiredEnclosingTags(\"" + string + "\");");
                    }
                } else if ("forbidden-tags".equals(this.dependencyName)) {
                    this.tagInfo.defineForbiddenTags(string);
                    if (ConfigFileTagProvider.this.generateCode) {
                        System.out.println("tagInfo.defineForbiddenTags(\"" + string + "\");");
                    }
                } else if ("allowed-children-tags".equals(this.dependencyName)) {
                    this.tagInfo.defineAllowedChildrenTags(string);
                    if (ConfigFileTagProvider.this.generateCode) {
                        System.out.println("tagInfo.defineAllowedChildrenTags(\"" + string + "\");");
                    }
                } else if ("higher-level-tags".equals(this.dependencyName)) {
                    this.tagInfo.defineHigherLevelTags(string);
                    if (ConfigFileTagProvider.this.generateCode) {
                        System.out.println("tagInfo.defineHigherLevelTags(\"" + string + "\");");
                    }
                } else if ("close-before-copy-inside-tags".equals(this.dependencyName)) {
                    this.tagInfo.defineCloseBeforeCopyInsideTags(string);
                    if (ConfigFileTagProvider.this.generateCode) {
                        System.out.println("tagInfo.defineCloseBeforeCopyInsideTags(\"" + string + "\");");
                    }
                } else if ("close-inside-copy-after-tags".equals(this.dependencyName)) {
                    this.tagInfo.defineCloseInsideCopyAfterTags(string);
                    if (ConfigFileTagProvider.this.generateCode) {
                        System.out.println("tagInfo.defineCloseInsideCopyAfterTags(\"" + string + "\");");
                    }
                } else if ("close-before-tags".equals(this.dependencyName)) {
                    this.tagInfo.defineCloseBeforeTags(string);
                    if (ConfigFileTagProvider.this.generateCode) {
                        System.out.println("tagInfo.defineCloseBeforeTags(\"" + string + "\");");
                    }
                }
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("tag".equals(string3)) {
                String string4 = attributes.getValue("name");
                String string5 = attributes.getValue("content");
                String string6 = attributes.getValue("section");
                String string7 = attributes.getValue("deprecated");
                String string8 = attributes.getValue("unique");
                String string9 = attributes.getValue("ignore-permitted");
                this.tagInfo = new TagInfo(string4, "all".equals(string5) ? 0 : ("none".equals(string5) ? 1 : 2), "all".equals(string6) ? 0 : ("head".equals(string6) ? 1 : 2), string7 != null && "true".equals(string7), string8 != null && "true".equals(string8), string9 != null && "true".equals(string9));
                if (ConfigFileTagProvider.this.generateCode) {
                    String string10 = "tagInfo = new TagInfo(\"#1\", #2, #3, #4, #5, #6);";
                    string10 = string10.replaceAll("#1", string4);
                    string10 = string10.replaceAll("#2", "all".equals(string5) ? "TagInfo.CONTENT_ALL" : ("none".equals(string5) ? "TagInfo.CONTENT_NONE" : " TagInfo.CONTENT_TEXT"));
                    string10 = string10.replaceAll("#3", "all".equals(string6) ? "TagInfo.HEAD_AND_BODY" : ("head".equals(string6) ? "TagInfo.HEAD" : "TagInfo.BODY"));
                    string10 = string10.replaceAll("#4", Boolean.toString(string7 != null && "true".equals(string7)));
                    string10 = string10.replaceAll("#5", Boolean.toString(string8 != null && "true".equals(string8)));
                    string10 = string10.replaceAll("#6", Boolean.toString(string9 != null && "true".equals(string9)));
                    System.out.println(string10);
                }
            } else if (!"tags".equals(string3)) {
                this.dependencyName = string3;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("tag".equals(string3)) {
                if (this.tagInfo != null) {
                    this.tagInfoMap.put(this.tagInfo.getName(), this.tagInfo);
                    if (ConfigFileTagProvider.this.generateCode) {
                        System.out.println("this.put(\"" + this.tagInfo.getName() + "\", tagInfo);\n");
                    }
                }
                this.tagInfo = null;
            } else if (!"tags".equals(string3)) {
                this.dependencyName = null;
            }
        }
    }
}

