/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.task;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.DataServiceUser;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.tools.DSTools;
import org.wso2.carbon.dataservices.task.DSTaskUtils;

public class DataTaskContext {
    private AxisConfiguration axisConfig;

    public DataTaskContext(int tid) {
        this.axisConfig = DSTaskUtils.lookupAxisConfig(tid);
    }

    private DataService getDataService(String serviceName) {
        AxisService axisService = DSTaskUtils.lookupAxisService(this.axisConfig, serviceName);
        if (axisService == null) {
            return null;
        }
        DataService dataService = (DataService)axisService.getParameterValue("org.wso2.ws.dataservice.dataservice.obj");
        return dataService;
    }

    public boolean checkServices(String ... services) {
        for (String service : services) {
            if (this.getDataService(service) != null) continue;
            return false;
        }
        return true;
    }

    public OMElement invokeOperation(String serviceName, String operationName, Map<String, ParamValue> params) throws DataServiceFault {
        DataService dataService = this.getDataService(serviceName);
        if (dataService == null) {
            throw new DataServiceFault("The service '" + serviceName + "' does not exist");
        }
        return DSTools.invokeOperation((DataService)dataService, (String)operationName, params);
    }

    public void invokeOperation(String serviceName, String operationName, List<Map<String, ParamValue>> batchParams) throws DataServiceFault {
        DataService dataService = this.getDataService(serviceName);
        if (dataService == null) {
            throw new DataServiceFault("The service '" + serviceName + "' does not exist");
        }
        DSTools.invokeOperation((DataService)dataService, (String)operationName, batchParams);
    }

    public OMElement accessResource(String serviceName, String resourcePath, Map<String, ParamValue> params, String accessMethod) throws DataServiceFault {
        DataService dataService = this.getDataService(serviceName);
        if (dataService == null) {
            throw new DataServiceFault("The service '" + serviceName + "' does not exist");
        }
        return DSTools.accessResource((DataService)dataService, (String)resourcePath, params, (String)accessMethod);
    }

    public void setDataServicesUser(String username, String password) throws DataServiceFault {
        if (!DBUtils.authenticate((String)username, (String)password)) {
            throw new DataServiceFault("Invalid credentials for user '" + username + "'");
        }
        DSTools.setDataServicesUser((DataServiceUser)new DataServiceUser(username, new HashSet<String>(Arrays.asList(DBUtils.getUserRoles((String)username)))));
    }
}

