/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.cassandra.cql.jdbc.AbstractStatement;
import org.apache.cassandra.cql.jdbc.CassandraConnection;
import org.apache.cassandra.cql.jdbc.CassandraResultSet;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraStatement
extends AbstractStatement
implements Statement,
Comparable<Object> {
    private static final Logger logger = LoggerFactory.getLogger(CassandraStatement.class);
    protected CassandraConnection connection;
    protected String cql;
    protected int fetchDirection = 1000;
    protected int fetchSize = 0;
    protected int maxFieldSize = 0;
    protected int maxRows = 0;
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;
    protected int resultSetHoldability = 1;
    protected ResultSet currentResultSet = null;
    protected int updateCount = -1;
    protected boolean escapeProcessing = true;

    CassandraStatement(CassandraConnection con) throws SQLException {
        this(con, null);
    }

    CassandraStatement(CassandraConnection con, String cql) throws SQLException {
        this.connection = con;
        this.cql = cql;
    }

    CassandraStatement(CassandraConnection con, String cql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(con, cql, resultSetType, resultSetConcurrency, 1);
    }

    CassandraStatement(CassandraConnection con, String cql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.connection = con;
        this.cql = cql;
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new SQLSyntaxErrorException("the argument for result set type : %s is not a valid value");
        }
        this.resultSetType = resultSetType;
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new SQLSyntaxErrorException("the argument for result set type : %s is not a valid value");
        }
        this.resultSetConcurrency = resultSetConcurrency;
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw new SQLSyntaxErrorException("the argument for result set holdability : %s is not a valid value");
        }
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not currently support this batch in Statement");
    }

    protected final void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLRecoverableException("method was called on a closed Statement");
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not currently support this batch in Statement");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void close() throws SQLException {
        this.connection.removeStatement(this);
        this.connection = null;
        this.cql = null;
    }

    private void doExecute(String sql) throws SQLException {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("CQL: " + sql);
            }
            this.resetResults();
            CqlResult rSet = this.connection.execute(sql);
            String keyspace = this.connection.currentKeyspace;
            switch (rSet.getType()) {
                case ROWS: {
                    this.currentResultSet = new CassandraResultSet(this, rSet, keyspace);
                    break;
                }
                case INT: {
                    this.updateCount = rSet.getNum();
                    break;
                }
                case VOID: {
                    this.updateCount = 0;
                }
            }
        }
        catch (InvalidRequestException e) {
            throw new SQLSyntaxErrorException(e.getWhy() + "\n'" + sql + "'", e);
        }
        catch (UnavailableException e) {
            throw new SQLNonTransientConnectionException("no Cassandra server is available", e);
        }
        catch (TimedOutException e) {
            throw new SQLTransientConnectionException(e);
        }
        catch (SchemaDisagreementException e) {
            throw new SQLRecoverableException("schema does not match across nodes, (try again later)");
        }
        catch (TException e) {
            throw new SQLNonTransientConnectionException(e);
        }
    }

    @Override
    public boolean execute(String query) throws SQLException {
        this.checkNotClosed();
        this.doExecute(query);
        return this.currentResultSet != null;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLSyntaxErrorException("auto key generation value of : %s is illegal");
        }
        if (autoGeneratedKeys == 1) {
            throw new SQLFeatureNotSupportedException("the Cassandra implementation does not currently support returning generated  keys");
        }
        return this.execute(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not currently support this batch in Statement");
    }

    @Override
    public ResultSet executeQuery(String query) throws SQLException {
        this.checkNotClosed();
        this.doExecute(query);
        if (this.currentResultSet == null) {
            throw new SQLNonTransientException("No ResultSet returned from the CQL statement passed in an 'executeQuery()' method");
        }
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate(String query) throws SQLException {
        this.checkNotClosed();
        this.doExecute(query);
        if (this.currentResultSet != null) {
            throw new SQLNonTransientException("No Update Count was returned from the CQL statement passed in an 'executeUpdate()' method");
        }
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLFeatureNotSupportedException("auto key generation value of : %s is illegal");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkNotClosed();
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return this.fetchSize;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkNotClosed();
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkNotClosed();
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkNotClosed();
        this.resetResults();
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkNotClosed();
        switch (current) {
            case 1: {
                this.resetResults();
                break;
            }
            case 2: 
            case 3: {
                throw new SQLFeatureNotSupportedException("the Cassandra implementation does not currently support multiple open Result Sets");
            }
            default: {
                throw new SQLSyntaxErrorException(String.format("the argument for keeping the current result set : %s is not a valid value", current));
            }
        }
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        return this.currentResultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkNotClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkNotClosed();
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkNotClosed();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkNotClosed();
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection == null;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    protected final void resetResults() {
        this.currentResultSet = null;
        this.updateCount = -1;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkNotClosed();
        this.escapeProcessing = enable;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
        if (direction == 1000 || direction == 1001 || direction == 1002) {
            if (this.getResultSetType() == 1003 && direction != 1000) {
                throw new SQLSyntaxErrorException(String.format("fetch direction value of : %s is illegal", direction));
            }
        } else {
            throw new SQLSyntaxErrorException(String.format("fetch direction value of : %s is illegal", direction));
        }
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        this.checkNotClosed();
        if (size < 0) {
            throw new SQLSyntaxErrorException(String.format("fetch size of : %s rows may not be negative", size));
        }
        this.fetchSize = size;
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException(String.format("no object was found that matched the provided interface: %s", iface.getSimpleName()));
    }

    @Override
    public int compareTo(Object target) {
        if (this.equals(target)) {
            return 0;
        }
        if (this.hashCode() < target.hashCode()) {
            return -1;
        }
        return 1;
    }
}

