/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql.jdbc.AbstractJdbcType;
import org.apache.cassandra.cql.jdbc.AbstractResultSet;
import org.apache.cassandra.cql.jdbc.CassandraResultSetExtras;
import org.apache.cassandra.cql.jdbc.CassandraRowId;
import org.apache.cassandra.cql.jdbc.JdbcCounterColumn;
import org.apache.cassandra.cql.jdbc.TypedColumn;
import org.apache.cassandra.cql.jdbc.TypesMap;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.CqlMetadata;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.utils.ByteBufferUtil;

class CassandraResultSet
extends AbstractResultSet
implements CassandraResultSetExtras {
    public static final int DEFAULT_TYPE = 1003;
    public static final int DEFAULT_CONCURRENCY = 1007;
    public static final int DEFAULT_HOLDABILITY = 1;
    private final String keyspace;
    private Iterator<CqlRow> rowsIterator;
    int rowNumber = 0;
    private byte[] curRowKey = null;
    private List<TypedColumn> values = new ArrayList<TypedColumn>();
    private Map<String, Integer> indexMap = new HashMap<String, Integer>();
    private final CResultSetMetaData meta;
    private final Statement statement;
    private int resultSetType;
    private int fetchDirection;
    private int fetchSize;
    private boolean wasNull;
    private CqlMetadata schema;

    CassandraResultSet() {
        this.keyspace = null;
        this.statement = null;
        this.meta = new CResultSetMetaData();
    }

    CassandraResultSet(Statement statement, CqlResult resultSet, String keyspace) throws SQLException {
        this.statement = statement;
        this.keyspace = keyspace;
        this.resultSetType = statement.getResultSetType();
        this.fetchDirection = statement.getFetchDirection();
        this.fetchSize = statement.getFetchSize();
        this.schema = resultSet.schema;
        this.rowsIterator = resultSet.getRowsIterator();
        if (this.hasMoreRows()) {
            this.populateColumns();
            this.rowsIterator = resultSet.getRowsIterator();
        }
        this.meta = new CResultSetMetaData();
    }

    private final boolean hasMoreRows() {
        return this.rowsIterator != null && this.rowsIterator.hasNext();
    }

    private final void populateColumns() {
        this.values.clear();
        this.indexMap.clear();
        CqlRow row = this.rowsIterator.next();
        this.curRowKey = row.getKey();
        List<Column> cols = row.getColumns();
        for (Column col : cols) {
            TypedColumn c = this.createColumn(col);
            String columnName = c.getNameString();
            this.values.add(c);
            this.indexMap.put(columnName, this.values.size());
        }
    }

    @Override
    public boolean absolute(int arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    private final void checkIndex(int index) throws SQLException {
        if (index < 1 || index > this.values.size()) {
            throw new SQLSyntaxErrorException(String.format("index must be a positive number less or equal the count of returned columns: %s", String.valueOf(index)) + " " + this.values.size());
        }
    }

    private final void checkName(String name) throws SQLException {
        if (this.indexMap.get(name) == null) {
            throw new SQLSyntaxErrorException(String.format("name provided was not in the list of valid column labels: %s", name));
        }
    }

    private final void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLRecoverableException("method was called on a closed ResultSet");
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void close() throws SQLException {
        this.indexMap = null;
        this.values = null;
    }

    @Override
    public int findColumn(String name) throws SQLException {
        this.checkNotClosed();
        this.checkName(name);
        return this.indexMap.get(name);
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public BigDecimal getBigDecimal(int index) throws SQLException {
        this.checkIndex(index);
        return this.getBigDecimal(this.values.get(index - 1));
    }

    @Override
    public BigDecimal getBigDecimal(int index, int scale) throws SQLException {
        this.checkIndex(index);
        return this.getBigDecimal(this.values.get(index - 1)).setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(String name) throws SQLException {
        this.checkName(name);
        return this.getBigDecimal(this.indexMap.get(name));
    }

    @Override
    public BigDecimal getBigDecimal(String name, int scale) throws SQLException {
        this.checkName(name);
        return this.getBigDecimal(this.indexMap.get(name)).setScale(scale);
    }

    private BigDecimal getBigDecimal(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Long) {
            return BigDecimal.valueOf((Long)value);
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        try {
            if (value instanceof String) {
                return new BigDecimal((String)value);
            }
        }
        catch (NumberFormatException e) {
            throw new SQLSyntaxErrorException(e);
        }
        throw new SQLSyntaxErrorException(String.format("column was stored in %s format which is not translatable to %s", value.getClass().getSimpleName(), "BigDecimal"));
    }

    @Override
    public BigInteger getBigInteger(int index) throws SQLException {
        this.checkIndex(index);
        return this.getBigInteger(this.values.get(index - 1));
    }

    @Override
    public BigInteger getBigInteger(String name) throws SQLException {
        this.checkName(name);
        return this.getBigInteger(this.indexMap.get(name));
    }

    private BigInteger getBigInteger(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return BigInteger.ZERO;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Integer) {
            return BigInteger.valueOf(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        try {
            if (value instanceof String) {
                return new BigInteger((String)value);
            }
        }
        catch (NumberFormatException e) {
            throw new SQLSyntaxErrorException(e);
        }
        throw new SQLSyntaxErrorException(String.format("column was stored in %s format which is not translatable to %s", value.getClass().getSimpleName(), "BigInteger"));
    }

    @Override
    public boolean getBoolean(int index) throws SQLException {
        this.checkIndex(index);
        return this.getBoolean(this.values.get(index - 1));
    }

    @Override
    public boolean getBoolean(String name) throws SQLException {
        this.checkName(name);
        return this.getBoolean(this.indexMap.get(name));
    }

    private final Boolean getBoolean(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Integer) {
            return (Integer)value != 0;
        }
        if (value instanceof Long) {
            return (Long)value != 0L;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).intValue() != 0;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.equalsIgnoreCase("true")) {
                return true;
            }
            if (str.equalsIgnoreCase("false")) {
                return false;
            }
            throw new SQLSyntaxErrorException(String.format("string value was neither 'true' nor 'false' :  %s", str));
        }
        throw new SQLSyntaxErrorException(String.format("column was stored in %s format which is not translatable to %s", value.getClass().getSimpleName(), "Boolean"));
    }

    @Override
    public byte getByte(int index) throws SQLException {
        this.checkIndex(index);
        return this.getByte(this.values.get(index - 1));
    }

    @Override
    public byte getByte(String name) throws SQLException {
        this.checkName(name);
        return this.getByte(this.indexMap.get(name));
    }

    private final Byte getByte(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return (byte)0;
        }
        if (value instanceof Integer) {
            return ((Integer)value).byteValue();
        }
        if (value instanceof Long) {
            return ((Long)value).byteValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).byteValue();
        }
        try {
            if (value instanceof String) {
                return new Byte((String)value);
            }
        }
        catch (NumberFormatException e) {
            throw new SQLSyntaxErrorException(e);
        }
        throw new SQLSyntaxErrorException(String.format("column was stored in %s format which is not translatable to %s", value.getClass().getSimpleName(), "Byte"));
    }

    @Override
    public byte[] getBytes(int index) throws SQLException {
        return this.getBytes(this.values.get(index - 1));
    }

    @Override
    public byte[] getBytes(String name) throws SQLException {
        return this.getBytes(this.indexMap.get(name));
    }

    private byte[] getBytes(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        ByteBuffer value = column.getRawColumn().value;
        this.wasNull = value == null;
        return value == null ? null : ByteBufferUtil.clone(value).array();
    }

    @Override
    public TypedColumn getColumn(int index) throws SQLException {
        this.checkIndex(index);
        this.checkNotClosed();
        return this.values.get(index - 1);
    }

    @Override
    public TypedColumn getColumn(String name) throws SQLException {
        this.checkName(name);
        this.checkNotClosed();
        return this.values.get(this.indexMap.get(name));
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkNotClosed();
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public Date getDate(int index) throws SQLException {
        this.checkIndex(index);
        return this.getDate(this.values.get(index - 1));
    }

    @Override
    public Date getDate(int index, Calendar calendar) throws SQLException {
        this.checkIndex(index);
        return this.getDate(index);
    }

    @Override
    public Date getDate(String name) throws SQLException {
        this.checkName(name);
        return this.getDate(this.indexMap.get(name));
    }

    @Override
    public Date getDate(String name, Calendar calendar) throws SQLException {
        this.checkName(name);
        return this.getDate(name);
    }

    private Date getDate(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return null;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        try {
            if (value instanceof String) {
                return Date.valueOf((String)value);
            }
        }
        catch (IllegalArgumentException e) {
            throw new SQLSyntaxErrorException(e);
        }
        throw new SQLSyntaxErrorException(String.format("column was stored in %s format which is not translatable to %s", value.getClass().getSimpleName(), "SQL Date"));
    }

    @Override
    public double getDouble(int index) throws SQLException {
        this.checkIndex(index);
        return this.getDouble(this.values.get(index - 1));
    }

    @Override
    public double getDouble(String name) throws SQLException {
        this.checkName(name);
        return this.getDouble(this.indexMap.get(name));
    }

    private final Double getDouble(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Integer) {
            return new Double(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new Double(((Long)value).longValue());
        }
        if (value instanceof BigInteger) {
            return new Double(((BigInteger)value).doubleValue());
        }
        try {
            if (value instanceof String) {
                return new Double((String)value);
            }
        }
        catch (NumberFormatException e) {
            throw new SQLSyntaxErrorException(e);
        }
        throw new SQLSyntaxErrorException(String.format("column was stored in %s format which is not translatable to %s", value.getClass().getSimpleName(), "Double"));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return this.fetchSize;
    }

    @Override
    public float getFloat(int index) throws SQLException {
        this.checkIndex(index);
        return this.getFloat(this.values.get(index - 1)).floatValue();
    }

    @Override
    public float getFloat(String name) throws SQLException {
        this.checkName(name);
        return this.getFloat(this.indexMap.get(name));
    }

    private final Float getFloat(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return Float.valueOf(0.0f);
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Double) {
            return Float.valueOf(((Double)value).floatValue());
        }
        if (value instanceof Integer) {
            return new Float(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new Float(((Long)value).longValue());
        }
        if (value instanceof BigInteger) {
            return new Float(((BigInteger)value).floatValue());
        }
        try {
            if (value instanceof String) {
                return new Float((String)value);
            }
        }
        catch (NumberFormatException e) {
            throw new SQLException(e);
        }
        throw new SQLSyntaxErrorException(String.format("column was stored in %s format which is not translatable to %s", value.getClass().getSimpleName(), "Float"));
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        return this.statement.getResultSetHoldability();
    }

    @Override
    public int getInt(int index) throws SQLException {
        this.checkIndex(index);
        return this.getInt(this.values.get(index - 1));
    }

    @Override
    public int getInt(String name) throws SQLException {
        this.checkName(name);
        return this.getInt(this.indexMap.get(name));
    }

    private int getInt(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).intValue();
        }
        try {
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
        }
        catch (NumberFormatException e) {
            throw new SQLSyntaxErrorException(e);
        }
        throw new SQLSyntaxErrorException(String.format("column was stored in %s format which is not translatable to %s", value.getClass().getSimpleName(), "int"));
    }

    @Override
    public byte[] getKey() throws SQLException {
        return this.curRowKey;
    }

    @Override
    public long getLong(int index) throws SQLException {
        this.checkIndex(index);
        return this.getLong(this.values.get(index - 1));
    }

    @Override
    public long getLong(String name) throws SQLException {
        this.checkName(name);
        return this.getLong(this.indexMap.get(name));
    }

    private Long getLong(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return (long)((Integer)value);
        }
        if (value instanceof BigInteger) {
            return this.getBigInteger(column).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        try {
            if (value instanceof String) {
                return Long.parseLong((String)value);
            }
        }
        catch (NumberFormatException e) {
            throw new SQLSyntaxErrorException(e);
        }
        throw new SQLSyntaxErrorException(String.format("column was stored in %s format which is not translatable to %s", value.getClass().getSimpleName(), "Long"));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        return this.meta;
    }

    @Override
    public Object getObject(int index) throws SQLException {
        this.checkIndex(index);
        return this.getObject(this.values.get(index - 1));
    }

    @Override
    public Object getObject(String name) throws SQLException {
        this.checkName(name);
        return this.getObject(this.indexMap.get(name));
    }

    private Object getObject(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        this.wasNull = value == null;
        return this.wasNull ? null : value;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber;
    }

    @Override
    public RowId getRowId(int index) throws SQLException {
        this.checkIndex(index);
        return this.getRowId(this.values.get(index - 1));
    }

    @Override
    public RowId getRowId(String name) throws SQLException {
        this.checkName(name);
        return this.getRowId(this.indexMap.get(name));
    }

    private final RowId getRowId(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        ByteBuffer value = column.getRawColumn().value;
        this.wasNull = value == null;
        return value == null ? null : new CassandraRowId(value);
    }

    @Override
    public short getShort(int index) throws SQLException {
        this.checkIndex(index);
        return this.getShort(this.values.get(index - 1));
    }

    @Override
    public short getShort(String name) throws SQLException {
        this.checkName(name);
        return this.getShort(this.indexMap.get(name));
    }

    private final Short getShort(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return (short)0;
        }
        if (value instanceof Integer) {
            return ((Integer)value).shortValue();
        }
        if (value instanceof Long) {
            return ((Long)value).shortValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).shortValue();
        }
        try {
            if (value instanceof String) {
                return new Short((String)value);
            }
        }
        catch (NumberFormatException e) {
            throw new SQLSyntaxErrorException(e);
        }
        throw new SQLSyntaxErrorException(String.format("column was stored in %s format which is not translatable to %s", value.getClass().getSimpleName(), "Short"));
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkNotClosed();
        return this.statement;
    }

    @Override
    public String getString(int index) throws SQLException {
        this.checkIndex(index);
        return this.getString(this.values.get(index - 1));
    }

    @Override
    public String getString(String name) throws SQLException {
        this.checkName(name);
        return this.getString(this.indexMap.get(name));
    }

    private String getString(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        this.wasNull = value == null;
        return this.wasNull ? null : value.toString();
    }

    @Override
    public Time getTime(int index) throws SQLException {
        this.checkIndex(index);
        return this.getTime(this.values.get(index - 1));
    }

    @Override
    public Time getTime(int index, Calendar calendar) throws SQLException {
        this.checkIndex(index);
        return this.getTime(index);
    }

    @Override
    public Time getTime(String name) throws SQLException {
        this.checkName(name);
        return this.getTime(this.indexMap.get(name));
    }

    @Override
    public Time getTime(String name, Calendar calendar) throws SQLException {
        this.checkName(name);
        return this.getTime(name);
    }

    private Time getTime(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return null;
        }
        if (value instanceof Long) {
            return new Time((Long)value);
        }
        if (value instanceof java.util.Date) {
            return new Time(((java.util.Date)value).getTime());
        }
        try {
            if (value instanceof String) {
                return Time.valueOf((String)value);
            }
        }
        catch (IllegalArgumentException e) {
            throw new SQLSyntaxErrorException(e);
        }
        throw new SQLSyntaxErrorException(String.format("column was stored in %s format which is not translatable to %s", value.getClass().getSimpleName(), "SQL Time"));
    }

    @Override
    public Timestamp getTimestamp(int index) throws SQLException {
        this.checkIndex(index);
        return this.getTimestamp(this.values.get(index - 1));
    }

    @Override
    public Timestamp getTimestamp(int index, Calendar calendar) throws SQLException {
        this.checkIndex(index);
        return this.getTimestamp(index);
    }

    @Override
    public Timestamp getTimestamp(String name) throws SQLException {
        this.checkName(name);
        return this.getTimestamp(this.indexMap.get(name));
    }

    @Override
    public Timestamp getTimestamp(String name, Calendar calendar) throws SQLException {
        this.checkName(name);
        return this.getTimestamp(name);
    }

    private Timestamp getTimestamp(TypedColumn column) throws SQLException {
        this.checkNotClosed();
        Object value = column.getValue();
        boolean bl = this.wasNull = value == null;
        if (this.wasNull) {
            return null;
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        try {
            if (value instanceof String) {
                return Timestamp.valueOf((String)value);
            }
        }
        catch (IllegalArgumentException e) {
            throw new SQLSyntaxErrorException(e);
        }
        throw new SQLSyntaxErrorException(String.format("column was stored in %s format which is not translatable to %s", value.getClass().getSimpleName(), "SQL Timestamp"));
    }

    @Override
    public int getType() throws SQLException {
        this.checkNotClosed();
        return this.resultSetType;
    }

    @Override
    public URL getURL(int arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public URL getURL(String arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber == Integer.MAX_VALUE;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber == 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.values == null;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkNotClosed();
        return !this.rowsIterator.hasNext();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return CassandraResultSetExtras.class.isAssignableFrom(iface);
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public synchronized boolean next() throws SQLException {
        if (this.hasMoreRows()) {
            this.populateColumns();
            ++this.rowNumber;
            return true;
        }
        this.rowNumber = Integer.MAX_VALUE;
        return false;
    }

    private TypedColumn createColumn(Column column) {
        String nameType = this.schema.name_types.get(column.name);
        AbstractJdbcType<?> comparator = TypesMap.getTypeForComparator(nameType == null ? this.schema.default_name_type : nameType);
        String valueType = this.schema.value_types.get(column.name);
        AbstractJdbcType<?> validator = TypesMap.getTypeForComparator(valueType == null ? this.schema.default_value_type : valueType);
        return new TypedColumn(column, comparator, validator);
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public boolean relative(int arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
        if (direction == 1000 || direction == 1001 || direction == 1002) {
            if (this.getType() == 1003 && direction != 1000) {
                throw new SQLSyntaxErrorException("attempt to set an illegal direction : " + direction);
            }
            this.fetchDirection = direction;
        }
        throw new SQLSyntaxErrorException(String.format("fetch direction value of : %s is illegal", direction));
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        this.checkNotClosed();
        if (size < 0) {
            throw new SQLException(String.format("fetch size of : %s rows may not be negative", size));
        }
        this.fetchSize = size;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.equals(CassandraResultSetExtras.class)) {
            return (T)this;
        }
        throw new SQLFeatureNotSupportedException(String.format("no object was found that matched the provided interface: %s", iface.getSimpleName()));
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    class CResultSetMetaData
    implements ResultSetMetaData {
        CResultSetMetaData() {
        }

        @Override
        public String getCatalogName(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return "";
        }

        @Override
        public String getColumnClassName(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return ((TypedColumn)CassandraResultSet.this.values.get(column - 1)).getValueType().getType().getName();
        }

        @Override
        public int getColumnCount() throws SQLException {
            return CassandraResultSet.this.values.size();
        }

        @Override
        public int getColumnDisplaySize(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return ((TypedColumn)CassandraResultSet.this.values.get(column - 1)).getValueString().length();
        }

        @Override
        public String getColumnLabel(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return this.getColumnName(column);
        }

        @Override
        public String getColumnName(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return ((TypedColumn)CassandraResultSet.this.values.get(column - 1)).getNameString();
        }

        @Override
        public int getColumnType(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return ((TypedColumn)CassandraResultSet.this.values.get(column - 1)).getValueType().getJdbcType();
        }

        @Override
        public String getColumnTypeName(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return ((TypedColumn)CassandraResultSet.this.values.get(column - 1)).getValueType().getClass().getSimpleName();
        }

        @Override
        public int getPrecision(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            TypedColumn col = (TypedColumn)CassandraResultSet.this.values.get(column - 1);
            return col.getValueType().getPrecision(col.getValue());
        }

        @Override
        public int getScale(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            TypedColumn tc = (TypedColumn)CassandraResultSet.this.values.get(column - 1);
            return tc.getValueType().getScale(tc.getValue());
        }

        @Override
        public String getSchemaName(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return CassandraResultSet.this.keyspace;
        }

        @Override
        public String getTableName(int column) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public boolean isAutoIncrement(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return ((TypedColumn)CassandraResultSet.this.values.get(column - 1)).getValueType() instanceof JdbcCounterColumn;
        }

        @Override
        public boolean isCaseSensitive(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            TypedColumn tc = (TypedColumn)CassandraResultSet.this.values.get(column - 1);
            return tc.getValueType().isCaseSensitive();
        }

        @Override
        public boolean isCurrency(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            TypedColumn tc = (TypedColumn)CassandraResultSet.this.values.get(column - 1);
            return tc.getValueType().isCurrency();
        }

        @Override
        public boolean isDefinitelyWritable(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return this.isWritable(column);
        }

        @Override
        public int isNullable(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return 1;
        }

        @Override
        public boolean isReadOnly(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return column == 0;
        }

        @Override
        public boolean isSearchable(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return false;
        }

        @Override
        public boolean isSigned(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            TypedColumn tc = (TypedColumn)CassandraResultSet.this.values.get(column - 1);
            return tc.getValueType().isSigned();
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public boolean isWritable(int column) throws SQLException {
            CassandraResultSet.this.checkIndex(column);
            return column > 0;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLFeatureNotSupportedException(String.format("no object was found that matched the provided interface: %s", iface.getSimpleName()));
        }
    }
}

