/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemLocation;
import com.hp.hpl.jena.sparql.sse.builders.BuilderLib;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderNode {
    public static Node buildNode(Item item) {
        if (!item.isNode()) {
            BuilderLib.broken((ItemLocation)item, "Not a node", item);
        }
        return item.getNode();
    }

    public static List<Node> buildNodeList(Item item) {
        BuilderLib.checkList(item);
        ItemList list = item.getList();
        return BuilderNode.buildNodeList(list);
    }

    public static List<Node> buildNodeList(ItemList list) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Item item : list) {
            Node v = BuilderNode.buildNode(item);
            nodes.add(v);
        }
        return nodes;
    }

    public static Var buildVar(Item item) {
        if (!item.isNode() || !Var.isVar(item.getNode())) {
            BuilderLib.broken((ItemLocation)item, "Not a variable", item);
        }
        return Var.alloc(item.getNode());
    }

    public static List<Var> buildVarList(Item item) {
        BuilderLib.checkList(item);
        ItemList list = item.getList();
        return BuilderNode.buildVarList(list);
    }

    public static List<Var> buildVarList(ItemList list) {
        ArrayList<Var> vars = new ArrayList<Var>();
        for (Item x : list) {
            Var v = BuilderNode.buildVar(x);
            vars.add(v);
        }
        return vars;
    }

    public static String buildSymbol(Item item) {
        if (!item.isSymbol()) {
            BuilderLib.broken((ItemLocation)item, "Not a symbol", item);
        }
        return item.getSymbol();
    }

    public static List<Var> buildVars(ItemList list) {
        ArrayList<Var> x = new ArrayList<Var>();
        for (int i = 0; i < list.size(); ++i) {
            Item item = list.get(i);
            Var var = BuilderNode.buildVar(item);
            x.add(Var.alloc(item.getNode()));
        }
        return x;
    }

    private static BigInteger buildInteger(Item item, boolean allowDefault) {
        NodeValue nv;
        Node node;
        if (allowDefault && item.equals(Item.defaultItem)) {
            return null;
        }
        if (!item.isNode()) {
            BuilderLib.broken(item, "Not an integer: " + item);
        }
        if (!(node = item.getNode()).isLiteral()) {
            BuilderLib.broken(item, "Not an integer: " + item);
        }
        if (!(nv = NodeValue.makeNode(node)).isInteger()) {
            BuilderLib.broken(item, "Not an integer: " + item);
        }
        return nv.getInteger();
    }

    public static int buildInt(Item item) {
        BigInteger i = BuilderNode.buildInteger(item, false);
        return i.intValue();
    }

    public static int buildInt(Item item, int dft) {
        BigInteger i = BuilderNode.buildInteger(item, true);
        if (i == null) {
            return dft;
        }
        return i.intValue();
    }

    public static int buildInt(ItemList list, int idx) {
        return BuilderNode.buildInt(list.get(idx));
    }

    public static int buildInt(ItemList list, int idx, int dft) {
        return BuilderNode.buildInt(list.get(idx), dft);
    }
}

