/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.http;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.engine.http.HttpQuery;
import com.hp.hpl.jena.sparql.engine.http.Params;
import com.hp.hpl.jena.sparql.resultset.XMLInput;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEngineHTTP
implements QueryExecution {
    public static final String QUERY_MIME_TYPE = "application/sparql-query";
    String queryString;
    String service;
    Context context = null;
    Params params = null;
    List<String> defaultGraphURIs = new ArrayList<String>();
    List<String> namedGraphURIs = new ArrayList<String>();
    private String user = null;
    private char[] password = null;

    public QueryEngineHTTP(String serviceURI, Query query) {
        this(serviceURI, query.toString());
    }

    public QueryEngineHTTP(String serviceURI, String queryString) {
        this.queryString = queryString;
        this.service = serviceURI;
        this.context = new Context(ARQ.getContext());
    }

    @Override
    public void setFileManager(FileManager fm) {
        throw new UnsupportedOperationException("FileManagers do not apply to remote query execution");
    }

    @Override
    public void setInitialBinding(QuerySolution binding) {
        throw new UnsupportedOperationException("Initial bindings not supported for remote queries");
    }

    public void setInitialBindings(ResultSet table) {
        throw new UnsupportedOperationException("Initial bindings not supported for remote queries");
    }

    public void setDefaultGraphURIs(List<String> defaultGraphURIs) {
        this.defaultGraphURIs = defaultGraphURIs;
    }

    public void setNamedGraphURIs(List<String> namedGraphURIs) {
        this.namedGraphURIs = namedGraphURIs;
    }

    public void addParam(String field, String value) {
        if (this.params == null) {
            this.params = new Params();
        }
        this.params.addParam(field, value);
    }

    public void addDefaultGraph(String defaultGraph) {
        if (this.defaultGraphURIs == null) {
            this.defaultGraphURIs = new ArrayList<String>();
        }
        this.defaultGraphURIs.add(defaultGraph);
    }

    public void addNamedGraph(String name) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList<String>();
        }
        this.namedGraphURIs.add(name);
    }

    public void setBasicAuthentication(String user, char[] password) {
        this.user = user;
        this.password = password;
    }

    @Override
    public ResultSet execSelect() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/sparql-results+xml");
        InputStream in = httpQuery.exec();
        ResultSet rs = ResultSetFactory.fromXML(in);
        return rs;
    }

    @Override
    public Model execConstruct() {
        return this.execConstruct(GraphFactory.makeJenaDefaultModel());
    }

    @Override
    public Model execConstruct(Model model) {
        return this.execModel(model);
    }

    @Override
    public Model execDescribe() {
        return this.execDescribe(GraphFactory.makeJenaDefaultModel());
    }

    @Override
    public Model execDescribe(Model model) {
        return this.execModel(model);
    }

    private Model execModel(Model model) {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/rdf+xml");
        InputStream in = httpQuery.exec();
        model.read(in, null);
        return model;
    }

    @Override
    public boolean execAsk() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/sparql-results+xml");
        InputStream in = httpQuery.exec();
        return XMLInput.booleanFromXML(in);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    private HttpQuery makeHttpQuery() {
        HttpQuery httpQuery = new HttpQuery(this.service);
        httpQuery.addParam("query", this.queryString);
        for (String dft : this.defaultGraphURIs) {
            httpQuery.addParam("default-graph-uri", dft);
        }
        for (String name : this.namedGraphURIs) {
            httpQuery.addParam("named-graph-uri", name);
        }
        if (this.params != null) {
            httpQuery.merge(this.params);
        }
        httpQuery.setBasicAuthentication(this.user, this.password);
        return httpQuery;
    }

    @Override
    public void abort() {
    }

    @Override
    public void close() {
    }

    public String toString() {
        HttpQuery httpQuery = this.makeHttpQuery();
        return "GET " + httpQuery.toString();
    }

    @Override
    public Dataset getDataset() {
        return null;
    }
}

