/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webharvest.definition.BaseElementDef;
import org.webharvest.definition.LoopDef;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.BodyProcessor;
import org.webharvest.runtime.scripting.ScriptEngine;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.ListVariable;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class LoopProcessor
extends BaseProcessor {
    private LoopDef loopDef;

    public LoopProcessor(LoopDef loopDef) {
        super(loopDef);
        this.loopDef = loopDef;
    }

    public Variable execute(Scraper scraper, ScraperContext context) {
        List list;
        ScriptEngine scriptEngine = scraper.getScriptEngine();
        String item = BaseTemplater.execute(this.loopDef.getItem(), scriptEngine);
        String index = BaseTemplater.execute(this.loopDef.getIndex(), scriptEngine);
        String maxLoopsString = BaseTemplater.execute(this.loopDef.getMaxloops(), scriptEngine);
        String filter = BaseTemplater.execute(this.loopDef.getFilter(), scriptEngine);
        boolean isEmpty = CommonUtil.getBooleanValue(BaseTemplater.execute(this.loopDef.getEmpty(), scriptEngine), false);
        this.setProperty("Item", item);
        this.setProperty("Index", index);
        this.setProperty("Max Loops", maxLoopsString);
        this.setProperty("Filter", filter);
        this.setProperty("Empty", String.valueOf(isEmpty));
        double maxLoops = 1.0E9;
        if (maxLoopsString != null && !"".equals(maxLoopsString.trim())) {
            maxLoops = Double.parseDouble(maxLoopsString);
        }
        BaseElementDef loopValueDef = this.loopDef.getLoopValueDef();
        Variable loopValue = new BodyProcessor(loopValueDef).run(scraper, context);
        this.debug(loopValueDef, scraper, loopValue);
        ArrayList resultList = new ArrayList();
        List list2 = list = loopValue != null ? loopValue.toList() : null;
        if (list != null) {
            Variable itemBeforeLoop = (Variable)context.get(item);
            Variable indexBeforeLoop = (Variable)context.get(index);
            List filteredList = filter != null ? this.createFilteredList(list, filter) : list;
            Iterator it = filteredList.iterator();
            int i = 1;
            while (it.hasNext() && (double)i <= maxLoops) {
                BaseElementDef bodyDef;
                Variable currElement = (Variable)it.next();
                if (item != null && !"".equals(item)) {
                    context.put(item, currElement);
                }
                if (index != null && !"".equals(index)) {
                    context.put(index, new NodeVariable(String.valueOf(i)));
                }
                EmptyVariable loopResult = (bodyDef = this.loopDef.getLoopBodyDef()) != null ? new BodyProcessor(bodyDef).run(scraper, context) : new EmptyVariable();
                this.debug(bodyDef, scraper, loopResult);
                if (!isEmpty) {
                    resultList.addAll(((Variable)loopResult).toList());
                }
                ++i;
            }
            if (item != null && itemBeforeLoop != null) {
                context.put(item, itemBeforeLoop);
            }
            if (index != null && indexBeforeLoop != null) {
                context.put(index, indexBeforeLoop);
            }
        }
        return isEmpty ? new EmptyVariable() : new ListVariable(resultList);
    }

    private List createFilteredList(List list, String filterStr) {
        ArrayList<Variable> result = new ArrayList<Variable>();
        HashSet<String> stringSet = new HashSet<String>();
        Filter filter = new Filter(filterStr, list.size());
        Iterator it = list.iterator();
        int index = 1;
        while (it.hasNext()) {
            Variable curr = (Variable)it.next();
            if (filter.isInFilter(index)) {
                if (filter.isUnique) {
                    String currStr = curr.toString();
                    if (!stringSet.contains(curr.toString())) {
                        result.add(curr);
                        stringSet.add(currStr);
                    }
                } else {
                    result.add(curr);
                }
            }
            ++index;
        }
        return result;
    }

    private static class Filter {
        private boolean isUnique = false;
        private List filterList;

        private Filter(String filterStr, int size) {
            StringTokenizer tokenizer = new StringTokenizer(filterStr, ",");
            this.filterList = new ArrayList();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if ("unique".equals(token)) {
                    this.isUnique = true;
                    continue;
                }
                if ("odd".equals(token)) {
                    this.filterList.add(new IntSublist(1, 2));
                    continue;
                }
                if ("even".equals(token)) {
                    this.filterList.add(new IntSublist(2, 2));
                    continue;
                }
                if (IntRange.isValid(token)) {
                    this.filterList.add(new IntRange(token, size));
                    continue;
                }
                if (!IntSublist.isValid(token)) continue;
                this.filterList.add(new IntSublist(token, size));
            }
        }

        private boolean isInFilter(int num) {
            int listSize = this.filterList.size();
            if (listSize == 0) {
                return true;
            }
            for (int i = 0; i < listSize; ++i) {
                CommonUtil.IntPair curr = (CommonUtil.IntPair)this.filterList.get(i);
                if (curr instanceof IntRange && ((IntRange)curr).isInRange(num)) {
                    return true;
                }
                if (!(curr instanceof IntSublist) || !((IntSublist)curr).isInSublist(num)) continue;
                return true;
            }
            return false;
        }
    }

    private static class IntSublist
    extends CommonUtil.IntPair {
        static boolean isValid(String s) {
            Pattern pattern = Pattern.compile("(\\d*)(:?)(\\d*?)");
            Matcher matcher = pattern.matcher(s);
            return matcher.matches();
        }

        private IntSublist(int x, int y) {
            super(x, y);
        }

        public IntSublist(String s, int size) {
            this.defineFromString(s, ':', size);
        }

        public boolean isInSublist(int index) {
            return (index - this.x) % this.y == 0;
        }
    }

    private static class IntRange
    extends CommonUtil.IntPair {
        static boolean isValid(String s) {
            Pattern pattern = Pattern.compile("(\\d*)(-?)(\\d*?)");
            Matcher matcher = pattern.matcher(s);
            return matcher.matches();
        }

        private IntRange(int x, int y) {
            super(x, y);
        }

        public IntRange(String s, int size) {
            this.defineFromString(s, '-', size);
        }

        public boolean isInRange(int index) {
            return index >= this.x && index <= this.y;
        }
    }
}

