/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import org.webharvest.definition.HttpParamDef;
import org.webharvest.exception.HttpException;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.BodyProcessor;
import org.webharvest.runtime.processors.HttpProcessor;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class HttpParamProcessor
extends BaseProcessor {
    private HttpParamDef httpParamDef;

    public HttpParamProcessor(HttpParamDef httpParamDef) {
        super(httpParamDef);
        this.httpParamDef = httpParamDef;
    }

    public Variable execute(Scraper scraper, ScraperContext context) {
        String name = BaseTemplater.execute(this.httpParamDef.getName(), scraper.getScriptEngine());
        String isFileStr = BaseTemplater.execute(this.httpParamDef.getIsfile(), scraper.getScriptEngine());
        boolean isFile = CommonUtil.getBooleanValue(isFileStr, false);
        String fileName = BaseTemplater.execute(this.httpParamDef.getFilename(), scraper.getScriptEngine());
        String contentType = BaseTemplater.execute(this.httpParamDef.getContenttype(), scraper.getScriptEngine());
        Variable value = new BodyProcessor(this.httpParamDef).execute(scraper, context);
        HttpProcessor httpProcessor = scraper.getRunningHttpProcessor();
        if (httpProcessor == null) {
            throw new HttpException("Usage of http-param processor is not allowed outside of http processor!");
        }
        httpProcessor.addHttpParam(name, isFile, fileName, contentType, value);
        this.setProperty("Name", name);
        this.setProperty("Is File", String.valueOf(isFile));
        this.setProperty("File Name", fileName);
        this.setProperty("Content Type", contentType);
        return value;
    }
}

