/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import org.webharvest.gui.ConfigPanel;
import org.webharvest.gui.Ide;
import org.webharvest.gui.component.CommonButton;
import org.webharvest.gui.component.WHControlsBorder;
import org.webharvest.gui.component.WHScrollPane;

public class RunParamsDialog
extends JDialog {
    private List params = new ArrayList();
    private Ide ide;
    private MyTableModel dataModel;
    private JTable table;

    public RunParamsDialog(Ide ide) throws HeadlessException {
        super(ide, "Initial Run Parameters", true);
        this.ide = ide;
        this.setResizable(false);
        this.createGUI();
    }

    private void createGUI() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dataModel = new MyTableModel();
        this.table = new JTable(this.dataModel){

            public void editingStopped(ChangeEvent event) {
                TableCellEditor editor = (TableCellEditor)event.getSource();
                int row = this.getEditingRow();
                int column = this.getEditingColumn();
                if (row < 0) {
                    row = 0;
                }
                if (column < 0) {
                    column = 0;
                }
                String value = (String)editor.getCellEditorValue();
                this.dataModel.setValueAt(value, row, column);
                super.editingStopped(event);
            }
        };
        this.table.getSelectionModel().setSelectionMode(0);
        JTableHeader tableHeader = this.table.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        JPanel buttonPanel = new JPanel(new GridLayout(6, 1, 10, 5));
        buttonPanel.setBorder(new EmptyBorder(4, 2, 4, 4));
        CommonButton addButton = new CommonButton("Add");
        addButton.setMnemonic('A');
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RunParamsDialog.this.dataModel.addEmptyRow();
                int lastRow = RunParamsDialog.this.dataModel.getRowCount() - 1;
                RunParamsDialog.this.table.grabFocus();
                RunParamsDialog.this.table.getSelectionModel().setSelectionInterval(lastRow, lastRow);
                RunParamsDialog.this.table.editCellAt(lastRow, 0);
            }
        });
        CommonButton removeButton = new CommonButton("   Remove   ");
        removeButton.setMnemonic('R');
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RunParamsDialog.this.dataModel.removeRow(RunParamsDialog.this.table.getSelectedRow());
            }
        });
        CommonButton okButton = new CommonButton("OK");
        okButton.setMnemonic('O');
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RunParamsDialog.this.defineParams();
                RunParamsDialog.this.setVisible(false);
            }
        });
        CommonButton applyButton = new CommonButton("Apply");
        applyButton.setMnemonic('p');
        applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RunParamsDialog.this.defineParams();
            }
        });
        CommonButton cancelButton = new CommonButton("Cancel");
        cancelButton.setMnemonic('C');
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RunParamsDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(okButton);
        buttonPanel.add(applyButton);
        buttonPanel.add(cancelButton);
        JPanel leftPane = new JPanel(new BorderLayout());
        leftPane.setBorder(new EmptyBorder(4, 4, 4, 4));
        WHScrollPane tableScrollPane = new WHScrollPane(this.table);
        tableScrollPane.setBorder(new WHControlsBorder());
        leftPane.add((Component)tableScrollPane, "Center");
        contentPane.add((Component)leftPane, "Center");
        contentPane.add((Component)buttonPanel, "East");
        this.pack();
    }

    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunParamsDialog.this.setVisible(false);
            }
        };
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    private void defineParams() {
        ConfigPanel configPanel = this.ide.getActiveConfigPanel();
        if (configPanel != null) {
            LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
            for (String[] pair : this.params) {
                if (pair == null || pair[0] == null || "".equals(pair[0].trim()) || pair[1] == null) continue;
                paramMap.put(pair[0], pair[1]);
            }
            configPanel.setInitParams(paramMap);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 200);
    }

    public void setVisible(boolean b) {
        if (b) {
            ConfigPanel configPanel = this.ide.getActiveConfigPanel();
            if (configPanel != null) {
                this.params.clear();
                Map paramsMap = configPanel.getInitParams();
                if (paramsMap != null) {
                    for (Map.Entry entry : paramsMap.entrySet()) {
                        this.params.add(new String[]{(String)entry.getKey(), (String)entry.getValue()});
                    }
                }
            }
            this.dataModel.fireTableDataChanged();
        }
        super.setVisible(b);
        if (b) {
            this.table.grabFocus();
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return RunParamsDialog.this.params.size();
        }

        public Object getValueAt(int row, int col) {
            String[] pair = (String[])RunParamsDialog.this.params.get(row);
            return pair[col];
        }

        public String getColumnName(int column) {
            return column == 0 ? "Name" : "Value";
        }

        public void removeRow(int rowIndex) {
            int size = RunParamsDialog.this.params.size();
            if (rowIndex >= 0 && rowIndex < size) {
                RunParamsDialog.this.params.remove(rowIndex);
                this.fireTableDataChanged();
            }
        }

        public void addEmptyRow() {
            RunParamsDialog.this.params.add(new String[]{"", ""});
            this.fireTableDataChanged();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (rowIndex < this.getRowCount()) {
                String[] rowArray = (String[])RunParamsDialog.this.params.get(rowIndex);
                rowArray[columnIndex] = (String)value;
            }
        }
    }
}

