/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.webharvest.definition.BaseElementDef;
import org.webharvest.definition.ConstantDef;
import org.webharvest.definition.IElementDef;
import org.webharvest.definition.ScraperConfiguration;
import org.webharvest.gui.AutoCompleter;
import org.webharvest.gui.ConfigDocument;
import org.webharvest.gui.GuiUtils;
import org.webharvest.gui.Ide;
import org.webharvest.gui.NodeRenderer;
import org.webharvest.gui.PropertiesGrid;
import org.webharvest.gui.PropertiesGridModel;
import org.webharvest.gui.ResourceManager;
import org.webharvest.gui.ScraperExecutionThread;
import org.webharvest.gui.Settings;
import org.webharvest.gui.TextAreaAppender;
import org.webharvest.gui.TreeNodeInfo;
import org.webharvest.gui.ViewerFrame;
import org.webharvest.gui.XmlEditorScrollPane;
import org.webharvest.gui.XmlTextPane;
import org.webharvest.gui.component.MenuElements;
import org.webharvest.gui.component.ProportionalSplitPane;
import org.webharvest.gui.component.WHPopupMenu;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperRuntimeListener;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.web.HttpClientManager;
import org.xml.sax.InputSource;

public class ConfigPanel
extends JPanel
implements ScraperRuntimeListener,
TreeSelectionListener,
CaretListener {
    private static final String VIEW_RESULT_AS_TEXT = "View result as text";
    private static final String VIEW_RESULT_AS_XML = "View result as XML";
    private static final String VIEW_RESULT_AS_HTML = "View result as HTML";
    private static final String VIEW_RESULT_AS_IMAGE = "View result as image";
    private static final String VIEW_RESULT_AS_LIST = "View result as list";
    private static final String BASIC_CONFIG_SKELETION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<config>\n\t\n</config>";
    private XmlEditorScrollPane xmlEditorScrollPane;
    private Logger logger;
    private ConfigDocument configDocument;
    private Map initParams = null;
    private Ide ide;
    private ScraperConfiguration scraperConfiguration;
    private DefaultMutableTreeNode topNode;
    private DefaultTreeModel treeModel;
    private TreeNodeInfo selectedNodeInfo;
    private JTextArea logTextArea;
    private Map nodeInfos = new Hashtable();
    private NodeRenderer nodeRenderer = new NodeRenderer();
    private JSplitPane bottomSplitter;
    private JSplitPane leftSplitter;
    private JSplitPane leftView;
    private JScrollPane bottomView;
    private int leftDividerLocation = 0;
    private int bottomDividerLocation = 0;
    private XmlTextPane xmlPane;
    private JTree tree;
    private Scraper scraper;
    private PropertiesGrid propertiesGrid;
    private JMenuItem textViewMenuItem;
    private JMenuItem xmlViewMenuItem;
    private JMenuItem htmlViewMenuItem;
    private JMenuItem imageViewMenuItem;
    private JMenuItem listViewMenuItem;
    private JMenuItem logSelectAllMenuItem;
    private JMenuItem logClearAllMenuItem;

    public ConfigPanel(final Ide ide, String name) {
        super(new BorderLayout());
        this.ide = ide;
        this.topNode = new DefaultMutableTreeNode();
        this.treeModel = new DefaultTreeModel(this.topNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(this.nodeRenderer);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(this);
        final WHPopupMenu treePopupMenu = new WHPopupMenu();
        MenuElements.MenuItem menuItem = new MenuElements.MenuItem("Locate in source");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreePath path = ConfigPanel.this.tree.getSelectionPath();
                if (path != null) {
                    ConfigPanel.this.locateInSource((DefaultMutableTreeNode)path.getLastPathComponent(), false);
                    try {
                        int closingIndex;
                        int startPos = ConfigPanel.this.xmlPane.getCaretPosition();
                        String content = ConfigPanel.this.xmlPane.getDocument().getText(0, ConfigPanel.this.xmlPane.getDocument().getLength());
                        if (content != null && content.length() > startPos && (closingIndex = content.indexOf(62, startPos)) > startPos) {
                            ConfigPanel.this.xmlPane.select(startPos, closingIndex + 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    ConfigPanel.this.xmlPane.requestFocus();
                }
            }
        });
        treePopupMenu.add(menuItem);
        ((JPopupMenu)treePopupMenu).addSeparator();
        ViewerActionListener viewContentActionListener = new ViewerActionListener();
        this.textViewMenuItem = new MenuElements.MenuItem(VIEW_RESULT_AS_TEXT);
        this.textViewMenuItem.addActionListener(viewContentActionListener);
        treePopupMenu.add(this.textViewMenuItem);
        this.xmlViewMenuItem = new MenuElements.MenuItem(VIEW_RESULT_AS_XML);
        this.xmlViewMenuItem.addActionListener(viewContentActionListener);
        treePopupMenu.add(this.xmlViewMenuItem);
        this.htmlViewMenuItem = new MenuElements.MenuItem(VIEW_RESULT_AS_HTML);
        this.htmlViewMenuItem.addActionListener(viewContentActionListener);
        treePopupMenu.add(this.htmlViewMenuItem);
        this.imageViewMenuItem = new MenuElements.MenuItem(VIEW_RESULT_AS_IMAGE);
        this.imageViewMenuItem.addActionListener(viewContentActionListener);
        treePopupMenu.add(this.imageViewMenuItem);
        this.listViewMenuItem = new MenuElements.MenuItem(VIEW_RESULT_AS_LIST);
        this.listViewMenuItem.addActionListener(viewContentActionListener);
        treePopupMenu.add(this.listViewMenuItem);
        treePopupMenu.setOpaque(true);
        treePopupMenu.setLightWeightPopupEnabled(true);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || e.getButton() == 3) {
                    TreePath path = ConfigPanel.this.tree.getClosestPathForLocation(e.getX(), e.getY());
                    if (path != null) {
                        ConfigPanel.this.tree.setSelectionPath(path);
                    }
                    treePopupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.xmlPane = new XmlTextPane();
        this.xmlPane.addCaretListener(this);
        final AutoCompleter autoCompleter = new AutoCompleter(this.xmlPane);
        this.xmlPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && (e.getModifiers() & 2) != 0) {
                    autoCompleter.autoComplete();
                }
            }
        });
        this.xmlPane.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || e.getButton() == 3) {
                    ConfigPanel.this.xmlPane.setLastClickPoint(e.getPoint());
                    ide.getEditorPopupMenu().show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        this.configDocument = new ConfigDocument(this, name);
        try {
            this.configDocument.load(BASIC_CONFIG_SKELETION);
        }
        catch (IOException e) {
            GuiUtils.showErrorMessage(e.getMessage());
        }
        this.xmlEditorScrollPane = new XmlEditorScrollPane(this.xmlPane, this.ide.getSettings().isShowLineNumbersByDefault());
        this.propertiesGrid = new PropertiesGrid(this);
        JScrollPane propertiesView = new JScrollPane(this.propertiesGrid);
        propertiesView.setBorder(new EmptyBorder(0, 0, 0, 0));
        propertiesView.getViewport().setBackground(Color.white);
        this.leftView = new ProportionalSplitPane(0);
        this.leftView.setResizeWeight(0.8);
        this.leftView.setBorder(null);
        this.leftView.setTopComponent(treeView);
        this.leftView.setBottomComponent(propertiesView);
        this.leftView.setDividerLocation(0.8);
        this.leftView.setDividerSize(7);
        this.leftSplitter = new JSplitPane(1);
        this.leftSplitter.setBorder(null);
        this.leftSplitter.setLeftComponent(this.leftView);
        this.leftSplitter.setRightComponent(this.xmlEditorScrollPane);
        this.leftSplitter.setDividerSize(7);
        this.leftSplitter.setDividerLocation(250);
        this.logTextArea = new JTextArea();
        this.logTextArea.setFont(new Font("Courier New", 0, 11));
        this.logTextArea.setEditable(false);
        final WHPopupMenu logPopupMenu = new WHPopupMenu();
        this.logSelectAllMenuItem = new MenuElements.MenuItem("Select All");
        this.logSelectAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigPanel.this.logTextArea.requestFocus();
                ConfigPanel.this.logTextArea.selectAll();
            }
        });
        logPopupMenu.add(this.logSelectAllMenuItem);
        this.logClearAllMenuItem = new MenuElements.MenuItem("Clear All");
        this.logClearAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigPanel.this.logTextArea.setText("");
            }
        });
        logPopupMenu.add(this.logClearAllMenuItem);
        this.logTextArea.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || e.getButton() == 3) {
                    String text = ConfigPanel.this.logTextArea.getText();
                    ConfigPanel.this.logClearAllMenuItem.setEnabled(text != null && !"".equals(text));
                    ConfigPanel.this.logSelectAllMenuItem.setEnabled(text != null && !"".equals(text));
                    logPopupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        this.logger = Logger.getLogger((String)(this.toString() + System.currentTimeMillis()));
        this.logger.addAppender((Appender)new TextAreaAppender(this.logTextArea));
        this.bottomSplitter = new ProportionalSplitPane(0);
        this.bottomSplitter.setResizeWeight(1.0);
        this.bottomSplitter.setBorder(null);
        this.bottomSplitter.setTopComponent(this.leftSplitter);
        this.bottomSplitter.setDividerSize(7);
        this.bottomView = new JScrollPane(this.logTextArea);
        this.bottomView.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.bottomSplitter.setBottomComponent(this.bottomView);
        this.bottomSplitter.setDividerLocation(0.8);
        this.add((Component)this.bottomSplitter, "Center");
        if (!ide.getSettings().isShowHierarchyByDefault()) {
            this.showHierarchy();
        }
        if (!ide.getSettings().isShowLogByDefault()) {
            this.showLog();
        }
        this.updateControls();
    }

    public void caretUpdate(CaretEvent e) {
        this.ide.updateGUI();
    }

    private void updateControls() {
        boolean viewAllowed = false;
        if (this.scraper != null) {
            viewAllowed = this.scraper.getStatus() != 0;
        }
        this.textViewMenuItem.setEnabled(viewAllowed);
        this.xmlViewMenuItem.setEnabled(viewAllowed);
        this.htmlViewMenuItem.setEnabled(viewAllowed);
        this.imageViewMenuItem.setEnabled(viewAllowed);
        this.listViewMenuItem.setEnabled(viewAllowed);
    }

    private void releaseScraper() {
        if (this.scraper != null) {
            this.scraper.dispose();
            this.scraper = null;
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof TreeNodeInfo) {
            this.selectedNodeInfo = (TreeNodeInfo)userObject;
            PropertiesGridModel model = this.propertiesGrid.getPropertiesGridModel();
            if (model != null) {
                model.setProperties(this.selectedNodeInfo.getProperties(), this.selectedNodeInfo);
            }
        }
    }

    private void createNodes(DefaultMutableTreeNode root, IElementDef[] defs) {
        if (defs != null) {
            for (int i = 0; i < defs.length; ++i) {
                IElementDef elementDef = defs[i];
                if (elementDef instanceof ConstantDef) continue;
                TreeNodeInfo treeNodeInfo = new TreeNodeInfo(elementDef);
                this.nodeInfos.put(treeNodeInfo.getElementDef(), treeNodeInfo);
                DefaultMutableTreeNode node = treeNodeInfo.getNode();
                this.treeModel.insertNodeInto(node, root, root.getChildCount());
                this.createNodes(node, elementDef.getOperationDefs());
            }
        }
    }

    public void loadConfig(Object source) {
        try {
            if (source instanceof URL) {
                this.configDocument.load((URL)source);
            } else if (source instanceof File) {
                this.configDocument.load((File)source);
            } else {
                this.configDocument.load(source == null ? "" : source.toString());
            }
            this.refreshTree();
            InputSource in = new InputSource(new StringReader(this.xmlPane.getText()));
            ScraperConfiguration scraperConfiguration = new ScraperConfiguration(in);
            this.setScraperConfiguration(scraperConfiguration);
        }
        catch (IOException e) {
            GuiUtils.showErrorMessage(e.getMessage());
        }
    }

    public boolean refreshTree() {
        this.releaseScraper();
        this.xmlPane.clearMarkerLine();
        this.xmlPane.clearErrorLine();
        this.xmlPane.clearStopDebugLine();
        this.updateControls();
        String xmlContent = this.xmlPane.getText();
        InputSource in = new InputSource(new StringReader(xmlContent));
        try {
            ScraperConfiguration scraperConfiguration = new ScraperConfiguration(in);
            scraperConfiguration.setSourceFile(this.configDocument.getFile());
            scraperConfiguration.setUrl(this.configDocument.getUrl());
            this.setScraperConfiguration(scraperConfiguration);
            this.ide.setTabIcon(this, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = e.getMessage();
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.logger.error((Object)(errorMessage + "\n" + writer.getBuffer().toString()));
            this.ide.setTabIcon(this, ResourceManager.SMALL_ERROR_ICON);
            GuiUtils.showErrorMessage(errorMessage);
            return false;
        }
        return true;
    }

    private void setScraperConfiguration(ScraperConfiguration scraperConfiguration) {
        this.scraperConfiguration = scraperConfiguration;
        List operationDefs = scraperConfiguration.getOperations();
        IElementDef[] defs = new IElementDef[operationDefs.size()];
        Iterator it = operationDefs.iterator();
        int index = 0;
        while (it.hasNext()) {
            defs[index++] = (IElementDef)it.next();
        }
        this.topNode.removeAllChildren();
        this.nodeInfos.clear();
        this.createNodes(this.topNode, defs);
        this.treeModel.reload();
        this.expandTree();
    }

    private void expandTree() {
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            this.tree.expandRow(row);
        }
    }

    public void onNewProcessorExecution(Scraper scraper, BaseProcessor processor) {
        TreeNodeInfo nodeInfo;
        BaseElementDef elementDef = processor.getElementDef();
        if (elementDef != null && (nodeInfo = (TreeNodeInfo)this.nodeInfos.get(elementDef)) != null) {
            nodeInfo.increaseExecutionCount();
            this.setExecutingNode(nodeInfo);
            int lineNumber = this.locateInSource(nodeInfo.getNode(), true) - 1;
            if (this.xmlPane.getBreakpoints().isThereBreakpoint(lineNumber)) {
                scraper.pauseExecution();
                this.xmlPane.clearMarkerLine();
                this.xmlPane.setStopDebugLine(lineNumber);
                this.ide.setTabIcon(this, ResourceManager.SMALL_BREAKPOINT_ICON);
            } else if (this.ide.getSettings().isDynamicConfigLocate()) {
                this.xmlPane.setMarkerLine(lineNumber);
                this.xmlPane.repaint();
            }
        }
    }

    public void onExecutionStart(Scraper scraper) {
        this.xmlPane.clearStopDebugLine();
        this.xmlPane.clearErrorLine();
        this.xmlPane.clearMarkerLine();
        this.updateControls();
        this.ide.updateGUI();
    }

    public void onExecutionContinued(Scraper scraper) {
        this.xmlPane.clearStopDebugLine();
        this.xmlPane.clearErrorLine();
        this.xmlPane.clearMarkerLine();
        this.ide.updateGUI();
    }

    public void onExecutionPaused(Scraper scraper) {
        this.ide.updateGUI();
    }

    public void onExecutionEnd(Scraper scraper) {
        final Settings settings = this.ide.getSettings();
        if (settings.isDynamicConfigLocate()) {
            this.xmlPane.setEditable(true);
        }
        int status = scraper.getStatus();
        final String message = scraper.getMessage();
        if (status == 3) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigPanel.this.ide.setTabIcon(ConfigPanel.this, ResourceManager.SMALL_FINISHED_ICON);
                    if (settings.isShowFinishDialog()) {
                        GuiUtils.showInfoMessage("Configuration \"" + ConfigPanel.this.configDocument.getName() + "\" finished execution.");
                    }
                }
            });
        } else if (status == 4) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GuiUtils.showWarningMessage("Configuration \"" + ConfigPanel.this.configDocument.getName() + "\" aborted by user!");
                    ConfigPanel.this.ide.setTabIcon(ConfigPanel.this, ResourceManager.SMALL_FINISHED_ICON);
                }
            });
        } else if (status == 6 && message != null && !"".equals(message.trim())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GuiUtils.showWarningMessage("Configuration exited: " + message);
                    ConfigPanel.this.ide.setTabIcon(ConfigPanel.this, ResourceManager.SMALL_FINISHED_ICON);
                }
            });
        }
        TreeNodeInfo previousNodeInfo = this.nodeRenderer.getExecutingNodeInfo();
        this.setExecutingNode(null);
        if (previousNodeInfo != null) {
            this.treeModel.nodeChanged(previousNodeInfo.getNode());
        }
        this.xmlPane.clearMarkerLine();
        this.xmlPane.clearStopDebugLine();
        this.ide.updateGUI();
    }

    public void onProcessorExecutionFinished(Scraper scraper, BaseProcessor processor, Map properties) {
        TreeNodeInfo nodeInfo;
        BaseElementDef elementDef = processor.getElementDef();
        if (elementDef != null && (nodeInfo = (TreeNodeInfo)this.nodeInfos.get(elementDef)) != null) {
            List syncViews;
            PropertiesGridModel model;
            nodeInfo.setProperties(properties);
            if (nodeInfo == this.selectedNodeInfo && (model = this.propertiesGrid.getPropertiesGridModel()) != null) {
                model.setProperties(nodeInfo.getProperties(), nodeInfo);
            }
            if ((syncViews = nodeInfo.getSynchronizedViews()) != null) {
                for (int i = 0; i < syncViews.size(); ++i) {
                    ViewerFrame viewerFrame = (ViewerFrame)syncViews.get(i);
                    viewerFrame.setValue(properties);
                }
            }
        }
    }

    public void onExecutionError(Scraper scraper, Exception e) {
        Settings settings = this.ide.getSettings();
        if (settings.isDynamicConfigLocate()) {
            this.xmlPane.setEditable(true);
        }
        this.markException(e);
        String errorMessage = e.getMessage();
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        if (this.scraper != null) {
            this.scraper.getLogger().error((Object)(errorMessage + "\n" + writer.getBuffer().toString()));
        }
        if (settings.isShowFinishDialog()) {
            GuiUtils.showErrorMessage(errorMessage);
        }
        this.ide.setTabIcon(this, ResourceManager.SMALL_ERROR_ICON);
        this.ide.updateGUI();
        this.xmlPane.clearMarkerLine();
        this.xmlPane.clearStopDebugLine();
    }

    private void setExecutingNode(TreeNodeInfo nodeInfo) {
        TreeNodeInfo previousNodeInfo = this.nodeRenderer.getExecutingNodeInfo();
        if (previousNodeInfo != null) {
            this.treeModel.nodeChanged(previousNodeInfo.getNode());
        }
        this.nodeRenderer.setExecutingNodeInfo(nodeInfo);
        if (nodeInfo != null) {
            this.treeModel.nodeChanged(nodeInfo.getNode());
        }
    }

    public void markException(Exception e) {
        this.nodeRenderer.markException(e);
        TreeNodeInfo treeNodeInfo = this.nodeRenderer.getExecutingNodeInfo();
        if (treeNodeInfo != null) {
            this.treeModel.nodeChanged(treeNodeInfo.getNode());
            int line = this.locateInSource(treeNodeInfo.getNode(), true) - 1;
            this.xmlPane.setErrorLine(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runConfiguration() {
        boolean ok;
        if (this.scraper != null && this.scraper.getStatus() == 2) {
            Scraper scraper = this.scraper;
            synchronized (scraper) {
                this.scraper.notifyAll();
            }
            this.ide.setTabIcon(this, ResourceManager.SMALL_RUN_ICON);
        } else if ((this.scraper == null || this.scraper.getStatus() != 1) && (ok = this.refreshTree())) {
            Settings settings = this.ide.getSettings();
            this.scraper = new Scraper(this.scraperConfiguration, settings.getWorkingPath());
            this.scraper.addVariablesToContext(this.initParams);
            if (settings.isProxyEnabled()) {
                HttpClientManager httpClientManager = this.scraper.getHttpClientManager();
                int proxyPort = settings.getProxyPort();
                String proxyServer = settings.getProxyServer();
                if (proxyPort > 0) {
                    httpClientManager.setHttpProxy(proxyServer, proxyPort);
                } else {
                    httpClientManager.setHttpProxy(proxyServer);
                }
                if (settings.isProxyAuthEnabled()) {
                    String ntlmHost = settings.isNtlmAuthEnabled() ? settings.getNtlmHost() : null;
                    String ntlmDomain = settings.isNtlmAuthEnabled() ? settings.getNtlmDomain() : null;
                    httpClientManager.setHttpProxyCredentials(settings.getProxyUserename(), settings.getProxyPassword(), ntlmHost, ntlmDomain);
                }
            }
            this.scraper.setDebug(true);
            this.logTextArea.setText(null);
            this.scraper.getLogger().addAppender((Appender)new TextAreaAppender(this.logTextArea));
            this.scraper.addRuntimeListener(this);
            this.ide.setTabIcon(this, ResourceManager.SMALL_RUN_ICON);
            new ScraperExecutionThread(this.scraper).start();
        }
    }

    public Scraper getScraper() {
        return this.scraper;
    }

    public synchronized int getScraperStatus() {
        if (this.scraper != null) {
            return this.scraper.getStatus();
        }
        return -1;
    }

    public Ide getIde() {
        return this.ide;
    }

    public synchronized void stopScraperExecution() {
        if (this.scraper != null) {
            this.scraper.stopExecution();
        }
    }

    public synchronized void pauseScraperExecution() {
        if (this.scraper != null) {
            this.scraper.pauseExecution();
            this.ide.setTabIcon(this, ResourceManager.SMALL_PAUSED_ICON);
        }
    }

    private int locateInSource(DefaultMutableTreeNode treeNode, boolean locateAtLineBeginning) {
        Object userObject;
        if (treeNode != null && (userObject = treeNode.getUserObject()) instanceof TreeNodeInfo) {
            TreeNodeInfo treeNodeInfo = (TreeNodeInfo)userObject;
            BaseElementDef elementDef = (BaseElementDef)treeNodeInfo.getElementDef();
            int lineNumber = elementDef.getLineNumber();
            int columnNumber = elementDef.getColumnNumber();
            String content = null;
            try {
                int startIndex;
                content = this.xmlPane.getDocument().getText(0, this.xmlPane.getDocument().getLength());
                String[] lines = content.split("\n");
                int offset = 0;
                int lineCount = 1;
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i];
                    if (lineCount == lineNumber) {
                        offset += locateAtLineBeginning ? 1 : columnNumber;
                        break;
                    }
                    if (++lineCount > 2) {
                        ++offset;
                    }
                    offset += line.length();
                }
                if (offset < content.length()) {
                    content = content.substring(0, offset);
                }
                this.xmlPane.setCaretPosition((startIndex = content.lastIndexOf(60)) >= 0 ? startIndex : 0);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            return lineNumber;
        }
        return -1;
    }

    public void undo() {
        this.xmlPane.undo();
    }

    public void redo() {
        this.xmlPane.redo();
    }

    public String getXml() {
        return this.xmlPane.getText();
    }

    public XmlTextPane getXmlPane() {
        return this.xmlPane;
    }

    public JTree getTree() {
        return this.tree;
    }

    public XmlEditorScrollPane getXmlEditorScrollPane() {
        return this.xmlEditorScrollPane;
    }

    public void setConfigFile(File file) {
        if (this.scraperConfiguration != null) {
            this.scraperConfiguration.setSourceFile(file);
        }
    }

    public ConfigDocument getConfigDocument() {
        return this.configDocument;
    }

    public void showHierarchy() {
        boolean isVisible = this.leftView.isVisible();
        if (isVisible) {
            this.leftDividerLocation = this.leftSplitter.getDividerLocation();
        }
        this.leftView.setVisible(!isVisible);
        if (!isVisible) {
            this.leftSplitter.setDividerLocation(this.leftDividerLocation);
        }
    }

    public void showLog() {
        boolean isVisible = this.bottomView.isVisible();
        if (isVisible) {
            this.bottomDividerLocation = this.bottomSplitter.getDividerLocation();
        }
        this.bottomView.setVisible(!isVisible);
        if (!isVisible) {
            this.bottomSplitter.setDividerLocation(this.bottomDividerLocation);
        }
    }

    public boolean isHierarchyVisible() {
        return this.leftView.isVisible();
    }

    public boolean isLogVisible() {
        return this.bottomView.isVisible();
    }

    public Map getInitParams() {
        return this.initParams;
    }

    public void setInitParams(Map initParams) {
        this.initParams = initParams;
    }

    public void dispose() {
        if (this.configDocument != null) {
            this.configDocument.dispose();
        }
        if (this.scraper != null) {
            this.scraper.removeRuntimeListener(this);
            this.scraper = null;
        }
        this.xmlPane.removeCaretListener(this);
        this.tree.removeTreeSelectionListener(this);
        this.scraperConfiguration = null;
        this.ide = null;
        this.tree = null;
        this.treeModel = null;
        this.nodeInfos = null;
        this.nodeRenderer = null;
        this.configDocument = null;
        this.topNode = null;
        this.logger.removeAllAppenders();
    }

    private class ViewerActionListener
    implements ActionListener {
        private ViewerActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object userObject;
            DefaultMutableTreeNode treeNode;
            String actionCommand = e.getActionCommand();
            int viewType = 0;
            if (ConfigPanel.VIEW_RESULT_AS_HTML.equalsIgnoreCase(actionCommand)) {
                viewType = 2;
            } else if (ConfigPanel.VIEW_RESULT_AS_IMAGE.equalsIgnoreCase(actionCommand)) {
                viewType = 3;
            } else if (ConfigPanel.VIEW_RESULT_AS_LIST.equalsIgnoreCase(actionCommand)) {
                viewType = 4;
            } else if (ConfigPanel.VIEW_RESULT_AS_XML.equalsIgnoreCase(actionCommand)) {
                viewType = 1;
            }
            TreePath path = ConfigPanel.this.tree.getSelectionPath();
            if (path != null && (treeNode = (DefaultMutableTreeNode)path.getLastPathComponent()) != null && (userObject = treeNode.getUserObject()) instanceof TreeNodeInfo) {
                TreeNodeInfo treeNodeInfo = (TreeNodeInfo)userObject;
                Map properties = treeNodeInfo.getProperties();
                Object value = properties == null ? null : properties.get("[Value]");
                final ViewerFrame viewerFrame = new ViewerFrame(ConfigPanel.this.scraper, "[Value]", value, treeNodeInfo, viewType);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        viewerFrame.setVisible(true);
                        viewerFrame.toFront();
                    }
                });
            }
        }
    }
}

