/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JTabbedPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.webharvest.gui.BreakpointCollection;
import org.webharvest.gui.ConfigPanel;
import org.webharvest.gui.GuiUtils;
import org.webharvest.gui.Ide;
import org.webharvest.gui.XmlFileFilter;
import org.webharvest.gui.XmlTextPane;
import org.webharvest.utils.CommonUtil;

public class ConfigDocument
implements DocumentListener {
    private String name;
    private File file;
    private String url;
    private boolean isChanged = false;
    private Ide ide;
    private ConfigPanel configPanel;
    private XmlTextPane xmlPane;
    private int lineCount = 0;

    public ConfigDocument(ConfigPanel configPanel, String name) {
        this.configPanel = configPanel;
        this.ide = configPanel.getIde();
        this.xmlPane = configPanel.getXmlPane();
        this.name = name;
    }

    private void updateDocumentChanged(boolean changed) {
        this.isChanged = changed;
        if (changed) {
            this.configPanel.getXmlEditorScrollPane().onDocChanged();
        }
        this.updateGUI();
    }

    private void load(Reader reader) throws IOException {
        this.xmlPane.read(reader, null);
        Document document = this.xmlPane.getDocument();
        document.addDocumentListener(this);
        document.addUndoableEditListener(this.xmlPane.getUndoManager());
        document.putProperty("tabSize", new Integer(4));
        document.putProperty("autoIndentation", new Boolean(true));
        document.putProperty("tagCompletion", new Boolean(true));
        Document doc = this.xmlPane.getDocument();
        int len = doc.getLength();
        try {
            this.lineCount = CommonUtil.countChars(doc.getText(0, len), '\n', 0, len - 1) + 1;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.updateGUI();
    }

    void load(String text) throws IOException {
        this.load(new StringReader(text));
        this.updateDocumentChanged(false);
    }

    void load(File file) throws IOException {
        this.file = file;
        this.name = file.getName();
        String fileCharset = this.ide.getSettings().getFileCharset();
        this.load(new InputStreamReader((InputStream)new FileInputStream(file), fileCharset));
        this.ide.getSettings().addRecentFile(file.getAbsolutePath());
    }

    void load(URL url) throws IOException {
        this.url = url.toString();
        this.name = CommonUtil.getFileFromPath(this.url);
        this.load(new InputStreamReader((InputStream)url.getContent()));
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateDocumentChanged(true);
    }

    public void insertUpdate(DocumentEvent e) {
        try {
            Document document = this.xmlPane.getDocument();
            int docLen = document.getLength();
            String text = document.getText(0, docLen);
            int offset = e.getOffset();
            int linesTo = CommonUtil.countChars(text, '\n', 0, offset - 1) + 1;
            int linesFrom = CommonUtil.countChars(text, '\n', offset, docLen - 1);
            int linesAdded = linesTo + linesFrom - this.lineCount;
            this.lineCount = linesFrom + linesTo;
            if (linesAdded > 0) {
                BreakpointCollection breakpoints = this.xmlPane.getBreakpoints();
                breakpoints.updateBreakpoints(linesTo, linesAdded);
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        this.updateDocumentChanged(true);
    }

    public void removeUpdate(DocumentEvent e) {
        try {
            Document document = this.xmlPane.getDocument();
            int docLen = document.getLength();
            String text = document.getText(0, docLen);
            int offset = e.getOffset();
            int linesTo = CommonUtil.countChars(text, '\n', 0, offset - 1) + 1;
            int linesFrom = CommonUtil.countChars(text, '\n', offset, docLen - 1);
            int linesRemoved = this.lineCount - linesTo - linesFrom;
            this.lineCount = linesFrom + linesTo;
            if (linesRemoved > 0) {
                BreakpointCollection breakpoints = this.xmlPane.getBreakpoints();
                breakpoints.removeBreakpointsInRange(linesTo, linesTo + linesRemoved);
                breakpoints.updateBreakpoints(linesTo + linesRemoved + 1, -linesRemoved);
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        this.updateDocumentChanged(true);
    }

    public void saveConfigToFile(boolean isSaveAs) {
        JFileChooser fileChooser;
        int returnVal;
        if ((isSaveAs || this.file == null) && (returnVal = (fileChooser = GuiUtils.getFileChooser()).showSaveDialog(this.ide)) == 0) {
            this.file = fileChooser.getSelectedFile();
            if (fileChooser.getFileFilter() instanceof XmlFileFilter && !this.file.getName().toLowerCase().endsWith(".xml")) {
                this.file = new File(this.file.getAbsolutePath() + ".xml");
            }
            if (isSaveAs && this.file != null && this.file.exists()) {
                boolean toContinue;
                String msg = "File \"" + this.file.getAbsolutePath() + "\" already exists.\nAre you sure you want to overwrite it?";
                boolean bl = toContinue = GuiUtils.showWarningQuestionBox(msg, false) == 0;
                if (!toContinue) {
                    return;
                }
            }
            this.configPanel.setConfigFile(this.file);
        }
        if (this.file != null) {
            try {
                String charset = this.ide.getSettings().getFileCharset();
                CommonUtil.saveStringToFile(this.file, this.configPanel.getXml(), charset);
                this.name = this.file.getName();
                this.updateDocumentChanged(false);
                this.updateGUI();
                this.ide.getSettings().addRecentFile(this.file.getAbsolutePath());
            }
            catch (IOException e) {
                GuiUtils.showErrorMessage(e.getMessage());
            }
        }
    }

    public boolean offerToSaveIfChanged() {
        if (this.isChanged) {
            int result = GuiUtils.showWarningQuestionBox("Save file \"" + this.name + "\"?", true);
            if (result == 0) {
                this.saveConfigToFile(false);
            } else if (result == 2 || result == -1) {
                return false;
            }
        }
        return true;
    }

    private void updateGUI() {
        JTabbedPane tabbedPane = this.ide.getTabbedPane();
        int index = this.ide.findTabIndex(this.configPanel);
        if (index >= 0) {
            tabbedPane.setTitleAt(index, this.name);
            tabbedPane.setForegroundAt(index, this.isChanged ? Color.blue : Color.black);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void dispose() {
        this.ide = null;
        this.configPanel = null;
        this.xmlPane = null;
        this.file = null;
    }
}

