/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.wso2.carbon.coordination.core.services.CoordinationService;
import org.wso2.carbon.ntask.core.impl.TaskAxis2ConfigurationContextObserver;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.ntask.core.service.impl.TaskServiceImpl;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class TasksDSComponent {
    private final Log log = LogFactory.getLog(TasksDSComponent.class);
    private static RegistryService registryService;
    private static CoordinationService coodinationService;
    private static RealmService realmService;
    private static Scheduler scheduler;
    private static ConfigurationContextService configCtxService;
    private TaskService taskService;

    protected void activate(ComponentContext ctx) {
        try {
            scheduler = new StdSchedulerFactory().getScheduler();
            TasksDSComponent.getScheduler().start();
            if (this.getTaskService() == null) {
                this.taskService = new TaskServiceImpl();
            }
            BundleContext bundleContext = ctx.getBundleContext();
            bundleContext.registerService(TaskService.class.getName(), (Object)this.getTaskService(), null);
            bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new TaskAxis2ConfigurationContextObserver(this.getTaskService()), null);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Task service started");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error in intializing Tasks component", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext ctx) {
        this.taskService = null;
        if (TasksDSComponent.getScheduler() != null) {
            try {
                TasksDSComponent.getScheduler().shutdown();
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    protected void setRegistryService(RegistryService registryService) {
        TasksDSComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        TasksDSComponent.registryService = null;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    protected void setCoordinationService(CoordinationService coordinationService) {
        coodinationService = coordinationService;
    }

    protected void unsetCoordinationService(CoordinationService coordinationService) {
        coodinationService = null;
    }

    public static CoordinationService getCoordinationService() {
        return coodinationService;
    }

    protected void setRealmService(RealmService realmService) {
        TasksDSComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        TasksDSComponent.realmService = null;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    protected void setConfigurationContextService(ConfigurationContextService configCtxService) {
        TasksDSComponent.configCtxService = configCtxService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configCtxService) {
        TasksDSComponent.configCtxService = null;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configCtxService;
    }
}

