/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl;

import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.ntask.core.Task;

public class TaskQuartzJobAdapter
implements Job {
    private Task task;
    private int tenantId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        if (this.getTask() == null) {
            JobDataMap dataMap = ctx.getJobDetail().getJobDataMap();
            String taskClassName = dataMap.getString("__TASK_CLASS_NAME__");
            if (taskClassName == null) {
                throw new JobExecutionException("The task class is missing in the job data map");
            }
            try {
                this.task = (Task)Class.forName(taskClassName).newInstance();
                Map properties = (Map)dataMap.get((Object)"__TASK_PROPERTIES__");
                this.task.setProperties(properties);
                this.tenantId = Integer.parseInt((String)properties.get("__TENANT_ID_PROP__"));
                try {
                    SuperTenantCarbonContext.startTenantFlow();
                    SuperTenantCarbonContext.getCurrentContext().setTenantId(this.getTenantId());
                    this.task.init();
                }
                finally {
                    SuperTenantCarbonContext.endTenantFlow();
                }
            }
            catch (Exception e) {
                throw new JobExecutionException("Error in creating an object of task class: " + taskClassName, (Throwable)e);
            }
        }
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(this.getTenantId());
            this.getTask().execute();
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public Task getTask() {
        return this.task;
    }
}

